/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.repo.CacheLookupSearchContext;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.filesys.repo.ContentSearchContext;
import org.alfresco.filesys.repo.LinkMemoryNetworkFile;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.filesys.repo.NodeMonitorFactory;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.OpenOfficeContentNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.FileSharingException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateLockManager;
import org.alfresco.jlan.server.filesys.pseudo.MemoryNetworkFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileInterface;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFileList;
import org.alfresco.jlan.server.filesys.pseudo.PseudoNetworkFile;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.util.WildCard;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class ContentDiskDriver
extends AlfrescoDiskDriver
implements DiskInterface,
FileLockingInterface,
OpLockInterface,
DiskSizeInterface {
    private static final Log logger = LogFactory.getLog(ContentDiskDriver.class);
    private static final String KEY_STORE = "store";
    private static final String KEY_ROOT_PATH = "rootPath";
    private static final String KEY_RELATIVE_PATH = "relativePath";
    public static final int FileUnknown = -1;
    public static final int FileNotExist = 0;
    public static final int FileExists = 1;
    public static final int DirectoryExists = 2;
    public static final int CustomFileStatus = 3;
    public static final int FileRenamed = 3;
    public static final int DeleteOnClose = 4;
    public static final String AttrLinkNode = "ContentLinkNode";
    private static QName[] _copyProperties = new QName[]{ContentModel.PROP_AUTHOR, ContentModel.PROP_TITLE, ContentModel.PROP_DESCRIPTION};
    private static Set<String> _excludedNamespaces = new TreeSet<String>(Arrays.asList("http://www.alfresco.org/model/content/1.0", "http://www.alfresco.org/model/system/1.0"));
    private static final int DiskBlockSize = 512;
    private static final long DiskAllocationUnit = 32768L;
    private static final long DiskBlocksPerUnit = 64L;
    protected static final long DiskSizeDefault = 0x10000000000L;
    protected static final long DiskFreeDefault = 0x8000000000L;
    private CifsHelper cifsHelper;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private PermissionService permissionService;
    private FileFolderService fileFolderService;
    private NodeArchiveService nodeArchiveService;
    private LockService lockService;
    private DictionaryService dictionaryService;
    private AuthenticationContext authContext;
    private AuthenticationService authService;
    private SysAdminParams sysAdminParams;
    private BehaviourFilter policyBehaviourFilter;
    private NodeMonitorFactory m_nodeMonitorFactory;
    private static FileStateLockManager _lockManager;

    public ContentDiskDriver(CifsHelper cifsHelper) {
        this.cifsHelper = cifsHelper;
    }

    public final CifsHelper getCifsHelper() {
        return this.cifsHelper;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.authService;
    }

    public final AuthenticationContext getAuthenticationContext() {
        return this.authContext;
    }

    public final NodeService getNodeService() {
        return this.nodeService;
    }

    public final ContentService getContentService() {
        return this.contentService;
    }

    public final NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public final SearchService getSearchService() {
        return this.searchService;
    }

    public final FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public final PermissionService getPermissionService() {
        return this.permissionService;
    }

    public final NodeArchiveService getNodeArchiveService() {
        return this.nodeArchiveService;
    }

    public final LockService getLockService() {
        return this.lockService;
    }

    public BehaviourFilter getPolicyFilter() {
        return this.policyBehaviourFilter;
    }

    public final DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationContext(AuthenticationContext authContext) {
        this.authContext = authContext;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.fileFolderService = fileService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeMonitorFactory(NodeMonitorFactory nodeMonitorFactory) {
        this.m_nodeMonitorFactory = nodeMonitorFactory;
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyBehaviourFilter = policyFilter;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DeviceContext createContext(String shareName, ConfigElement cfg) throws DeviceContextException {
        ConfigElement offlineFiles;
        ConfigElement pseudoName;
        ContentContext context = null;
        try {
            ConfigElement storeElement = cfg.getChild(KEY_STORE);
            if (storeElement == null || storeElement.getValue() == null || storeElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: store");
            }
            String storeValue = storeElement.getValue();
            ConfigElement rootPathElement = cfg.getChild(KEY_ROOT_PATH);
            if (rootPathElement == null || rootPathElement.getValue() == null || rootPathElement.getValue().length() == 0) {
                throw new DeviceContextException("Device missing init value: rootPath");
            }
            String rootPath = rootPathElement.getValue();
            context = new ContentContext();
            context.setDeviceName(shareName);
            context.setStoreName(storeValue);
            context.setRootPath(rootPath);
            context.setSysAdminParams(this.sysAdminParams);
            ConfigElement relativePathElement = cfg.getChild(KEY_RELATIVE_PATH);
            if (relativePathElement != null) {
                String relPath = relativePathElement.getValue().replace('/', '\\');
                context.setRelativePath(relPath);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error during create context", (Throwable)ex);
        }
        ConfigElement urlFileElem = cfg.getChild("urlFile");
        if (urlFileElem != null && (pseudoName = urlFileElem.getChild("filename")) != null) {
            context.setURLFileName(pseudoName.getValue());
        }
        if ((offlineFiles = cfg.getChild("offlineFiles")) != null) {
            context.setOfflineFiles(true);
        }
        if (cfg.getChild("disableNodeMonitor") == null) {
            context.setDisableNodeMonitor(true);
        }
        if (cfg.getChild("disableOplocks") != null) {
            context.setDisableOplocks(true);
        }
        this.registerContext((DeviceContext)context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        super.registerContext(ctx);
        ContentContext context = (ContentContext)ctx;
        UserTransaction tx = this.getTransactionService().getUserTransaction(true);
        try {
            String storeValue;
            StoreRef storeRef;
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
            if (tx != null) {
                tx.begin();
            }
            if (!this.nodeService.exists(storeRef = new StoreRef(storeValue = context.getStoreName()))) {
                throw new DeviceContextException("Store not created prior to application startup: " + storeRef);
            }
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
            String rootPath = context.getRootPath();
            List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            NodeRef rootNodeRef = null;
            if (nodeRefs.size() > 1) {
                throw new DeviceContextException("Multiple possible roots for device: \n   root path: " + rootPath + "\n" + "   results: " + nodeRefs);
            }
            if (nodeRefs.size() == 0) {
                throw new DeviceContextException("No root found for device: \n   root path: " + rootPath);
            }
            rootNodeRef = (NodeRef)nodeRefs.get(0);
            String relPath = context.getRelativePath();
            if (relPath != null && relPath.length() > 0) {
                NodeRef relPathNode = this.cifsHelper.getNodeRef(rootNodeRef, relPath);
                if (!this.cifsHelper.isDirectory(relPathNode)) {
                    throw new DeviceContextException("Relative path is not a folder, " + relPath);
                }
                rootNodeRef = relPathNode;
            } else if (!this.cifsHelper.isDirectory(rootNodeRef)) {
                throw new DeviceContextException("Root node is not a folder type node");
            }
            tx.commit();
            tx = null;
            context.setRootNodeRef(rootNodeRef);
        }
        catch (Exception ex) {
            logger.error((Object)"Error during create context", (Throwable)ex);
        }
        finally {
            AuthenticationUtil.popAuthentication();
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        if (context.getOfflineFiles()) {
            this.cifsHelper.setMarkLockedFilesAsOffline(true);
            logger.info((Object)"Locked files will be marked as offline");
        }
        context.enableStateCache(true);
        context.getStateCache().setCaseSensitive(false);
        if (context.hasIOHandler()) {
            context.getIOHandler().initialize(this, context);
        }
        if (!context.getDisableNodeMonitor() && this.m_nodeMonitorFactory != null) {
            NodeMonitor nodeMonitor = this.m_nodeMonitorFactory.createNodeMonitor(this, context);
            context.setNodeMonitor(nodeMonitor);
        }
        _lockManager = new FileStateLockManager(context.getStateCache());
        if (context.getDisableOplocks()) {
            logger.warn((Object)("Oplock support disabled for filesystem " + ctx.getDeviceName()));
        }
        if (context.hasQuotaManager()) {
            try {
                context.getQuotaManager().startManager((DiskInterface)this, (DiskDeviceContext)context);
                logger.info((Object)"Quota manager enabled for filesystem");
            }
            catch (QuotaManagerException ex) {
                logger.error((Object)"Failed to start quota manager", (Throwable)ex);
            }
        }
    }

    public final boolean hasPseudoFileInterface(ContentContext context) {
        return context.hasPseudoFileInterface();
    }

    public final PseudoFileInterface getPseudoFileInterface(ContentContext context) {
        return context.getPseudoFileInterface();
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.cifsHelper.isReadOnly();
    }

    public org.alfresco.jlan.server.filesys.FileInfo getFileInformation(SrvSession session, TreeConnection tree, String path) throws IOException {
        this.beginReadTransaction(session);
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef infoParentNodeRef = ctx.getRootNode();
        if (path == null || path.length() == 0) {
            path = "\\";
        }
        String infoPath = path;
        try {
            NodeRef nodeRef;
            FileState fstate;
            ContentFileInfo finfo = null;
            if (this.hasPseudoFileInterface(ctx)) {
                String[] paths = FileName.splitPath((String)path);
                fstate = ctx.getStateCache().findFileState(paths[0]);
                if (fstate == null) {
                    NodeRef nodeRef2 = this.getNodeForPath(tree, paths[0]);
                    if (nodeRef2 != null) {
                        finfo = this.cifsHelper.getFileInformation(nodeRef2);
                    }
                    fstate = ctx.getStateCache().findFileState(paths[0], true);
                    fstate.setFileStatus(2);
                    fstate.setFilesystemObject((Object)nodeRef2);
                    this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(session, tree, paths[0]);
                    if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                        logger.debug((Object)("Added file state for pseudo files folder (getinfo) - " + paths[0]));
                    }
                } else if (!fstate.hasPseudoFiles()) {
                    if (!fstate.hasFilesystemObject()) {
                        fstate.setFilesystemObject((Object)this.getNodeForPath(tree, paths[0]));
                    }
                    this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(session, tree, paths[0]);
                    if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                        logger.debug((Object)("Added pseudo files for folder (exists) - " + paths[0]));
                    }
                }
                PseudoFile pfile = this.getPseudoFileInterface(ctx).getPseudoFile(session, tree, path);
                if (pfile != null) {
                    int attr;
                    if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                        logger.debug((Object)("getInfo using pseudo file info for " + path));
                    }
                    org.alfresco.jlan.server.filesys.FileInfo pseudoFileInfo = pfile.getFileInfo();
                    if (this.cifsHelper.isReadOnly() && ((attr = pseudoFileInfo.getFileAttributes()) & 1) == 0) {
                        pseudoFileInfo.setFileAttributes(++attr);
                    }
                    return pfile.getFileInfo();
                }
            }
            if ((nodeRef = this.getNodeForPath(tree, infoPath)) != null) {
                finfo = this.cifsHelper.getFileInformation(nodeRef);
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("getInfo using cached noderef for path " + path));
                }
            }
            if (finfo == null) {
                String[] paths = FileName.splitPath((String)path);
                if (paths[0] != null && paths[0].length() > 1 && (nodeRef = this.getNodeForPath(tree, paths[0])) != null) {
                    infoParentNodeRef = nodeRef;
                    infoPath = paths[1];
                    if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                        logger.debug((Object)("getInfo using cached noderef for parent " + path));
                    }
                }
                finfo = this.cifsHelper.getFileInformation(infoParentNodeRef, infoPath);
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("Getting file information: path=" + path + " file info: " + (Object)((Object)finfo)));
                }
            }
            if (finfo != null) {
                finfo.setFileId(path.hashCode());
                fstate = this.getStateForPath(tree, infoPath);
                if (fstate != null) {
                    if (fstate.hasAccessDateTime()) {
                        finfo.setAccessDateTime(fstate.getAccessDateTime());
                    }
                    if (fstate.hasChangeDateTime()) {
                        finfo.setChangeDateTime(fstate.getChangeDateTime());
                    }
                    if (fstate.hasModifyDateTime()) {
                        finfo.setModifyDateTime(fstate.getModifyDateTime());
                    }
                    if (fstate.hasAllocationSize() && fstate.getAllocationSize() > finfo.getSize()) {
                        finfo.setAllocationSize(fstate.getAllocationSize());
                    }
                } else {
                    fstate = ctx.getStateCache().findFileState(path, true);
                    if (finfo.isDirectory()) {
                        fstate.setFileStatus(2);
                    } else {
                        fstate.setFileStatus(1);
                    }
                    fstate.setFilesystemObject((Object)nodeRef);
                }
            }
            return finfo;
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Get file info - file not found, " + path));
            }
            throw e;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Get file info - access denied, " + path));
            }
            throw new AccessDeniedException("Get file information " + path);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)"Get file info error", (Throwable)ex);
            }
            throw new IOException("Get file information " + path);
        }
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attributes) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            long endTime;
            String searchFileSpec = searchPath;
            NodeRef searchRootNodeRef = ctx.getRootNode();
            FileState searchFolderState = null;
            this.beginReadTransaction(sess);
            String[] paths = FileName.splitPath((String)searchPath);
            if (ctx.hasStateCache() && paths[0] != null && paths[0].length() >= 1) {
                NodeRef nodeRef = this.getNodeForPath(tree, paths[0]);
                searchFolderState = this.getStateForPath(tree, paths[0]);
                if (searchFolderState == null) {
                    searchFolderState = ctx.getStateCache().findFileState(paths[0], true);
                }
                if (!searchFolderState.hasFilesystemObject()) {
                    searchFolderState.setFilesystemObject((Object)nodeRef);
                }
                if (this.hasPseudoFileInterface(ctx)) {
                    this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(sess, tree, paths[0]);
                }
                if (nodeRef != null) {
                    searchRootNodeRef = nodeRef;
                    searchFileSpec = paths[1];
                    if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                        logger.debug((Object)("Search using cached noderef for path " + searchPath));
                    }
                }
            }
            if (searchFileSpec.equals("*.*")) {
                searchFileSpec = "*";
            }
            long startTime = 0L;
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                startTime = System.currentTimeMillis();
            }
            List<NodeRef> results = this.cifsHelper.getNodeRefs(searchRootNodeRef, searchFileSpec);
            if (logger.isDebugEnabled() && ctx.hasDebug(4) && (endTime = System.currentTimeMillis()) - startTime > 500L) {
                logger.debug((Object)("Search for searchPath=" + searchPath + ", searchSpec=" + searchFileSpec + ", searchRootNode=" + searchRootNodeRef + " took " + (endTime - startTime) + "ms results=" + results.size()));
            }
            PseudoFileList pseudoList = null;
            if (sess instanceof SMBSrvSession && searchFolderState != null && searchFolderState.hasPseudoFiles()) {
                PseudoFile pfile;
                String fname;
                if (WildCard.containsWildcards((String)searchFileSpec)) {
                    pseudoList = searchFolderState.getPseudoFileList();
                    if (!searchFileSpec.equals("*") && pseudoList != null && pseudoList.numberOfFiles() > 0) {
                        WildCard wildCard = new WildCard(searchFileSpec, false);
                        PseudoFileList filterList = null;
                        for (int i = 0; i > pseudoList.numberOfFiles(); ++i) {
                            PseudoFile pseudoFile = pseudoList.getFileAt(i);
                            if (!wildCard.matchesPattern(pseudoFile.getFileName())) continue;
                            if (filterList == null) {
                                filterList = new PseudoFileList();
                            }
                            filterList.addFile(pseudoFile);
                        }
                        pseudoList = filterList;
                    }
                } else if ((results == null || results.size() == 0) && (fname = paths[1]) != null && (pfile = searchFolderState.getPseudoFileList().findFile(fname, true)) != null) {
                    pseudoList = new PseudoFileList();
                    pseudoList.addFile(pfile);
                }
            }
            ContentSearchContext searchCtx = null;
            if (searchFileSpec.equals("*")) {
                CacheLookupSearchContext cacheContext = new CacheLookupSearchContext(this.cifsHelper, results, searchFileSpec, pseudoList, paths[0], ctx.getStateCache());
                searchCtx = cacheContext;
                if (searchFolderState != null && searchFolderState.hasFilesystemObject()) {
                    ContentFileInfo finfo = this.cifsHelper.getFileInformation((NodeRef)searchFolderState.getFilesystemObject());
                    if (searchFolderState != null) {
                        if (searchFolderState.hasAccessDateTime()) {
                            finfo.setAccessDateTime(searchFolderState.getAccessDateTime());
                        }
                        if (searchFolderState.hasChangeDateTime()) {
                            finfo.setChangeDateTime(searchFolderState.getChangeDateTime());
                        }
                        if (searchFolderState.hasModifyDateTime()) {
                            finfo.setModifyDateTime(searchFolderState.getModifyDateTime());
                        }
                    }
                    cacheContext.setDotInfo(finfo);
                    if (searchFolderState.getPath().equals("\\")) {
                        cacheContext.setDotDotInfo(finfo);
                    } else {
                        int pos;
                        String parentPath = searchFolderState.getPath();
                        if (parentPath.endsWith("\\") && parentPath.length() > 1) {
                            parentPath = parentPath.substring(0, parentPath.length() - 1);
                        }
                        if ((pos = parentPath.lastIndexOf("\\")) != -1) {
                            parentPath = parentPath.substring(0, pos + 1);
                        }
                        FileState parentState = ctx.getStateCache().findFileState(parentPath);
                        NodeRef parentNode = null;
                        if (parentState != null) {
                            parentNode = (NodeRef)parentState.getFilesystemObject();
                        }
                        if (parentState == null || parentNode == null) {
                            parentNode = this.getNodeForPath(tree, parentPath);
                        }
                        finfo = this.cifsHelper.getFileInformation(parentNode);
                        if (parentState != null) {
                            if (parentState.hasAccessDateTime()) {
                                finfo.setAccessDateTime(parentState.getAccessDateTime());
                            }
                            if (parentState.hasChangeDateTime()) {
                                finfo.setChangeDateTime(parentState.getChangeDateTime());
                            }
                            if (parentState.hasModifyDateTime()) {
                                finfo.setModifyDateTime(parentState.getModifyDateTime());
                            }
                        }
                        cacheContext.setDotDotInfo(finfo);
                    }
                }
            } else {
                searchCtx = new ContentSearchContext(this.cifsHelper, results, searchFileSpec, pseudoList, paths[0]);
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)("Started search: search path=" + searchPath + " attributes=" + attributes + ", ctx=" + (Object)((Object)searchCtx)));
            }
            return searchCtx;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)("Start search - access denied, " + searchPath));
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(4)) {
                logger.debug((Object)"Start search", (Throwable)ex);
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String name) {
        ContentContext ctx = (ContentContext)tree.getContext();
        int status = -1;
        FileState fstate = null;
        try {
            if (ctx.hasStateCache()) {
                fstate = ctx.getStateCache().findFileState(name, true);
            }
            if (fstate != null && fstate.getFileStatus() != -1) {
                status = fstate.getFileStatus();
                if (status >= 3) {
                    status = 0;
                }
                if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                    logger.debug((Object)("Cache hit - fileExists() " + name + ", sts=" + status));
                }
            } else {
                if (this.hasPseudoFileInterface(ctx) && this.getPseudoFileInterface(ctx).isPseudoFile(sess, tree, name)) {
                    PseudoFile pfile;
                    String[] paths = FileName.splitPath((String)name);
                    fstate = ctx.getStateCache().findFileState(paths[0]);
                    if (fstate == null) {
                        if (this.fileExists(sess, tree, paths[0]) == 2) {
                            fstate = ctx.getStateCache().findFileState(paths[0], true);
                            fstate.setFileStatus(2);
                            this.beginReadTransaction(sess);
                            fstate.setFilesystemObject((Object)this.getNodeForPath(tree, paths[0]));
                            this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(sess, tree, paths[0]);
                            if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                                logger.debug((Object)("Added file state for pseudo files folder (exists) - " + paths[0]));
                            }
                        }
                    } else if (!fstate.hasPseudoFiles()) {
                        if (!fstate.hasFilesystemObject()) {
                            this.beginReadTransaction(sess);
                            fstate.setFilesystemObject((Object)this.getNodeForPath(tree, paths[0]));
                        }
                        this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(sess, tree, paths[0]);
                        if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                            logger.debug((Object)("Added pseudo files for folder (exists) - " + paths[0]));
                        }
                    }
                    if ((pfile = this.getPseudoFileInterface(ctx).getPseudoFile(sess, tree, name)) != null) {
                        status = 1;
                    } else if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                        logger.debug((Object)("Failed to find pseudo file (exists) - " + name));
                    }
                }
                if (status == -1) {
                    this.beginReadTransaction(sess);
                    org.alfresco.jlan.server.filesys.FileInfo info = this.getFileInformation(sess, tree, name);
                    status = info.isDirectory() ? 2 : 1;
                    if (fstate != null) {
                        fstate.setFileStatus(status);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            status = 0;
            if (fstate != null) {
                fstate.setFileStatus(status);
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("File exists error, " + name), (Throwable)e);
            }
            status = 0;
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
            logger.debug((Object)("File status determined: name=" + name + " status=" + this.fileStatusString(fstate.getFileStatus())));
        }
        return status;
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        this.beginReadTransaction(sess);
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            FileState fstate;
            if (this.hasPseudoFileInterface(ctx)) {
                String path = params.getPath();
                if (this.getPseudoFileInterface(ctx).isPseudoFile(sess, tree, path)) {
                    PseudoFile pfile;
                    String[] paths = FileName.splitPath((String)path);
                    fstate = ctx.getStateCache().findFileState(paths[0]);
                    if (fstate == null) {
                        if (this.fileExists(sess, tree, paths[0]) == 2) {
                            fstate = ctx.getStateCache().findFileState(paths[0], true);
                            fstate.setFileStatus(2);
                            this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(sess, tree, paths[0]);
                            if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                                logger.debug((Object)("Added file state for pseudo files folder (open) - " + paths[0]));
                            }
                        }
                    } else if (!fstate.hasPseudoFiles()) {
                        this.getPseudoFileInterface(ctx).addPseudoFilesToFolder(sess, tree, paths[0]);
                        if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                            logger.debug((Object)("Added pseudo files for folder (open) - " + paths[0]));
                        }
                    }
                    if ((pfile = this.getPseudoFileInterface(ctx).getPseudoFile(sess, tree, params.getPath())) != null) {
                        return pfile.getFile(params.getPath());
                    }
                    if (logger.isDebugEnabled() && ctx.hasDebug(32)) {
                        logger.debug((Object)("Failed to find pseudo file (open) - " + params.getPath()));
                    }
                }
            }
            NodeRef nodeRef = this.getNodeForPath(tree, params.getPath());
            if (params.hasAccessMode(1) && this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No read access to " + params.getFullPath());
            }
            if (params.hasAccessMode(2) && this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                throw new AccessDeniedException("No write access to " + params.getFullPath());
            }
            String lockTypeStr = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE));
            if (params.hasAccessMode(2) && lockTypeStr != null) {
                throw new AccessDeniedException("File is locked, no write access to " + params.getFullPath());
            }
            fstate = null;
            if (ctx.hasStateCache()) {
                fstate = ctx.getStateCache().findFileState(params.getPath());
                if (fstate != null) {
                    if (!fstate.exists()) {
                        throw new FileNotFoundException();
                    }
                } else {
                    fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                }
                boolean nosharing = false;
                if (params.getAccessMode() == 1180063 && !params.getPath().toLowerCase().endsWith(".exe")) {
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Execute access mode, path" + params.getPath()));
                        logger.debug((Object)("  Fstate=" + fstate));
                    }
                    throw new AccessDeniedException("Invalid access mode");
                }
                if (fstate.getOpenCount() > 0) {
                    if (params.getSecurityLevel() == 2 && params.getProcessId() == fstate.getProcessId()) {
                        nosharing = false;
                    } else if (params.isReadOnlyAccess() && (fstate.getSharedAccess() & 1) != 0) {
                        nosharing = false;
                    } else {
                        if ((params.isReadWriteAccess() || params.isWriteOnlyAccess()) && (fstate.getSharedAccess() & 2) == 0) {
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Sharing mode disallows write access path=" + params.getPath()));
                            }
                            throw new AccessDeniedException("Sharing mode (write)");
                        }
                        if (fstate.getSharedAccess() == 0) {
                            nosharing = true;
                        } else if ((fstate.getSharedAccess() & params.getSharedAccess()) != params.getSharedAccess()) {
                            nosharing = true;
                        } else if (params.getSharedAccess() == 0) {
                            nosharing = true;
                        }
                    }
                }
                if (nosharing && !params.getPath().equals("\\")) {
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Sharing violation path=" + params.getPath() + ", sharing=0x" + Integer.toHexString(fstate.getSharedAccess())));
                    }
                    throw new FileSharingException("File already open, " + params.getPath());
                }
                fstate.setSharedAccess(params.getSharedAccess());
                fstate.setProcessId(params.getProcessId());
                if (logger.isDebugEnabled() && fstate.getOpenCount() == 0 && ctx.hasDebug(1)) {
                    logger.debug((Object)("Path " + params.getPath() + ", sharing=0x" + Integer.toHexString(params.getSharedAccess()) + ", PID=" + params.getProcessId()));
                }
            }
            NodeRef linkRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LINK_DESTINATION);
            NodeRefNetworkFile netFile = null;
            if (linkRef == null) {
                if (tree.openFileCount() > 0) {
                    for (int idx = 0; idx < tree.getFileTableLength() && netFile == null; ++idx) {
                        ContentNetworkFile contentFile;
                        NetworkFile curFile = tree.findFile(idx);
                        if (curFile == null || !(curFile instanceof ContentNetworkFile) || (contentFile = (ContentNetworkFile)curFile).getProcessId() != params.getProcessId() || !contentFile.getFullName().equalsIgnoreCase(params.getFullPath())) continue;
                        if (params.isReadWriteAccess() && contentFile.getGrantedAccess() == 2 || params.isReadOnlyAccess() && contentFile.getGrantedAccess() == 0) {
                            netFile = contentFile;
                            contentFile.incrementOpenCount();
                            if (!logger.isDebugEnabled() || !ctx.hasDebug(1)) continue;
                            logger.debug((Object)("Re-use existing file open Path " + params.getPath() + ", PID=" + params.getProcessId() + ", params=" + (params.isReadOnlyAccess() ? "ReadOnly" : "Write") + ", file=" + (contentFile.getGrantedAccess() == 0 ? "ReadOnly" : "Write")));
                            continue;
                        }
                        if (!logger.isDebugEnabled() || !ctx.hasDebug(1)) continue;
                        logger.debug((Object)("Not re-using file path=" + params.getPath() + ", readWrite=" + (params.isReadWriteAccess() ? "true" : "false") + ", readOnly=" + (params.isReadOnlyAccess() ? "true" : "false") + ", grantedAccess=" + contentFile.getGrantedAccessAsString()));
                    }
                }
                if (netFile == null) {
                    netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.cifsHelper, nodeRef, params, sess);
                }
            } else {
                String srvName = null;
                SMBServer cifsServer = (SMBServer)sess.getServer().getConfiguration().findServer("CIFS");
                srvName = cifsServer != null ? cifsServer.getServerName() : InetAddress.getLocalHost().getHostName();
                String path = this.getPathForNode(tree, linkRef);
                path = path.replace('\\', '/');
                StringBuilder urlStr = new StringBuilder();
                urlStr.append("[InternetShortcut]\r\n");
                urlStr.append("URL=file://");
                urlStr.append(srvName);
                urlStr.append("/");
                urlStr.append(tree.getSharedDevice().getName());
                urlStr.append(path);
                urlStr.append("\r\n");
                byte[] urlData = urlStr.toString().getBytes();
                ContentFileInfo fInfo = this.cifsHelper.getFileInformation(nodeRef);
                fInfo.setFileSize(urlData.length);
                netFile = new LinkMemoryNetworkFile(fInfo.getFileName(), urlData, fInfo, nodeRef);
                netFile.setFullName(params.getPath());
            }
            if (netFile != null) {
                netFile.setFileId(params.getPath().hashCode());
            }
            if (params.isOverwrite() && netFile != null) {
                netFile.truncateFile(0L);
            }
            if (ctx.hasStateCache()) {
                if (fstate == null) {
                    fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                }
                fstate.incrementOpenCount();
                fstate.setFilesystemObject((Object)nodeRef);
                netFile.setFileState(fstate);
                if (fstate.hasAccessDateTime()) {
                    netFile.setAccessDate(fstate.getAccessDateTime());
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Opened network file: path=" + params.getPath() + " file open parameters=" + params + " network file=" + (Object)((Object)netFile)));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Open file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Open file " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Open file " + params.getFullPath());
        }
    }

    public NetworkFile createFile(SrvSession sess, final TreeConnection tree, final FileOpenParams params) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            Pair<String, NodeRef> result = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Pair<String, NodeRef>>(){

                @Override
                public Pair<String, NodeRef> call() throws IOException {
                    String[] paths;
                    NodeRef deviceRootNodeRef = ctx.getRootNode();
                    String path = params.getPath();
                    String parentPath = null;
                    if (ctx.hasStateCache() && (paths = FileName.splitPath((String)path))[0] != null && paths[0].length() > 1) {
                        NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, paths[0]);
                        if (nodeRef != null) {
                            deviceRootNodeRef = nodeRef;
                            path = paths[1];
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                            }
                        }
                        parentPath = paths[0];
                    }
                    NodeRef nodeRef = ContentDiskDriver.this.cifsHelper.createNode(deviceRootNodeRef, path, ContentModel.TYPE_CONTENT);
                    ContentDiskDriver.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT, null);
                    return new Pair(parentPath, (Object)nodeRef);
                }
            });
            FileState parentState = null;
            String parentPath = (String)result.getFirst();
            if (parentPath != null && (parentState = this.getStateForPath(tree, parentPath)) == null && ctx.hasStateCache()) {
                parentState = ctx.getStateCache().findFileState(parentPath, true);
            }
            ContentNetworkFile netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.cifsHelper, (NodeRef)result.getSecond(), params, sess);
            netFile.setGrantedAccess(2);
            netFile.setProcessId(params.getProcessId());
            netFile.truncateFile(0L);
            if (netFile != null) {
                netFile.setFileId(params.getPath().hashCode());
            }
            if (ctx.hasStateCache()) {
                FileState fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                if (fstate != null) {
                    fstate.setSharedAccess(params.getSharedAccess());
                    fstate.setProcessId(params.getProcessId());
                    fstate.setFileStatus(1);
                    fstate.incrementOpenCount();
                    fstate.setFilesystemObject(result.getSecond());
                    fstate.setAllocationSize(params.getAllocationSize());
                    netFile.setFileState(fstate);
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Create file, state=" + fstate));
                    }
                }
                if (parentState != null) {
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Created file: path=" + params.getPath() + " file open parameters=" + params + " node=" + result.getSecond() + " network file=" + (Object)((Object)netFile)));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create file - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create file " + params.getFullPath());
        }
        catch (ContentIOException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create file - content I/O error, " + params.getFullPath()));
            }
            throw new DiskFullException("Create file " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Create file error", (Throwable)ex);
            }
            throw new IOException("Create file " + params.getFullPath());
        }
    }

    public void createDirectory(SrvSession sess, final TreeConnection tree, final FileOpenParams params) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            Pair<String, NodeRef> result = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Pair<String, NodeRef>>(){

                @Override
                public Pair<String, NodeRef> call() throws IOException {
                    String[] paths;
                    NodeRef deviceRootNodeRef = ctx.getRootNode();
                    String path = params.getPath();
                    String parentPath = null;
                    if (ctx.hasStateCache() && (paths = FileName.splitPath((String)path))[0] != null && paths[0].length() > 1) {
                        NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, paths[0]);
                        if (nodeRef != null) {
                            deviceRootNodeRef = nodeRef;
                            path = paths[1];
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Create file using cached noderef for path " + paths[0]));
                            }
                        }
                        parentPath = paths[0];
                    }
                    NodeRef nodeRef = ContentDiskDriver.this.cifsHelper.createNode(deviceRootNodeRef, path, ContentModel.TYPE_FOLDER);
                    return new Pair(parentPath, (Object)nodeRef);
                }
            });
            FileState parentState = null;
            String parentPath = (String)result.getFirst();
            if (parentPath != null && (parentState = this.getStateForPath(tree, parentPath)) == null && ctx.hasStateCache()) {
                parentState = ctx.getStateCache().findFileState(parentPath, true);
            }
            if (ctx.hasStateCache()) {
                FileState fstate = ctx.getStateCache().findFileState(params.getPath(), true);
                if (fstate != null) {
                    fstate.setFileStatus(2);
                    fstate.setFilesystemObject(result.getSecond());
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Create folder, state=" + fstate));
                    }
                }
                if (parentState != null) {
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Created directory: path=" + params.getPath() + " file open params=" + params + " node=" + result.getSecond()));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Create directory - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create directory " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Create directory error", (Throwable)ex);
            }
            throw new IOException("Create directory " + params.getFullPath());
        }
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, final String dir) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        final NodeRef deviceRootNodeRef = ctx.getRootNode();
        try {
            NodeRef nodeRef = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<NodeRef>(){

                @Override
                public NodeRef call() throws IOException {
                    NodeRef nodeRef = ContentDiskDriver.this.cifsHelper.getNodeRef(deviceRootNodeRef, dir);
                    if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                        if (ContentDiskDriver.this.cifsHelper.isFolderEmpty(nodeRef)) {
                            ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                            return nodeRef;
                        }
                        throw new DirectoryNotEmptyException(dir);
                    }
                    return null;
                }
            });
            if (nodeRef != null && ctx.hasStateCache()) {
                ctx.getStateCache().removeFileState(dir);
                String[] paths = FileName.splitPath((String)dir);
                if (paths[0] != null && paths[0].length() > 1) {
                    FileState parentState = this.getStateForPath(tree, paths[0]);
                    if (parentState == null && ctx.hasStateCache()) {
                        parentState = ctx.getStateCache().findFileState(paths[0], true);
                    }
                    parentState.updateModifyDateTime();
                }
            }
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Deleted directory: directory=" + dir + " node=" + nodeRef));
            }
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Delete directory - file not found, " + dir));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)("Delete directory - access denied, " + dir));
            }
            throw new AccessDeniedException("Delete directory " + dir);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete directory", (Throwable)ex);
            }
            throw new IOException("Delete directory " + dir);
        }
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Flush file=" + file.getFullName()));
        }
        file.flushFile();
    }

    public void closeFile(SrvSession sess, TreeConnection tree, final NetworkFile file) throws IOException {
        FileState finalFileState;
        Pair<NodeRef, Boolean> result;
        final ContentContext ctx = (ContentContext)tree.getContext();
        FileState toUpdate = null;
        if (file instanceof ContentNetworkFile) {
            ContentNetworkFile contentFile;
            FileState fstate;
            if (ctx.hasStateCache() && (fstate = ctx.getStateCache().findFileState(file.getFullName())) != null) {
                if (fstate.decrementOpenCount() == 0) {
                    fstate.setSharedAccess(7);
                }
                if (!file.hasDeleteOnClose() && fstate.hasModifyDateTime() && fstate.hasFilesystemObject()) {
                    toUpdate = fstate;
                }
            }
            if ((contentFile = (ContentNetworkFile)file).decrementOpenCount() > 0) {
                if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                    logger.debug((Object)("Deferred file close, path=" + file.getFullName() + ", openCount=" + contentFile.getOpenCount()));
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Last reference to file, closing, path=" + file.getFullName() + ", access=" + file.getGrantedAccessAsString() + ", fid=" + file.getProtocolId() + ", modified=" + contentFile.isModified()));
            }
        }
        long fileSize = 0L;
        if (ctx.hasQuotaManager() && file.hasDeleteOnClose() && file instanceof ContentNetworkFile) {
            ContentNetworkFile contentFile = (ContentNetworkFile)file;
            if (!contentFile.hasContent()) {
                contentFile.openContent(false, false);
            }
            fileSize = contentFile.getFileSize();
        }
        if ((result = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Pair<NodeRef, Boolean>>(finalFileState = toUpdate){
            final /* synthetic */ FileState val$finalFileState;
            {
                this.val$finalFileState = fileState;
            }

            @Override
            public Pair<NodeRef, Boolean> call() throws IOException {
                OpenOfficeContentNetworkFile ooFile;
                if (file instanceof OpenOfficeContentNetworkFile && (ooFile = (OpenOfficeContentNetworkFile)file).truncatedToZeroLength()) {
                    ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("OpenOffice file truncation update only, inhibit versioning, " + file.getFullName()));
                    }
                }
                if (this.val$finalFileState != null && file instanceof ContentNetworkFile) {
                    NodeRef nodeRef = (NodeRef)this.val$finalFileState.getFilesystemObject();
                    ContentNetworkFile contentFile = (ContentNetworkFile)file;
                    if (!contentFile.isModified() && ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                        ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                        if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                            logger.debug((Object)("Timestamp update only, inhibit versioning, " + file.getFullName()));
                        }
                    }
                    ContentDiskDriver.this.getPolicyFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                    Date modifyDate = new Date(this.val$finalFileState.getModifyDateTime());
                    ContentDiskDriver.this.nodeService.setProperty(nodeRef, ContentModel.PROP_MODIFIED, (Serializable)modifyDate);
                    if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                        logger.debug((Object)("Updated modification timestamp, " + file.getFullName() + ", modTime=" + modifyDate));
                    }
                }
                file.closeFile();
                if (file.hasDeleteOnClose() && file instanceof NodeRefNetworkFile) {
                    NodeRefNetworkFile nodeNetFile = (NodeRefNetworkFile)file;
                    NodeRef nodeRef = nodeNetFile.getNodeRef();
                    if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                        try {
                            boolean isVersionable;
                            block15: {
                                isVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                                try {
                                    ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                                }
                                catch (Exception ex) {
                                    if (RetryingTransactionHelper.extractRetryCause(ex) != null) {
                                        if (ex instanceof RuntimeException) {
                                            throw (RuntimeException)ex;
                                        }
                                        throw new AlfrescoRuntimeException("Error during delete on close, " + file.getFullName(), (Throwable)ex);
                                    }
                                    if (!logger.isWarnEnabled() || !ctx.hasDebug(1)) break block15;
                                    logger.warn((Object)("Error during delete on close, " + file.getFullName()), (Throwable)ex);
                                }
                            }
                            return new Pair((Object)nodeRef, (Object)isVersionable);
                        }
                        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
                            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                                logger.debug((Object)("Delete on close - access denied, " + file.getFullName()));
                            }
                            throw new AccessDeniedException("Delete on close " + file.getFullName());
                        }
                    }
                }
                return null;
            }
        })) != null) {
            if (ctx.hasQuotaManager()) {
                ctx.getQuotaManager().releaseSpace(sess, tree, file.getFileId(), file.getFullName(), fileSize);
            }
            if (ctx.hasStateCache()) {
                if (((Boolean)result.getSecond()).booleanValue()) {
                    FileState fState = ctx.getStateCache().findFileState(file.getFullName(), true);
                    fState.setFileStatus(4);
                    fState.setExpiryTime(System.currentTimeMillis() + 60000L);
                    fState.setFilesystemObject(result.getFirst());
                } else {
                    ctx.getStateCache().removeFileState(file.getFullName());
                }
            }
        } else if (file.hasDeleteOnClose() && (file instanceof PseudoNetworkFile || file instanceof MemoryNetworkFile) && this.hasPseudoFileInterface(ctx)) {
            this.getPseudoFileInterface(ctx).deletePseudoFile(sess, tree, file.getFullName());
        }
        if (logger.isDebugEnabled() && (ctx.hasDebug(1) || ctx.hasDebug(64))) {
            logger.debug((Object)("Closed file: network file=" + file + " delete on close=" + file.hasDeleteOnClose()));
            if (!file.hasDeleteOnClose() && file instanceof ContentNetworkFile) {
                ContentNetworkFile cFile = (ContentNetworkFile)file;
                logger.debug((Object)("  File " + file.getFullName() + ", version=" + this.nodeService.getProperty(cFile.getNodeRef(), ContentModel.PROP_VERSION_LABEL)));
            }
        }
    }

    public void deleteFile(final SrvSession sess, final TreeConnection tree, final String name) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            if (this.hasPseudoFileInterface(ctx) && this.getPseudoFileInterface(ctx).isPseudoFile(sess, tree, name)) {
                PseudoFile pfile;
                String[] paths = FileName.splitPath((String)name);
                FileState fstate = ctx.getStateCache().findFileState(paths[0]);
                if (fstate != null && (pfile = this.getPseudoFileInterface(ctx).getPseudoFile(sess, tree, name)) != null) {
                    this.getPseudoFileInterface(ctx).deletePseudoFile(sess, tree, name);
                    return;
                }
            }
            final QuotaManager quotaMgr = ctx.getQuotaManager();
            Callable<Void> postTxn = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Callable<Void>>(){

                @Override
                public Callable<Void> call() throws IOException {
                    final NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, name);
                    Callable<Void> result = null;
                    if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                        final org.alfresco.jlan.server.filesys.FileInfo fInfo = quotaMgr == null ? null : ContentDiskDriver.this.getFileInformation(sess, tree, name);
                        final boolean isVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                        ContentDiskDriver.this.fileFolderService.delete(nodeRef);
                        result = new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                if (ctx.hasStateCache()) {
                                    if (isVersionable) {
                                        FileState delState = ctx.getStateCache().findFileState(name, true);
                                        delState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                        delState.setFileStatus(4);
                                        delState.setFilesystemObject((Object)nodeRef);
                                    } else {
                                        ctx.getStateCache().removeFileState(name);
                                    }
                                    String[] paths = FileName.splitPath((String)name);
                                    if (paths[0] != null && paths[0].length() > 1) {
                                        FileState parentState = ContentDiskDriver.this.getStateForPath(tree, paths[0]);
                                        if (parentState == null && ctx.hasStateCache()) {
                                            parentState = ctx.getStateCache().findFileState(paths[0], true);
                                        }
                                        parentState.updateModifyDateTime();
                                    }
                                }
                                if (quotaMgr != null) {
                                    quotaMgr.releaseSpace(sess, tree, fInfo.getFileId(), name, fInfo.getSize());
                                }
                                return null;
                            }
                        };
                    }
                    if (logger.isDebugEnabled() && (ctx.hasDebug(1) || ctx.hasDebug(64))) {
                        logger.debug((Object)("Deleted file: " + name + ", node=" + nodeRef));
                    }
                    return result;
                }
            });
            postTxn.call();
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file - access denied (locked)");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file - access denied");
            }
            throw new AccessDeniedException("Delete " + name);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete file error", (Throwable)ex);
            }
            IOException ioe = new IOException("Delete file " + name);
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public void renameFile(final SrvSession sess, final TreeConnection tree, final String oldName, final String newName) throws IOException {
        this.beginReadTransaction(sess);
        final ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
            logger.debug((Object)("Rename oldName=" + oldName + ", newName=" + newName));
        }
        try {
            final NodeRef nodeToMoveRef = this.getNodeForPath(tree, oldName);
            if (nodeToMoveRef != null && this.nodeService.getProperty(nodeToMoveRef, ContentModel.PROP_LINK_DESTINATION) != null) {
                throw new AccessDeniedException("Cannot rename link nodes");
            }
            String[] splitPaths = FileName.splitPath((String)newName);
            final NodeRef targetFolderRef = this.getNodeForPath(tree, splitPaths[0]);
            final String name = splitPaths[1];
            String[] oldPaths = FileName.splitPath((String)oldName);
            final boolean sameFolder = splitPaths[0].equalsIgnoreCase(oldPaths[0]);
            final FileState oldState = ctx.getStateCache().findFileState(oldName, true);
            boolean isFolder = this.cifsHelper.isDirectory(nodeToMoveRef);
            if (isFolder || !sameFolder) {
                if (oldState != null) {
                    ctx.getStateCache().renameFileState(newName, oldState, true);
                }
                this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Void>(){

                    @Override
                    public Void call() throws IOException {
                        if (sameFolder) {
                            ContentDiskDriver.this.cifsHelper.rename(nodeToMoveRef, name);
                        } else {
                            ContentDiskDriver.this.cifsHelper.move(nodeToMoveRef, targetFolderRef, name);
                        }
                        return null;
                    }
                });
                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                    logger.debug((Object)("  Renamed " + (isFolder ? "folder" : "file") + " using " + (sameFolder ? "rename" : "move")));
                }
            } else {
                final int newExists = this.fileExists(sess, tree, newName);
                final FileState newState = ctx.getStateCache().findFileState(newName, true);
                List<Runnable> postTxn = this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<List<Runnable>>(){

                    @Override
                    public List<Runnable> call() throws IOException {
                        LinkedList<Runnable> postTxn = new LinkedList<Runnable>();
                        NodeRef targetNodeRef = null;
                        boolean isFromVersionable = ContentDiskDriver.this.nodeService.hasAspect(nodeToMoveRef, ContentModel.ASPECT_VERSIONABLE);
                        boolean typesCompatible = true;
                        if (newExists == 1) {
                            targetNodeRef = ContentDiskDriver.this.getNodeForPath(tree, newName);
                        } else if (newState.getFileStatus() == 3) {
                            QName newType;
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Using renamed node, " + newState));
                            }
                            NodeRef newStateNode = (NodeRef)newState.getFilesystemObject();
                            QName oldType = ContentDiskDriver.this.nodeService.getType(nodeToMoveRef);
                            if (oldType.equals((Object)(newType = ContentDiskDriver.this.nodeService.getType(newStateNode)))) {
                                ContentDiskDriver.this.cloneNodeAspects(name, newStateNode, nodeToMoveRef, ctx);
                            } else {
                                targetNodeRef = ContentDiskDriver.this.cifsHelper.createNode(ctx.getRootNode(), newName, newType);
                                typesCompatible = false;
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Created new node for " + newName + " type " + newType));
                                }
                                ContentDiskDriver.this.cloneNodeAspects(name, newStateNode, targetNodeRef, ctx);
                            }
                        } else if (newState.getFileStatus() == 4) {
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Restoring delete-on-close node, " + newState));
                            }
                            NodeRef archivedNode = ContentDiskDriver.this.getNodeArchiveService().getArchivedNode((NodeRef)newState.getFilesystemObject());
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Found archived node " + archivedNode));
                            }
                            if (archivedNode != null) {
                                NodeRef linkNode;
                                targetNodeRef = ContentDiskDriver.this.getNodeService().restoreNode(archivedNode, null, null, null);
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)("  Restored node " + targetNodeRef + ", version=" + ContentDiskDriver.this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_VERSION_LABEL)));
                                }
                                if ((linkNode = (NodeRef)newState.findAttribute(ContentDiskDriver.AttrLinkNode)) != null && ContentDiskDriver.this.nodeService.exists(linkNode)) {
                                    ContentDiskDriver.this.cloneNodeAspects(name, linkNode, targetNodeRef, ctx);
                                    if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                        NodeRef mainNodeRef;
                                        logger.debug((Object)("  Moved aspects from linked node " + linkNode));
                                        if (ContentDiskDriver.this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_WORKING_COPY) && (mainNodeRef = (NodeRef)ContentDiskDriver.this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_COPY_REFERENCE)) != null) {
                                            LockType lockTyp = ContentDiskDriver.this.lockService.getLockType(mainNodeRef);
                                            logger.debug((Object)("  Main node ref lock type = " + (Object)((Object)lockTyp)));
                                        }
                                    }
                                }
                            }
                        } else if (isFromVersionable) {
                            targetNodeRef = ContentDiskDriver.this.cifsHelper.createNode(ctx.getRootNode(), newName, ContentDiskDriver.this.nodeService.getType(nodeToMoveRef));
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Created new node for " + newName));
                            }
                            ContentDiskDriver.this.cloneNodeAspects(name, nodeToMoveRef, targetNodeRef, ctx);
                        }
                        if (!(isFromVersionable || !typesCompatible || targetNodeRef != null && ContentDiskDriver.this.nodeService.hasAspect(targetNodeRef, ContentModel.ASPECT_VERSIONABLE))) {
                            ContentDiskDriver.this.cifsHelper.rename(nodeToMoveRef, name);
                            postTxn.add(new Runnable(){

                                public void run() {
                                    newState.setFileStatus(1);
                                    newState.setFilesystemObject((Object)nodeToMoveRef);
                                    oldState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                    oldState.setFileStatus(3);
                                    oldState.setFilesystemObject((Object)nodeToMoveRef);
                                }
                            });
                            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                logger.debug((Object)("  Use standard rename for " + name + "(versionable=" + isFromVersionable + ", targetNodeRef=" + targetNodeRef + ")"));
                            }
                        } else {
                            if (targetNodeRef == null) {
                                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                    logger.debug((Object)"  No target node for rename");
                                }
                                throw new AccessDeniedException("No target node for file rename");
                            }
                            ContentDiskDriver.this.copyContentData(sess, tree, nodeToMoveRef, targetNodeRef, newName);
                            final NodeRef finalTargetNodeRef = targetNodeRef;
                            postTxn.add(new Runnable(){

                                public void run() {
                                    newState.setFileStatus(1);
                                    newState.setFilesystemObject((Object)finalTargetNodeRef);
                                    oldState.setExpiryTime(System.currentTimeMillis() + 15000L);
                                    oldState.setFileStatus(4);
                                    oldState.setFilesystemObject((Object)nodeToMoveRef);
                                    oldState.addAttribute(ContentDiskDriver.AttrLinkNode, (Object)finalTargetNodeRef);
                                    if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                                        logger.debug((Object)("  Cached delete state for " + oldName));
                                    }
                                }
                            });
                            ContentDiskDriver.this.nodeService.deleteNode(nodeToMoveRef);
                        }
                        return postTxn;
                    }
                });
                for (Runnable runnable : postTxn) {
                    runnable.run();
                }
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("Rename file - access denied, " + oldName));
            }
            throw new AccessDeniedException("Rename file " + oldName);
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)"Rename file", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Node locked " + oldName);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)"Rename file", (Throwable)ex);
            }
            throw new AccessDeniedException("Rename file " + oldName);
        }
    }

    public void setFileInformation(SrvSession sess, final TreeConnection tree, final String name, final org.alfresco.jlan.server.filesys.FileInfo info) throws IOException {
        final ContentContext ctx = (ContentContext)tree.getContext();
        try {
            if (this.hasPseudoFileInterface(ctx) && this.getPseudoFileInterface(ctx).isPseudoFile(sess, tree, name)) {
                return;
            }
            final FileState fstate = this.getStateForPath(tree, name);
            this.doInWriteTransaction(sess, new AlfrescoDiskDriver.CallableIO<Pair<Boolean, Boolean>>(){

                @Override
                public Pair<Boolean, Boolean> call() throws IOException {
                    NodeRef nodeRef = ContentDiskDriver.this.getNodeForPath(tree, name);
                    if (ContentDiskDriver.this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                        throw new AccessDeniedException("No write access to " + name);
                    }
                    if (ContentDiskDriver.this.permissionService.hasPermission(nodeRef, "Delete") == AccessStatus.DENIED) {
                        throw new AccessDeniedException("No delete access to " + name);
                    }
                    ContentDiskDriver.this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    if (info.hasSetFlag(1024) && info.hasDeleteOnClose()) {
                        String lockTypeStr;
                        if (ContentDiskDriver.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_LOCKABLE) && (lockTypeStr = (String)((Object)ContentDiskDriver.this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCK_TYPE))) != null) {
                            throw new AccessDeniedException("Node locked, cannot mark for delete");
                        }
                        if (ContentDiskDriver.this.fileFolderService.exists(nodeRef)) {
                            boolean isFolder = true;
                            if (fstate != null) {
                                isFolder = fstate.isDirectory();
                            } else {
                                ContentFileInfo cInfo = ContentDiskDriver.this.cifsHelper.getFileInformation(nodeRef);
                                if (cInfo != null && !cInfo.isDirectory()) {
                                    isFolder = false;
                                }
                            }
                            if (isFolder && !ContentDiskDriver.this.cifsHelper.isFolderEmpty(nodeRef)) {
                                throw new DirectoryNotEmptyException(name);
                            }
                        }
                        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                            logger.debug((Object)("Set deleteOnClose=true file=" + name));
                        }
                    }
                    HashMap<QName, Date> auditableProps = new HashMap<QName, Date>(5);
                    if (info.hasSetFlag(16)) {
                        Date createDate = new Date(info.getCreationDateTime());
                        auditableProps.put(ContentModel.PROP_CREATED, createDate);
                    }
                    if (info.hasSetFlag(8)) {
                        Date modifyDate = new Date(info.getModifyDateTime());
                        auditableProps.put(ContentModel.PROP_MODIFIED, modifyDate);
                    }
                    if (auditableProps.size() > 0) {
                        ContentDiskDriver.this.getPolicyFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                        ContentDiskDriver.this.nodeService.addProperties(nodeRef, auditableProps);
                        if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                            logger.debug((Object)("Set auditable props: " + auditableProps + " file=" + name));
                        }
                    }
                    return null;
                }
            });
            if (fstate != null) {
                if (info.hasSetFlag(1024) && info.hasDeleteOnClose() || info.hasSetFlag(16)) {
                    fstate.updateChangeDateTime();
                }
                if (info.hasSetFlag(8)) {
                    fstate.updateChangeDateTime();
                    fstate.updateModifyDateTime(0L);
                }
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)("Set file information - access denied, " + name));
            }
            throw new AccessDeniedException("Set file information " + name);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(8)) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Set file information " + name);
        }
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long size) throws IOException {
        FileState fstate;
        ContentNetworkFile contentFile;
        ContentContext ctx = (ContentContext)tree.getContext();
        long allocSize = 0L;
        long releaseSize = 0L;
        QuotaManager quotaMgr = ctx.getQuotaManager();
        if (ctx.hasQuotaManager()) {
            if (file instanceof ContentNetworkFile) {
                contentFile = (ContentNetworkFile)file;
                if (!contentFile.hasContent()) {
                    contentFile.openContent(false, false);
                }
            } else {
                throw new IOException("Invalid file class type, " + file.getClass().getName());
            }
            if (size > file.getFileSize()) {
                allocSize = size - file.getFileSize();
                quotaMgr.allocateSpace(sess, tree, file, allocSize);
            } else {
                releaseSize = file.getFileSize() - size;
            }
        }
        if (file instanceof ContentNetworkFile && (fstate = (contentFile = (ContentNetworkFile)file).getFileState()) != null && size > fstate.getAllocationSize()) {
            fstate.setAllocationSize(size);
        }
        try {
            file.truncateFile(size);
        }
        catch (IOException ex) {
            if (allocSize > 0L && quotaMgr != null) {
                quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, allocSize);
            }
            throw ex;
        }
        if (releaseSize > 0L && quotaMgr != null) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, releaseSize);
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Truncated file: network file=" + file + " size=" + size));
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferPosition, int size, long fileOffset) throws IOException {
        int count;
        ContentNetworkFile contentFile;
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        if (file instanceof ContentNetworkFile && !(contentFile = (ContentNetworkFile)file).hasContent()) {
            this.beginReadTransaction(sess);
        }
        if ((count = file.readFile(buffer, size, bufferPosition, fileOffset)) == -1) {
            count = 0;
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Read bytes from file: network file=" + file + " buffer size=" + buffer.length + " buffer pos=" + bufferPosition + " size=" + size + " file offset=" + fileOffset + " bytes read=" + count));
        }
        return count;
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        ContentNetworkFile contentFile = (ContentNetworkFile)file;
        if (!contentFile.hasContent()) {
            this.beginReadTransaction(sess);
        }
        return file.seekFile(pos, typ);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferOffset, int size, long fileOffset) throws IOException {
        ContentNetworkFile contentFile;
        if (file instanceof ContentNetworkFile && !(contentFile = (ContentNetworkFile)file).hasContent()) {
            this.beginReadTransaction(sess);
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        QuotaManager quotaMgr = ctx.getQuotaManager();
        long curSize = file.getFileSize();
        if (quotaMgr != null) {
            long extendSize = 0L;
            long endOfWrite = fileOffset + (long)size;
            if (endOfWrite > curSize) {
                extendSize = endOfWrite - file.getFileSize();
                quotaMgr.allocateSpace(sess, tree, file, extendSize);
            }
        }
        file.writeFile(buffer, size, bufferOffset, fileOffset);
        if (quotaMgr != null && file.getFileSize() < curSize) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), file.getFullName(), curSize - file.getFileSize());
        }
        if (logger.isDebugEnabled() && ctx.hasDebug(2)) {
            logger.debug((Object)("Wrote bytes to file: network file=" + file + " buffer size=" + buffer.length + " size=" + size + " file offset=" + fileOffset));
        }
        return size;
    }

    public NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        FileState fstate;
        ContentContext ctx = (ContentContext)tree.getContext();
        if (ctx.hasStateCache() && (fstate = ctx.getStateCache().findFileState(path)) != null && fstate.hasFilesystemObject() && fstate.exists()) {
            if (this.fileFolderService.exists((NodeRef)fstate.getFilesystemObject())) {
                fstate.setExpiryTime(System.currentTimeMillis() + 120000L);
                return (NodeRef)fstate.getFilesystemObject();
            }
            ctx.getStateCache().removeFileState(path);
        }
        return this.cifsHelper.getNodeRef(ctx.getRootNode(), path);
    }

    public String getPathForNode(TreeConnection tree, NodeRef nodeRef) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        List<FileInfo> linkPaths = null;
        try {
            linkPaths = this.fileFolderService.getNamePath(ctx.getRootNode(), nodeRef);
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException ex) {
            throw new FileNotFoundException();
        }
        StringBuilder pathStr = new StringBuilder();
        for (FileInfo fInfo : linkPaths) {
            pathStr.append('\\');
            pathStr.append(fInfo.getName());
        }
        return pathStr.toString();
    }

    public FileState getStateForPath(TreeConnection tree, String path) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        FileState fstate = null;
        if (ctx.hasStateCache()) {
            fstate = ctx.getStateCache().findFileState(path);
        }
        return fstate;
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        return _lockManager;
    }

    public OpLockManager getOpLockManager(SrvSession sess, TreeConnection tree) {
        return _lockManager;
    }

    public boolean isOpLocksEnabled(SrvSession sess, TreeConnection tree) {
        ContentContext ctx = (ContentContext)tree.getContext();
        return !ctx.getDisableOplocks();
    }

    private void copyContentData(SrvSession sess, TreeConnection tree, NodeRef fromNode, NodeRef toNode, String newName) {
        ContentData content = (ContentData)this.nodeService.getProperty(fromNode, ContentModel.PROP_CONTENT);
        if (newName != null) {
            content = ContentData.setMimetype((ContentData)content, (String)this.mimetypeService.guessMimetype(newName));
        }
        this.nodeService.setProperty(toNode, ContentModel.PROP_CONTENT, (Serializable)content);
    }

    private void cloneNodeAspects(String newName, NodeRef fromNode, NodeRef toNode, ContentContext ctx) {
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_LOCKABLE)) {
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_LOCKABLE);
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_LOCKABLE, null);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + ContentModel.ASPECT_LOCKABLE + " to new document"));
            }
        }
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_WORKING_COPY)) {
            HashMap<QName, Serializable> workingCopyProperties = new HashMap<QName, Serializable>(1);
            workingCopyProperties.put(ContentModel.PROP_WORKING_COPY_OWNER, this.nodeService.getProperty(fromNode, ContentModel.PROP_WORKING_COPY_OWNER));
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_WORKING_COPY, workingCopyProperties);
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_WORKING_COPY);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + ContentModel.ASPECT_WORKING_COPY + " to new document"));
            }
        }
        if (this.nodeService.hasAspect(fromNode, ContentModel.ASPECT_COPIEDFROM)) {
            NodeRef copiedFromNode = (NodeRef)this.nodeService.getProperty(fromNode, ContentModel.PROP_COPY_REFERENCE);
            HashMap<QName, NodeRef> hashMap = new HashMap<QName, NodeRef>(1);
            hashMap.put(ContentModel.PROP_COPY_REFERENCE, copiedFromNode);
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_COPIEDFROM, hashMap);
            this.nodeService.removeAspect(fromNode, ContentModel.ASPECT_COPIEDFROM);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)("  Moved aspect " + ContentModel.ASPECT_COPIEDFROM + " to new document"));
            }
            if (this.lockService.getLockType(copiedFromNode) == null) {
                this.lockService.lock(copiedFromNode, LockType.READ_ONLY_LOCK);
                if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                    logger.debug((Object)("  Re-locked copied from node " + copiedFromNode));
                }
            }
        }
        for (QName qName : this.nodeService.getAspects(fromNode)) {
            if (_excludedNamespaces.contains(qName.getNamespaceURI())) continue;
            this.nodeService.addAspect(toNode, qName, null);
        }
        for (Map.Entry entry : this.nodeService.getProperties(fromNode).entrySet()) {
            QName propName = (QName)entry.getKey();
            if (_excludedNamespaces.contains(propName.getNamespaceURI())) continue;
            this.nodeService.setProperty(toNode, propName, (Serializable)entry.getValue());
        }
        String newNameNorm = newName.toLowerCase();
        if (newNameNorm.endsWith(".tmp") || newNameNorm.endsWith(".temp")) {
            if (this.nodeService.hasAspect(toNode, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.removeAspect(toNode, ContentModel.ASPECT_VERSIONABLE);
            }
            this.nodeService.addAspect(toNode, ContentModel.ASPECT_TEMPORARY, null);
            if (logger.isDebugEnabled() && ctx.hasDebug(64)) {
                logger.debug((Object)"  Removed versionable aspect from temp file");
            }
        }
        for (QName propName : _copyProperties) {
            Serializable nodeProp = this.nodeService.getProperty(fromNode, propName);
            if (nodeProp == null) continue;
            this.nodeService.setProperty(toNode, propName, nodeProp);
        }
    }

    private final String fileStatusString(int sts) {
        String fstatus = "Unknown";
        switch (sts) {
            case -1: {
                fstatus = "Unknown";
                break;
            }
            case 0: {
                fstatus = "NotExist";
                break;
            }
            case 1: {
                fstatus = "FileExists";
                break;
            }
            case 2: {
                fstatus = "DirectoryExists";
                break;
            }
            case 3: {
                fstatus = "FileRenamed";
                break;
            }
            case 4: {
                fstatus = "DeleteOnClose";
            }
        }
        return fstatus;
    }

    public void getDiskInformation(DiskDeviceContext ctx, SrvDiskInfo diskDev) throws IOException {
        diskDev.setBlockSize(512);
        diskDev.setBlocksPerAllocationUnit(64L);
        long freeSpace = this.contentService.getStoreFreeSpace();
        long totalSpace = this.contentService.getStoreTotalSpace();
        if (totalSpace == -1L) {
            totalSpace = 0x10000000000L;
            freeSpace = 0x8000000000L;
        }
        diskDev.setTotalUnits(totalSpace / 32768L);
        diskDev.setFreeUnits(freeSpace / 32768L);
    }
}

