/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.MSOfficeContentNetworkFile;
import org.alfresco.filesys.repo.NodeRefNetworkFile;
import org.alfresco.filesys.repo.OpenOfficeContentNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentNetworkFile
extends NodeRefNetworkFile {
    private static final Log logger = LogFactory.getLog(ContentNetworkFile.class);
    private NodeService nodeService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private FileChannel channel;
    private ContentAccessor content;
    private String preUpdateContentURL;
    private boolean modified;
    private boolean writableChannel;

    public static ContentNetworkFile createFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, CifsHelper cifsHelper, NodeRef nodeRef, FileOpenParams params, SrvSession sess) {
        ContentFileInfo fileInfo;
        String path = params.getPath();
        ContentNetworkFile netFile = null;
        netFile = ContentNetworkFile.isMSOfficeSpecialFile(path, sess, nodeService, nodeRef) ? new MSOfficeContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path) : (ContentNetworkFile.isOpenOfficeSpecialFile(path, sess, nodeService, nodeRef) ? new OpenOfficeContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path) : new ContentNetworkFile(nodeService, contentService, mimetypeService, nodeRef, path));
        if (params.isReadOnlyAccess()) {
            netFile.setGrantedAccess(0);
        } else {
            netFile.setGrantedAccess(2);
        }
        try {
            fileInfo = cifsHelper.getFileInformation(nodeRef, "");
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("File not found when creating network file: " + nodeRef, (Throwable)e);
        }
        if (fileInfo.isDirectory()) {
            netFile.setAttributes(16);
        } else {
            netFile.setFileSize(fileInfo.getSize());
        }
        if (fileInfo.hasCreationDateTime()) {
            netFile.setCreationDate(fileInfo.getCreationDateTime());
        }
        if (fileInfo.hasModifyDateTime()) {
            netFile.setModifyDate(fileInfo.getModifyDateTime());
        }
        if (fileInfo.hasAccessDateTime()) {
            netFile.setAccessDate(fileInfo.getAccessDateTime());
        }
        netFile.setAttributes(fileInfo.getFileAttributes());
        netFile.setProcessId(params.getProcessId());
        if (netFile.isReadOnly()) {
            netFile.setGrantedAccess(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create file node=" + nodeRef + ", param=" + params + ", netfile=" + (Object)((Object)netFile)));
        }
        return netFile;
    }

    protected ContentNetworkFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, NodeRef nodeRef, String name) {
        super(name, nodeRef);
        this.setFullName(name);
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.mimetypeService = mimetypeService;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getFullName());
        str.append(",");
        str.append(this.getNodeRef().getId());
        str.append(",channel=");
        str.append(this.channel);
        if (this.channel != null) {
            str.append(this.writableChannel ? "(Write)" : "(Read)");
        }
        if (this.modified) {
            str.append(",modified");
        }
        str.append("]");
        return str.toString();
    }

    private boolean isWritable() {
        int access = this.getGrantedAccess();
        return access == 2 || access == 1;
    }

    public final boolean hasContent() {
        return this.content != null;
    }

    protected void openContent(boolean write, boolean trunc) throws AccessDeniedException, AlfrescoRuntimeException {
        if (this.isDirectory()) {
            throw new AlfrescoRuntimeException("Unable to open channel for a directory network file: " + (Object)((Object)this));
        }
        if (write && !this.writableChannel && this.channel != null) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException ex) {
                logger.error((Object)"Error closing read-only channel", (Throwable)ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to writable channel for " + this.getName()));
            }
        } else if (this.channel != null) {
            return;
        }
        if (write && !this.isWritable()) {
            throw new AccessDeniedException("The network file was created for read-only: " + (Object)((Object)this));
        }
        this.content = null;
        this.preUpdateContentURL = null;
        if (write) {
            this.content = this.contentService.getWriter(this.getNodeRef(), ContentModel.PROP_CONTENT, false);
            ContentData preUpdateContentData = (ContentData)this.nodeService.getProperty(this.getNodeRef(), ContentModel.PROP_CONTENT);
            if (preUpdateContentData != null) {
                this.preUpdateContentURL = preUpdateContentData.getContentUrl();
            }
            this.writableChannel = true;
            this.channel = ((ContentWriter)this.content).getFileChannel(trunc);
        } else {
            this.content = this.contentService.getReader(this.getNodeRef(), ContentModel.PROP_CONTENT);
            this.content = FileContentReader.getSafeContentReader((ContentReader)this.content, I18NUtil.getMessage((String)"content.content_missing"), this.getNodeRef(), this.content);
            this.writableChannel = false;
            this.channel = ((ContentReader)this.content).getFileChannel();
        }
        if (this.channel != null) {
            try {
                this.setFileSize(this.channel.size());
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
            this.setClosed(false);
        }
    }

    public void closeFile() throws IOException {
        if (this.isDirectory()) {
            this.setClosed(true);
            return;
        }
        if (!this.hasContent()) {
            this.setClosed(true);
            return;
        }
        if (this.modified) {
            boolean contentChanged;
            NodeRef contentNodeRef = this.getNodeRef();
            if (this.channel != null) {
                if (this.content.getMimetype() == null || this.content.getMimetype().equals("application/octet-stream")) {
                    String filename = (String)((Object)this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_NAME));
                    String mimetype = this.mimetypeService.guessMimetype(filename);
                    this.content.setMimetype(mimetype);
                }
                this.channel.position(0L);
                BufferedInputStream is = new BufferedInputStream(Channels.newInputStream(this.channel));
                ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
                Charset charset = charsetFinder.getCharset((InputStream)is, this.content.getMimetype());
                this.content.setEncoding(charset.name());
                this.channel.close();
                this.channel = null;
            }
            ContentData contentData = this.content.getContentData();
            ContentReader postUpdateContentReader = ((ContentWriter)this.content).getReader();
            AuthenticationUtil.RunAsWork<ContentReader> getReader = new AuthenticationUtil.RunAsWork<ContentReader>(){

                public ContentReader doWork() throws Exception {
                    return ContentNetworkFile.this.preUpdateContentURL == null ? null : ContentNetworkFile.this.contentService.getRawReader(ContentNetworkFile.this.preUpdateContentURL);
                }
            };
            ContentReader preUpdateContentReader = (ContentReader)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getReader, (String)AuthenticationUtil.getSystemUserName());
            boolean bl = contentChanged = this.preUpdateContentURL == null || !AbstractContentReader.compareContentReaders(preUpdateContentReader, postUpdateContentReader);
            if (contentChanged) {
                this.nodeService.removeAspect(contentNodeRef, ContentModel.ASPECT_NO_CONTENT);
                try {
                    this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
                catch (ContentQuotaException qe) {
                    throw new DiskFullException(qe.getMessage());
                }
            }
            AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                public void afterCommit() {
                    ContentNetworkFile.this.content = null;
                    ContentNetworkFile.this.preUpdateContentURL = null;
                    ContentNetworkFile.this.setClosed(true);
                }
            });
        } else if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void truncateFile(long size) throws IOException {
        try {
            if (!this.hasContent() && size == 0L) {
                this.openContent(true, true);
            } else {
                this.openContent(true, false);
                this.channel.truncate(size);
            }
        }
        catch (ContentIOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening file " + this.getFullName() + " for write"), (Throwable)ex);
            }
            throw new DiskFullException("Failed to open " + this.getFullName() + " for write");
        }
        this.modified = true;
        this.setFileSize(size);
        if (this.getFileState() != null) {
            this.getFileState().updateModifyDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncate file=" + (Object)((Object)this) + ", size=" + size));
        }
    }

    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        try {
            this.openContent(true, false);
        }
        catch (ContentIOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error opening file " + this.getFullName() + " for write"), (Throwable)ex);
            }
            throw new DiskFullException("Failed to open " + this.getFullName() + " for write");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.write(byteBuffer, fileOffset);
        this.modified = true;
        this.incrementWriteCount();
        this.setFileSize(this.channel.size());
        if (this.getFileState() != null) {
            this.getFileState().updateModifyDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Write file=" + (Object)((Object)this) + ", size=" + count));
        }
    }

    public int readFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.openContent(false, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, position, length);
        int count = this.channel.read(byteBuffer, fileOffset);
        if (count < 0) {
            count = 0;
        }
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read file=" + (Object)((Object)this) + " read=" + count));
        }
        return count;
    }

    public void openFile(boolean createFlag) throws IOException {
    }

    public long seekFile(long pos, int typ) throws IOException {
        this.openContent(false, false);
        long curPos = this.channel.position();
        switch (typ) {
            case 0: {
                if (curPos == pos) break;
                this.channel.position(pos);
                break;
            }
            case 1: {
                this.channel.position(curPos + pos);
                break;
            }
            case 2: {
                long newPos = this.channel.size() + pos;
                this.channel.position(newPos);
            }
        }
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Seek file=" + (Object)((Object)this) + ", pos=" + pos + ", type=" + typ));
        }
        return this.channel.position();
    }

    public void flushFile() throws IOException {
        this.openContent(true, false);
        this.channel.force(false);
        if (this.getFileState() != null) {
            this.getFileState().updateAccessDateTime();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Flush file=" + (Object)((Object)this)));
        }
    }

    public final boolean isModified() {
        return this.modified;
    }

    private static final boolean isMSOfficeSpecialFile(String path, SrvSession sess, NodeService nodeService, NodeRef nodeRef) {
        return (path = path.toLowerCase()).endsWith(".xls") && sess instanceof SMBSrvSession && nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
    }

    private static final boolean isOpenOfficeSpecialFile(String path, SrvSession sess, NodeService nodeService, NodeRef nodeRef) {
        return (path = path.toLowerCase()).endsWith(".odt") && sess instanceof SMBSrvSession && nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
    }
}

