/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.IOException;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenOfficeContentNetworkFile
extends ContentNetworkFile {
    private static final Log logger = LogFactory.getLog(OpenOfficeContentNetworkFile.class);
    private boolean m_truncateToZero;
    private int m_delayedClose;

    protected OpenOfficeContentNetworkFile(NodeService nodeService, ContentService contentService, MimetypeService mimetypeService, NodeRef nodeRef, String name) {
        super(nodeService, contentService, mimetypeService, nodeRef, name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using OpenOffice network file for " + name + ", versionLabel=" + nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL)));
        }
    }

    public final int getDelayedCloseCount() {
        return this.m_delayedClose;
    }

    public final void incrementDelayedCloseCount() {
        ++this.m_delayedClose;
        this.m_truncateToZero = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Increment delayed close count=" + this.getDelayedCloseCount() + ", path=" + this.getName()));
        }
    }

    public final boolean truncatedToZeroLength() {
        return this.m_truncateToZero;
    }

    public int readFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.m_truncateToZero = false;
        return super.readFile(buffer, length, position, fileOffset);
    }

    public void writeFile(byte[] buffer, int length, int position, long fileOffset) throws IOException {
        this.m_truncateToZero = false;
        super.writeFile(buffer, length, position, fileOffset);
    }

    public void truncateFile(long size) throws IOException {
        super.truncateFile(size);
        if (size == 0L) {
            this.m_truncateToZero = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OpenOffice document truncated to zero length, path=" + this.getName()));
            }
        }
    }

    public void closeFile() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Close OpenOffice file, " + this.getName() + ", delayed close count=" + this.getDelayedCloseCount() + ", writes=" + this.getWriteCount() + ", modified=" + this.isModified()));
            logger.debug((Object)("  Open count=" + this.getOpenCount() + ", fstate open=" + this.getFileState().getOpenCount()));
        }
        super.closeFile();
    }
}

