/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.importer.PropertyContext;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.jcr.item.property.JCRUUIDProperty;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.Importer;
import org.alfresco.repo.importer.view.ElementContext;
import org.alfresco.repo.importer.view.NodeContext;
import org.alfresco.repo.importer.view.ParentContext;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.surf.util.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCRDocXMLHandler
implements ImportContentHandler {
    private Importer importer;
    private SessionImpl session;
    private DictionaryService dictionaryService;
    private NamespacePrefixResolver importResolver;
    private Stack<ElementContext> contextStack = new Stack();

    public JCRDocXMLHandler(SessionImpl session, NamespacePrefixResolver importResolver) {
        this.session = session;
        this.importResolver = importResolver;
        this.dictionaryService = session.getRepositoryImpl().getServiceRegistry().getDictionaryService();
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public InputStream importStream(String content) {
        File contentFile = new File(content);
        try {
            FileInputStream contentStream = new FileInputStream(contentFile);
            return new Base64.InputStream((InputStream)contentStream, 8);
        }
        catch (FileNotFoundException e) {
            throw new ImporterException("Failed to retrieve import input stream on temporary content file " + content);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            QName elementName = this.decodeQName(QName.createQName((String)qName, (NamespacePrefixResolver)this.importResolver));
            ParentContext parentContext = null;
            if (this.contextStack.empty()) {
                parentContext = new ParentContext(elementName, this.dictionaryService, this.importer);
            } else {
                NodeContext parentNode = (NodeContext)this.contextStack.peek();
                parentContext = new ParentContext(elementName, parentNode);
            }
            NodeContext node = new NodeContext(elementName, parentContext, null);
            node.setChildName(elementName.toPrefixString(this.importResolver));
            this.contextStack.push(node);
            for (int i = 0; i < atts.getLength(); ++i) {
                QName propName = this.decodeQName(QName.createQName((String)atts.getURI(i), (String)atts.getLocalName(i)));
                String value = atts.getValue(i);
                if (propName.equals((Object)JCRPrimaryTypeProperty.PROPERTY_NAME)) {
                    QName primaryTypeQName = QName.createQName((String)value, (NamespacePrefixResolver)this.importResolver);
                    TypeDefinition typeDef = this.dictionaryService.getType(primaryTypeQName);
                    if (typeDef == null) {
                        throw new InvalidTypeException(primaryTypeQName);
                    }
                    node.setTypeDefinition(typeDef);
                    continue;
                }
                if (propName.equals((Object)JCRMixinTypesProperty.PROPERTY_NAME)) {
                    String[] aspects;
                    for (String aspect : aspects = value.split(" ")) {
                        QName aspectQName = QName.createQName((String)aspect, (NamespacePrefixResolver)this.importResolver);
                        if (JCRNamespace.JCR_URI.equals(aspectQName.getNamespaceURI()) || JCRNamespace.MIX_URI.equals(aspectQName.getNamespaceURI())) continue;
                        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectQName);
                        if (aspectDef == null) {
                            throw new InvalidTypeException(aspectQName);
                        }
                        node.addAspect(aspectDef);
                    }
                    continue;
                }
                if (JCRUUIDProperty.PROPERTY_NAME.equals((Object)propName)) {
                    node.setUUID(value);
                    continue;
                }
                if (JCRNamespace.JCR_URI.equals(propName.getNamespaceURI())) continue;
                PropertyDefinition propDef = this.dictionaryService.getProperty(propName);
                if (propDef == null) {
                    throw new ImporterException("Property " + propName + " is not known to the repository data dictionary");
                }
                DataTypeDefinition dataTypeDef = propDef.getDataType();
                String[] propValues = null;
                PropertyContext propertyContext = new PropertyContext(elementName, node, propName, dataTypeDef.getName());
                propValues = dataTypeDef.getName().equals((Object)DataTypeDefinition.CONTENT) ? new String[]{value} : value.split(" ");
                for (String propValue : propValues) {
                    propertyContext.startValue();
                    propertyContext.appendCharacters(propValue.toCharArray(), 0, propValue.length());
                    propertyContext.endValue();
                }
                if (propertyContext.isMultiValue()) {
                    node.addPropertyCollection(propName);
                }
                List<StringBuffer> nodeValues = propertyContext.getValues();
                for (StringBuffer nodeValue : nodeValues) {
                    Serializable objVal = (Serializable)this.session.getTypeConverter().convert(dataTypeDef, (Object)nodeValue.toString());
                    String strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)objVal);
                    node.addProperty(propName, (Serializable)((Object)strValue));
                }
            }
            NodeRef nodeRef = node.getImporter().importNode(node);
            node.setNodeRef(nodeRef);
        }
        catch (Exception e) {
            throw new SAXException("Failed to process element " + qName, e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            ElementContext context = this.contextStack.pop();
            QName elementName = this.decodeQName(QName.createQName((String)qName, (NamespacePrefixResolver)this.importResolver));
            if (!context.getElementName().equals((Object)elementName)) {
                throw new InvalidSerializedDataException("Expected element " + context.getElementName() + " but was " + elementName);
            }
            NodeContext nodeContext = (NodeContext)context;
            nodeContext.getImporter().childrenImported(nodeContext.getNodeRef());
        }
        catch (Exception e) {
            throw new SAXException("Failed to process element " + qName, e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }

    private QName decodeQName(QName name) {
        return QName.createQName((String)name.getNamespaceURI(), (String)ISO9075.decode((String)name.getLocalName()));
    }
}

