/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.tck;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.alfresco.jcr.repository.RepositoryImpl;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = -4763518135895358778L;
    private static InitialContext jndiContext;
    private static final String repositoryName = "Alfresco.Repository";

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        RepositoryImpl repository = (RepositoryImpl)context.getBean("JCR.Repository");
        repository.setDefaultWorkspace("test");
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.provider.url", "http://www.alfresco.org");
            env.put("java.naming.factory.initial", "com.day.crx.jndi.provider.MemoryInitialContextFactory");
            jndiContext = new InitialContext(env);
            jndiContext.bind(repositoryName, (Object)repository);
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        if (jndiContext != null) {
            try {
                jndiContext.unbind(repositoryName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

