/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemAbstractBase;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public abstract class ActionExecuterAbstractBase
extends ParameterizedItemAbstractBase
implements ActionExecuter {
    protected ActionDefinition actionDefinition;
    protected boolean publicAction = true;
    protected List<QName> applicableTypes = new ArrayList<QName>();
    private String queueName = "";

    public void init() {
        if (this.publicAction) {
            this.runtimeActionService.registerActionExecuter(this);
        }
    }

    public void setPublicAction(boolean publicAction) {
        this.publicAction = publicAction;
    }

    public void setApplicableTypes(String[] applicableTypes) {
        for (String type : applicableTypes) {
            this.applicableTypes.add(QName.createQName((String)type));
        }
    }

    public ActionDefinition getActionDefinition() {
        if (this.actionDefinition == null) {
            this.actionDefinition = this.createActionDefinition(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setTitleKey(this.getTitleKey());
            ((ActionDefinitionImpl)this.actionDefinition).setDescriptionKey(this.getDescriptionKey());
            ((ActionDefinitionImpl)this.actionDefinition).setAdhocPropertiesAllowed(this.getAdhocPropertiesAllowed());
            ((ActionDefinitionImpl)this.actionDefinition).setRuleActionExecutor(this.name);
            ((ActionDefinitionImpl)this.actionDefinition).setParameterDefinitions(this.getParameterDefintions());
            ((ActionDefinitionImpl)this.actionDefinition).setApplicableTypes(this.applicableTypes);
        }
        return this.actionDefinition;
    }

    protected ActionDefinition createActionDefinition(String name) {
        return new ActionDefinitionImpl(name);
    }

    public void execute(Action action, NodeRef actionedUponNodeRef) {
        this.checkMandatoryProperties(action, this.getActionDefinition());
        this.executeImpl(action, actionedUponNodeRef);
    }

    protected abstract void executeImpl(Action var1, NodeRef var2);

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }
}

