/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.blog.BlogDetails;
import org.alfresco.repo.blog.BlogIntegrationRuntimeException;
import org.alfresco.repo.blog.BlogIntegrationService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogAction
extends ActionExecuterAbstractBase
implements BlogIntegrationModel {
    public static final String NAME = "blog-post";
    public static final String PARAM_BLOG_ACTION = "action";
    private static Log logger = LogFactory.getLog(BlogAction.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private BlogIntegrationService blogIntegrationService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setBlogIntegrationService(BlogIntegrationService blogIntegrationService) {
        this.blogIntegrationService = blogIntegrationService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        String blogAction = (String)((Object)action.getParameterValue(PARAM_BLOG_ACTION));
        try {
            if ("post".equals(blogAction)) {
                List<BlogDetails> list;
                QName type = this.nodeService.getType(actionedUponNodeRef);
                if (this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT) && (list = this.blogIntegrationService.getBlogDetails(actionedUponNodeRef)).size() != 0) {
                    BlogDetails blogDetails = list.get(0);
                    this.blogIntegrationService.newPost(blogDetails, actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
                }
            } else if ("update".equals(blogAction)) {
                QName type = this.nodeService.getType(actionedUponNodeRef);
                if (this.nodeService.hasAspect(actionedUponNodeRef, ASPECT_BLOG_POST) && this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
                    this.blogIntegrationService.updatePost(actionedUponNodeRef, ContentModel.PROP_CONTENT, true);
                }
            } else if ("remove".equals(blogAction)) {
                QName type = this.nodeService.getType(actionedUponNodeRef);
                if (this.nodeService.hasAspect(actionedUponNodeRef, ASPECT_BLOG_POST) && this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT)) {
                    this.blogIntegrationService.deletePost(actionedUponNodeRef);
                }
            } else {
                throw new BlogIntegrationRuntimeException("Invalid action has been specified '" + blogAction + "'");
            }
            action.setParameterValue("result", (Serializable)((Object)""));
        }
        catch (BlogIntegrationRuntimeException ex) {
            action.setParameterValue("result", (Serializable)((Object)ex.getMessage()));
        }
        catch (Exception ex) {
            action.setParameterValue("result", (Serializable)((Object)"Action failed. Please check blog configuration parameters."));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_BLOG_ACTION, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_BLOG_ACTION)));
        paramList.add(new ParameterDefinitionImpl("result", DataTypeDefinition.TEXT, false, this.getParamDisplayLabel("result")));
    }
}

