/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "import";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DESTINATION_FOLDER = "destination";
    private static final int BUFFER_SIZE = 16384;
    private static final String TEMP_FILE_PREFIX = "alf";
    private static final String TEMP_FILE_SUFFIX_ACP = ".acp";
    private static final String TEMP_FILE_SUFFIX_ZIP = ".zip";
    private ImporterService importerService;
    private NodeService nodeService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private FileFolderService fileFolderService;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (!this.nodeService.exists(actionedUponNodeRef)) return;
        ContentReader reader = this.contentService.getReader(actionedUponNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null) return;
        NodeRef importDest = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
        if ("application/acp".equals(reader.getMimetype())) {
            File zipFile = null;
            try {
                zipFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                reader.getContent(zipFile);
                ACPImportPackageHandler importHandler = new ACPImportPackageHandler(zipFile, (String)((Object)ruleAction.getParameterValue(PARAM_ENCODING)));
                this.importerService.importView(importHandler, new Location(importDest), null, null);
                Object var8_9 = null;
                if (zipFile == null) return;
                zipFile.delete();
                return;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (zipFile == null) throw throwable;
                zipFile.delete();
                throw throwable;
            }
        }
        if (!"application/zip".equals(reader.getMimetype())) return;
        ZipFile zipFile = null;
        File tempFile = null;
        try {
            try {
                tempFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX_ACP);
                reader.getContent(tempFile);
                zipFile = new ZipFile(tempFile, "Cp437");
                File alfTempDir = TempFileProvider.getTempDir();
                File tempDir = new File(alfTempDir.getPath() + File.separatorChar + actionedUponNodeRef.getId());
                try {
                    ImporterActionExecuter.extractFile(zipFile, tempDir.getPath());
                    this.importDirectory(tempDir.getPath(), importDest);
                    Object var10_15 = null;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    ImporterActionExecuter.deleteDir(tempDir);
                    throw throwable;
                }
                ImporterActionExecuter.deleteDir(tempDir);
                Object var12_18 = null;
                if (tempFile == null) return;
                tempFile.delete();
                return;
            }
            catch (IOException ioErr) {
                throw new AlfrescoRuntimeException("Failed to import ZIP file.", (Throwable)ioErr);
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (tempFile == null) throw throwable;
            tempFile.delete();
            throw throwable;
        }
    }

    private void importDirectory(String dir, NodeRef root) {
        File topdir = new File(dir);
        for (File file : topdir.listFiles()) {
            try {
                if (file.isFile()) {
                    String fileName = file.getName();
                    FileInfo fileInfo = this.fileFolderService.create(root, fileName, ContentModel.TYPE_CONTENT);
                    NodeRef fileRef = fileInfo.getNodeRef();
                    HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
                    titledProps.put(ContentModel.PROP_TITLE, fileName);
                    this.nodeService.addAspect(fileRef, ContentModel.ASPECT_TITLED, titledProps);
                    BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file), 16384);
                    ContentWriter writer = this.contentService.getWriter(fileRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype(this.mimetypeService.guessMimetype(fileName));
                    writer.putContent((InputStream)contentStream);
                    continue;
                }
                FileInfo folderInfo = this.fileFolderService.create(root, file.getName(), ContentModel.TYPE_FOLDER);
                NodeRef folderRef = folderInfo.getNodeRef();
                this.nodeService.addAspect(folderRef, ApplicationModel.ASPECT_UIFACETS, null);
                this.importDirectory(file.getPath(), folderRef);
            }
            catch (FileNotFoundException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
            catch (FileExistsException e) {
                throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ENCODING, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_ENCODING)));
    }

    public static void extractFile(ZipFile archive, String extractDir) {
        byte[] buffer = new byte[16384];
        extractDir = extractDir + File.separator;
        try {
            Enumeration e = archive.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                if (!entry.isDirectory()) {
                    int count;
                    File parentFile;
                    String fileName = entry.getName();
                    fileName = fileName.replace('/', File.separatorChar);
                    String destFileName = extractDir + fileName;
                    File destFile = new File(destFileName);
                    String parent = destFile.getParent();
                    if (parent != null && !(parentFile = new File(parent)).exists()) {
                        parentFile.mkdirs();
                    }
                    BufferedInputStream in = new BufferedInputStream(archive.getInputStream(entry), 16384);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFileName), 16384);
                    while ((count = ((InputStream)in).read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, count);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                    continue;
                }
                File newdir = new File(extractDir + entry.getName());
                newdir.mkdirs();
            }
        }
        catch (ZipException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to process ZIP file.", (Throwable)e);
        }
    }

    public static void deleteDir(File dir) {
        File elenco = new File(dir.getPath());
        for (File file : elenco.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            ImporterActionExecuter.deleteDir(file);
        }
        dir.delete();
    }
}

