/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.action.executer.TestModeable;
import org.alfresco.repo.template.DateCompareMethod;
import org.alfresco.repo.template.HasAspectMethod;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailActionExecuter
extends ActionExecuterAbstractBase
implements InitializingBean,
TestModeable {
    private static Log logger = LogFactory.getLog(MailActionExecuter.class);
    public static final String NAME = "mail";
    public static final String PARAM_TO = "to";
    public static final String PARAM_TO_MANY = "to_many";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_TEXT = "text";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TEMPLATE = "template";
    private static final String FROM_ADDRESS = "alfresco@alfresco.org";
    private static final String REPO_REMOTE_URL = "http://localhost:8080/alfresco";
    private JavaMailSender javaMailSender;
    private TemplateService templateService;
    private PersonService personService;
    private AuthenticationService authService;
    private NodeService nodeService;
    private AuthorityService authorityService;
    private ServiceRegistry serviceRegistry;
    private String headerEncoding = null;
    private String fromAddress = null;
    private String repoRemoteUrl = null;
    private boolean sendTestMessage = false;
    private String testMessageTo = null;
    private String testMessageSubject = "Test message";
    private String testMessageText = "This is a test message.";
    private boolean testMode = false;
    private MimeMessage lastTestMessage;

    public void setMailService(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setHeaderEncoding(String headerEncoding) {
        this.headerEncoding = headerEncoding;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setRepoRemoteUrl(String repoRemoteUrl) {
        this.repoRemoteUrl = repoRemoteUrl;
    }

    public void setTestMessageTo(String testMessageTo) {
        this.testMessageTo = testMessageTo;
    }

    public void setTestMessageSubject(String testMessageSubject) {
        this.testMessageSubject = testMessageSubject;
    }

    public void setTestMessageText(String testMessageText) {
        this.testMessageText = testMessageText;
    }

    public void setSendTestMessage(boolean sendTestMessage) {
        this.sendTestMessage = sendTestMessage;
    }

    @Override
    public void init() {
        super.init();
        if (this.sendTestMessage) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(PARAM_TO, (Serializable)((Object)this.testMessageTo));
            params.put(PARAM_SUBJECT, (Serializable)((Object)this.testMessageSubject));
            params.put(PARAM_TEXT, (Serializable)((Object)this.testMessageText));
            Action ruleAction = this.serviceRegistry.getActionService().createAction(NAME, params);
            this.executeImpl(ruleAction, null);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.fromAddress == null || this.fromAddress.length() == 0) {
            this.fromAddress = FROM_ADDRESS;
        }
        if (this.repoRemoteUrl == null || this.repoRemoteUrl.length() == 0) {
            this.repoRemoteUrl = REPO_REMOTE_URL;
        }
    }

    @Override
    protected void executeImpl(final Action ruleAction, final NodeRef actionedUponNodeRef) {
        MimeMessagePreparator mailPreparer = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException {
                String to;
                if (logger.isDebugEnabled()) {
                    logger.debug(ruleAction.getParameterValues());
                }
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage);
                if (MailActionExecuter.this.headerEncoding != null && MailActionExecuter.this.headerEncoding.length() != 0) {
                    mimeMessage.setHeader("Content-Transfer-Encoding", MailActionExecuter.this.headerEncoding);
                }
                if ((to = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TO))) != null && to.length() != 0) {
                    message.setTo(to);
                } else {
                    Serializable authoritiesValue = ruleAction.getParameterValue(MailActionExecuter.PARAM_TO_MANY);
                    ArrayList<String> authorities = null;
                    if (authoritiesValue != null) {
                        if (authoritiesValue instanceof String) {
                            authorities = new ArrayList<String>(1);
                            authorities.add((String)((Object)authoritiesValue));
                        } else {
                            authorities = (List)((Object)authoritiesValue);
                        }
                    }
                    if (authorities != null && authorities.size() != 0) {
                        ArrayList<String> recipients = new ArrayList<String>(authorities.size());
                        for (String authority : authorities) {
                            AuthorityType authType = AuthorityType.getAuthorityType((String)authority);
                            if (authType.equals((Object)AuthorityType.USER)) {
                                if (!MailActionExecuter.this.personService.personExists(authority)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(authority);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0 || !MailActionExecuter.this.validateAddress(address)) continue;
                                recipients.add(address);
                                continue;
                            }
                            if (!authType.equals((Object)AuthorityType.GROUP)) continue;
                            Set<String> users = MailActionExecuter.this.authorityService.getContainedAuthorities(AuthorityType.USER, authority, false);
                            for (String userAuth : users) {
                                if (!MailActionExecuter.this.personService.personExists(userAuth)) continue;
                                NodeRef person = MailActionExecuter.this.personService.getPerson(userAuth);
                                String address = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                                if (address == null || address.length() == 0) continue;
                                recipients.add(address);
                            }
                        }
                        message.setTo(recipients.toArray(new String[recipients.size()]));
                    } else {
                        logger.error((Object)"No recipiant has been specified for the mail action");
                    }
                }
                message.setSubject((String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_SUBJECT)));
                String text = null;
                NodeRef templateRef = (NodeRef)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEMPLATE);
                if (templateRef != null) {
                    Map model = MailActionExecuter.this.createEmailTemplateModel(actionedUponNodeRef);
                    text = MailActionExecuter.this.templateService.processTemplate("freemarker", templateRef.toString(), model);
                }
                if (text == null) {
                    text = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_TEXT));
                }
                message.setText(text);
                NodeRef person = MailActionExecuter.this.personService.getPerson(MailActionExecuter.this.authService.getCurrentUserName());
                String fromActualUser = null;
                if (person != null) {
                    fromActualUser = (String)((Object)MailActionExecuter.this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
                }
                if (fromActualUser != null && fromActualUser.length() != 0) {
                    message.setFrom(fromActualUser);
                } else {
                    String from = (String)((Object)ruleAction.getParameterValue(MailActionExecuter.PARAM_FROM));
                    if (from == null || from.length() == 0) {
                        message.setFrom(MailActionExecuter.this.fromAddress);
                    } else {
                        message.setFrom(from);
                    }
                }
            }
        };
        try {
            if (!this.testMode) {
                this.javaMailSender.send(mailPreparer);
            } else {
                try {
                    MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
                    mailPreparer.prepare(mimeMessage);
                    this.lastTestMessage = mimeMessage;
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
        catch (MailException e) {
            Serializable obj;
            String to = (String)((Object)ruleAction.getParameterValue(PARAM_TO));
            if (to == null && (obj = ruleAction.getParameterValue(PARAM_TO_MANY)) != null) {
                to = obj.toString();
            }
            logger.error((Object)("Failed to send email to " + to), (Throwable)e);
            throw new AlfrescoRuntimeException("Failed to send email to:" + to, (Throwable)e);
        }
    }

    private boolean validateAddress(String address) {
        boolean result = false;
        EmailValidator emailValidator = EmailValidator.getInstance();
        if (emailValidator.isValid(address)) {
            result = true;
        } else {
            logger.error((Object)("Failed to send email to '" + address + "' as the address is incorrectly formatted"));
        }
        return result;
    }

    private Map<String, Object> createEmailTemplateModel(NodeRef ref) {
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        NodeRef person = this.personService.getPerson(this.authService.getCurrentUserName());
        model.put("person", new TemplateNode(person, this.serviceRegistry, null));
        model.put("document", new TemplateNode(ref, this.serviceRegistry, null));
        NodeRef parent = this.serviceRegistry.getNodeService().getPrimaryParent(ref).getParentRef();
        model.put("space", new TemplateNode(parent, this.serviceRegistry, null));
        model.put("date", new Date());
        model.put("hasAspect", new HasAspectMethod());
        model.put("message", new I18NMessageMethod());
        model.put("dateCompare", new DateCompareMethod());
        model.put("url", new URLHelper(this.repoRemoteUrl));
        return model;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_TO, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TO)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TO_MANY, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_TO_MANY), true));
        paramList.add(new ParameterDefinitionImpl(PARAM_SUBJECT, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_SUBJECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEXT, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TEXT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_FROM, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_FROM)));
        paramList.add(new ParameterDefinitionImpl(PARAM_TEMPLATE, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_TEMPLATE), false, "ac-email-templates"));
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public boolean isTestMode() {
        return this.testMode;
    }

    public MimeMessage retrieveLastTestMessage() {
        return this.lastTestMessage;
    }

    public static class URLHelper {
        String contextPath;
        String serverPath;

        public URLHelper(String repoRemoteUrl) {
            String[] parts = repoRemoteUrl.split("/");
            this.contextPath = "/" + parts[parts.length - 1];
            this.serverPath = parts[0] + "//" + parts[2];
        }

        public String getContext() {
            return this.contextPath;
        }

        public String getServerPath() {
            return this.serverPath;
        }
    }
}

