/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class PatchExecuter
extends AbstractLifecycleBean {
    private static final String MSG_CHECKING = "patch.executer.checking";
    private static final String MSG_NO_PATCHES_REQUIRED = "patch.executer.no_patches_required";
    private static final String MSG_SYSTEM_READ_ONLY = "patch.executer.system_readonly";
    private static final String MSG_NOT_EXECUTED = "patch.executer.not_executed";
    private static final String MSG_EXECUTED = "patch.executer.executed";
    private static final String MSG_FAILED = "patch.executer.failed";
    private static Log logger = LogFactory.getLog(PatchExecuter.class);
    private PatchService patchService;
    private TransactionService transactionService;

    public void setPatchService(PatchService patchService) {
        this.patchService = patchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void applyOutstandingPatches() {
        if (!this.patchService.validatePatches() || this.transactionService.isReadOnly()) {
            logger.warn((Object)I18NUtil.getMessage((String)MSG_SYSTEM_READ_ONLY));
            return;
        }
        logger.info((Object)I18NUtil.getMessage((String)MSG_CHECKING));
        Date before = new Date(System.currentTimeMillis() - 60000L);
        boolean applySucceeded = this.patchService.applyOutstandingPatches();
        Date after = new Date(System.currentTimeMillis() + 20000L);
        List<AppliedPatch> appliedPatches = this.patchService.getPatches(before, after);
        if (applySucceeded && appliedPatches.size() == 0) {
            logger.info((Object)I18NUtil.getMessage((String)MSG_NO_PATCHES_REQUIRED));
        } else {
            boolean allPassed = true;
            for (AppliedPatch patchInfo : appliedPatches) {
                if (!patchInfo.getWasExecuted()) {
                    logger.debug((Object)I18NUtil.getMessage((String)MSG_NOT_EXECUTED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
                    continue;
                }
                if (patchInfo.getSucceeded()) {
                    logger.info((Object)I18NUtil.getMessage((String)MSG_EXECUTED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
                    continue;
                }
                allPassed = false;
                logger.error((Object)I18NUtil.getMessage((String)MSG_FAILED, (Object[])new Object[]{patchInfo.getId(), patchInfo.getReport()}));
            }
            if (!allPassed || !applySucceeded) {
                throw new AlfrescoRuntimeException("Not all patches could be applied");
            }
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.applyOutstandingPatches();
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

