/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DeploymentMigrationPatch
extends AbstractPatch {
    protected ImporterBootstrap importerBootstrap;
    protected IndexerAndSearcher indexerAndSearcher;
    protected AVMService avmService;
    private static final String MSG_SUCCESS = "patch.deploymentMigration.result";
    private static final String MSG_WEBPROJECT = "patch.deploymentMigration.webProjectName";
    private static final String MSG_SERVER_MIGRATED = "patch.deploymentMigration.serverMigrated";
    private static final String MSG_REPORT_MIGRATED = "patch.deploymentMigration.reportMigrated";
    private static final String FILE_SERVER_PREFIX = "\\\\";
    private static final Log logger = LogFactory.getLog(DeploymentMigrationPatch.class);

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String applyInternal() throws Exception {
        String query = "TYPE:\"wca:webfolder\"";
        ResultSet results = null;
        try {
            results = this.searchService.query(this.importerBootstrap.getStoreRef(), "lucene", query);
            if (results.length() > 0) {
                for (NodeRef node : results.getNodeRefs()) {
                    if (!this.nodeService.exists(node)) continue;
                    this.migrate(node);
                }
            }
            Object var6_5 = null;
            if (results == null) return I18NUtil.getMessage((String)MSG_SUCCESS);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (results == null) throw throwable;
            results.close();
            throw throwable;
        }
        results.close();
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }

    protected void migrate(NodeRef webProject) {
        List deployReportRefs;
        String projectName = (String)((Object)this.nodeService.getProperty(webProject, ContentModel.PROP_NAME));
        logger.info((Object)I18NUtil.getMessage((String)MSG_WEBPROJECT, (Object[])new Object[]{projectName}));
        List deployTo = (List)((Object)this.nodeService.getProperty(webProject, WCMAppModel.PROP_DEPLOYTO));
        if (deployTo != null && deployTo.size() > 0) {
            for (String server : deployTo) {
                if (server == null || server.length() <= 0) continue;
                this.migrateServer(server.trim(), webProject, projectName);
            }
        }
        if ((deployReportRefs = this.nodeService.getChildAssocs(webProject, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTREPORT, RegexQNamePattern.MATCH_ALL)).size() > 0) {
            String attemptId = GUID.generate();
            String store = (String)((Object)this.nodeService.getProperty(webProject, WCMAppModel.PROP_AVMSTORE));
            ArrayList servers = (ArrayList)this.nodeService.getProperty(webProject, WCMAppModel.PROP_SELECTEDDEPLOYTO);
            if (servers == null) {
                servers = new ArrayList();
            }
            Integer version = (Integer)this.nodeService.getProperty(webProject, WCMAppModel.PROP_SELECTEDDEPLOYVERSION);
            Date time = (Date)this.nodeService.getProperty(((ChildAssociationRef)deployReportRefs.get(0)).getChildRef(), WCMAppModel.PROP_DEPLOYSTARTTIME);
            HashMap<QName, Object> props = new HashMap<QName, Object>(8, 1.0f);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTID, attemptId);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTYPE, "live");
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTSTORE, store);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTVERSION, version);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTSERVERS, servers);
            props.put(WCMAppModel.PROP_DEPLOYATTEMPTTIME, time);
            NodeRef attempt = this.nodeService.createNode(webProject, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.ASSOC_DEPLOYMENTATTEMPT, WCMAppModel.TYPE_DEPLOYMENTATTEMPT, props).getChildRef();
            this.avmService.setStoreProperty(store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)attemptId)));
            for (ChildAssociationRef ref : deployReportRefs) {
                this.migrateReport(ref.getChildRef(), attempt, webProject, projectName);
            }
        }
        this.nodeService.removeProperty(webProject, WCMAppModel.PROP_DEPLOYTO);
        this.nodeService.removeProperty(webProject, WCMAppModel.PROP_SELECTEDDEPLOYTO);
        this.nodeService.removeProperty(webProject, WCMAppModel.PROP_SELECTEDDEPLOYVERSION);
    }

    protected void migrateServer(String server, NodeRef webProject, String webProjectName) {
        String host = server;
        int port = -1;
        int idx = server.indexOf(":");
        if (idx != -1) {
            host = server.substring(0, idx);
            String strPort = server.substring(idx + 1);
            port = Integer.parseInt(strPort);
        }
        HashMap<QName, Object> props = new HashMap<QName, Object>(4, 1.0f);
        if (server.startsWith(FILE_SERVER_PREFIX)) {
            props.put(WCMAppModel.PROP_DEPLOYTYPE, "file");
            host = host.substring(FILE_SERVER_PREFIX.length());
        } else {
            props.put(WCMAppModel.PROP_DEPLOYTYPE, "alfresco");
        }
        props.put(WCMAppModel.PROP_DEPLOYSERVERTYPE, "live");
        props.put(WCMAppModel.PROP_DEPLOYSERVERHOST, host);
        if (port != -1) {
            props.put(WCMAppModel.PROP_DEPLOYSERVERPORT, new Integer(port));
        }
        this.nodeService.createNode(webProject, WCMAppModel.ASSOC_DEPLOYMENTSERVER, WCMAppModel.ASSOC_DEPLOYMENTSERVER, WCMAppModel.TYPE_DEPLOYMENTSERVER, props).getChildRef();
        logger.info((Object)I18NUtil.getMessage((String)MSG_SERVER_MIGRATED, (Object[])new Object[]{server, webProjectName}));
    }

    protected void migrateReport(NodeRef report, NodeRef attempt, NodeRef webProject, String webProjectName) {
        String server = (String)((Object)this.nodeService.getProperty(report, WCMAppModel.PROP_DEPLOYSERVER));
        this.nodeService.moveNode(report, attempt, WCMAppModel.ASSOC_DEPLOYMENTREPORTS, WCMAppModel.ASSOC_DEPLOYMENTREPORTS);
        logger.info((Object)I18NUtil.getMessage((String)MSG_REPORT_MIGRATED, (Object[])new Object[]{server, webProjectName}));
    }
}

