/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.attributes;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class AttributeServiceTest
extends TestCase {
    private static final Serializable[] KEY_AAA = new Serializable[]{"a", "a", "a"};
    private static final Serializable[] KEY_AAB = new Serializable[]{"a", "a", "b"};
    private static final Serializable[] KEY_AAC = new Serializable[]{"a", "a", "c"};
    private static final Serializable VALUE_AAA_STRING = "aaa";
    private static final Serializable VALUE_AAB_STRING = "aab";
    private static final Serializable VALUE_AAC_STRING = "aac";
    private ApplicationContext ctx;
    private AttributeService attributeService;

    protected void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.attributeService = (AttributeService)this.ctx.getBean("AttributeService");
    }

    protected void tearDown() throws Exception {
    }

    public void testBasic() throws Exception {
        this.attributeService.removeAttribute(KEY_AAA);
        this.attributeService.removeAttribute(KEY_AAB);
        this.attributeService.removeAttribute(KEY_AAC);
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAA));
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAB));
        AttributeServiceTest.assertFalse((boolean)this.attributeService.exists(KEY_AAC));
        this.attributeService.setAttribute(VALUE_AAA_STRING, KEY_AAA);
        this.attributeService.setAttribute(VALUE_AAB_STRING, KEY_AAB);
        this.attributeService.setAttribute(VALUE_AAC_STRING, KEY_AAC);
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAA));
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAB));
        AttributeServiceTest.assertTrue((boolean)this.attributeService.exists(KEY_AAC));
        AttributeServiceTest.assertEquals((Object)VALUE_AAA_STRING, (Object)this.attributeService.getAttribute(KEY_AAA));
        AttributeServiceTest.assertEquals((Object)VALUE_AAB_STRING, (Object)this.attributeService.getAttribute(KEY_AAB));
        AttributeServiceTest.assertEquals((Object)VALUE_AAC_STRING, (Object)this.attributeService.getAttribute(KEY_AAC));
    }
}

