/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.AVMTester;
import org.alfresco.repo.avm.util.BulkLoader;

public class AVMStressTestP
extends AVMServiceTestBase {
    public void testStressB() throws Throwable {
        this.testNThreads(2, "source/java/org/alfresco/repo/avm/actions", 1, 10, 2, 2, 0, 0, 5, 10, 50, 5, 200);
    }

    private void testNThreads(int nThreads, String fsPath, int nCopies, int createFile, int createDir, int rename, int createLayeredDir, int createLayeredFile, int removeNode, int modifyFile, int readFile, int snapshot, int opCount) throws Throwable {
        try {
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            long start = System.currentTimeMillis();
            for (int i = 0; i < nCopies; ++i) {
                fService.createDirectory("main:/", "" + i);
                loader.recursiveLoad(fsPath, "main:/" + i);
                fService.createSnapshot("main", null, null);
            }
            System.out.println("Load time: " + (System.currentTimeMillis() - start));
            ArrayList<AVMTester> testers = new ArrayList<AVMTester>();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < nThreads; ++i) {
                AVMTester tester = new AVMTester(createFile, createDir, rename, createLayeredDir, createLayeredFile, removeNode, modifyFile, readFile, snapshot, opCount, fService);
                tester.refresh();
                Thread thread = new Thread(tester);
                testers.add(tester);
                threads.add(thread);
            }
            for (Thread thread : threads) {
                thread.start();
            }
            int exited = 0;
            while (exited != nThreads) {
                try {
                    Thread.sleep(2000L);
                    for (int i = 0; i < nThreads; ++i) {
                        if (threads.get(i) == null) continue;
                        ((Thread)threads.get(i)).join(1000L);
                        if (((Thread)threads.get(i)).isAlive()) continue;
                        threads.set(i, null);
                        if (((AVMTester)testers.get(i)).getError()) {
                            for (AVMTester tester : testers) {
                                tester.setExit();
                            }
                            System.err.println("Stress tester error");
                        }
                        ++exited;
                    }
                }
                catch (InterruptedException e) {
                }
            }
            int errorCnt = 0;
            for (AVMTester tester : testers) {
                errorCnt += tester.getError() ? 1 : 0;
            }
            if (errorCnt > 0) {
                StringBuffer errorStack = new StringBuffer();
                errorStack.append("Stress tester errors: ").append(errorCnt).append(" out of ").append(testers.size()).append(" are in error state");
                for (AVMTester tester : testers) {
                    if (!tester.getError()) continue;
                    errorStack.append("\n\n").append(tester.getErrorStackTrace());
                }
                AVMStressTestP.fail((String)errorStack.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }
}

