/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentEvent;
import org.alfresco.service.cmr.avm.deploy.DeploymentReport;
import org.alfresco.service.cmr.avm.deploy.DeploymentReportCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.NameMatcher;
import org.alfresco.util.Pair;
import org.alfresco.util.RegexNameMatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMDeployWebsiteAction
extends ActionExecuterAbstractBase {
    public static final String NAME = "avm-deploy-website";
    public static final String FILE_SERVER_PREFIX = "\\\\";
    public static final String PARAM_WEBPROJECT = "webproject";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_ATTEMPT = "attempt";
    public static final String PARAM_CALLBACK = "callback";
    public static final String ASYNC_QUEUE_NAME = "deployment";
    public static final String LIVE_SUFFIX = "live";
    private int delay = -1;
    private int defaultAlfRmiPort = 50500;
    private int defaultReceiverRmiPort = 44100;
    private String defaultRemoteUsername = "admin";
    private String defaultRemotePassword = "admin";
    private String defaultTargetName = "default";
    private String defaultAdapterName = "default";
    private List<DeploymentCallback> configuredCallbacks;
    private DeploymentService deployService;
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private static Log logger = LogFactory.getLog(AVMDeployWebsiteAction.class);
    private static Log delayDeploymentLogger = LogFactory.getLog((String)"alfresco.deployment.delay");

    public static String calculateServerUri(Map<QName, Serializable> props) {
        StringBuilder uri = new StringBuilder();
        String type = (String)((Object)props.get(WCMAppModel.PROP_DEPLOYTYPE));
        if ("file".equals(type)) {
            uri.append(FILE_SERVER_PREFIX);
        }
        uri.append((String)((Object)props.get(WCMAppModel.PROP_DEPLOYSERVERHOST)));
        Integer port = (Integer)props.get(WCMAppModel.PROP_DEPLOYSERVERPORT);
        if (port != null) {
            uri.append(":");
            uri.append(port.toString());
        }
        return uri.toString();
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDefaultAlfrescoRmiPort(int defaultAlfrescoRmiPort) {
        this.defaultAlfRmiPort = defaultAlfrescoRmiPort;
    }

    public void setDefaultReceiverRmiPort(int defaultReceiverRmiPort) {
        this.defaultReceiverRmiPort = defaultReceiverRmiPort;
    }

    public void setDefaultRemoteUsername(String defaultRemoteUsername) {
        this.defaultRemoteUsername = defaultRemoteUsername;
    }

    public void setDefaultRemotePassword(String defaultRemotePassword) {
        this.defaultRemotePassword = defaultRemotePassword;
    }

    public void setDefaultTargetName(String defaultTargetName) {
        this.defaultTargetName = defaultTargetName;
    }

    public void setCallbacks(List<DeploymentCallback> callbacks) {
        this.configuredCallbacks = callbacks;
    }

    public void setNodeService(NodeService service) {
        this.nodeService = service;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDeploymentService(DeploymentService service) {
        this.deployService = service;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_WEBPROJECT, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_WEBPROJECT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_SERVER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_SERVER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ATTEMPT, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_ATTEMPT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_CALLBACK, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_CALLBACK)));
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(actionedUponNodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        String[] storePath = path.split(":");
        if (storePath.length != 2) {
            throw new AVMSyncException("Malformed source path: " + path);
        }
        NodeRef websiteRef = (NodeRef)action.getParameterValue(PARAM_WEBPROJECT);
        if (!this.nodeService.exists(websiteRef)) {
            throw new IllegalStateException("The website NodeRef (" + websiteRef + ") provided does not exist!");
        }
        NodeRef serverRef = (NodeRef)action.getParameterValue(PARAM_SERVER);
        if (!this.nodeService.exists(serverRef)) {
            throw new IllegalStateException("The server NodeRef (" + serverRef + ") provided does not exist!");
        }
        NodeRef attemptRef = (NodeRef)action.getParameterValue(PARAM_ATTEMPT);
        if (!this.nodeService.exists(attemptRef)) {
            throw new IllegalStateException("The attempt NodeRef (" + serverRef + ") provided does not exist!");
        }
        DeploymentCallback callback = (DeploymentCallback)((Object)action.getParameterValue(PARAM_CALLBACK));
        Map serverProps = this.nodeService.getProperties(serverRef);
        String serverUri = AVMDeployWebsiteAction.calculateServerUri(serverProps);
        String host = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERHOST);
        Integer port = (Integer)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERPORT);
        String remoteUsername = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERUSERNAME);
        String remotePassword = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERPASSWORD);
        boolean fileServerDeployment = "file".equals(serverProps.get(WCMAppModel.PROP_DEPLOYTYPE));
        String sourcePath = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSOURCEPATH);
        String excludes = (String)serverProps.get(WCMAppModel.PROP_DEPLOYEXCLUDES);
        String targetName = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERTARGET);
        String adapterName = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERADPTERNAME);
        String targetPath = path;
        if (!fileServerDeployment) {
            if (port == null && (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("127.0.0.1"))) {
                targetPath = storePath[0] + LIVE_SUFFIX + ":" + storePath[1];
            }
        } else if (adapterName == null) {
            adapterName = this.defaultAdapterName;
        }
        if (port == null) {
            port = fileServerDeployment ? Integer.valueOf(this.defaultReceiverRmiPort) : Integer.valueOf(this.defaultAlfRmiPort);
        }
        if (remoteUsername == null || remoteUsername.length() == 0) {
            remoteUsername = this.defaultRemoteUsername;
        }
        if (remotePassword == null || remotePassword.length() == 0) {
            remotePassword = this.defaultRemotePassword;
        }
        if (targetName == null || targetName.length() == 0) {
            targetName = this.defaultTargetName;
        }
        if (sourcePath != null && sourcePath.length() > 0) {
            if (!sourcePath.startsWith("/")) {
                sourcePath = "/" + sourcePath;
            }
            path = path + sourcePath;
        }
        RegexNameMatcher regexMatcher = null;
        if (excludes != null && excludes.length() > 0) {
            regexMatcher = new RegexNameMatcher();
            ArrayList<String> patterns = new ArrayList<String>(1);
            patterns.add(excludes);
            regexMatcher.setPatterns(patterns);
        }
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        if (callback != null) {
            callbacks.add(callback);
        }
        if (this.configuredCallbacks != null && this.configuredCallbacks.size() > 0) {
            callbacks.addAll(this.configuredCallbacks);
        }
        Date startDate = new Date();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting deployment of " + actionedUponNodeRef.toString() + " to " + serverUri + " at " + startDate));
        }
        Throwable deployError = null;
        DeploymentReport report = new DeploymentReport();
        callbacks.add(new DeploymentReportCallback(report));
        try {
            serverProps.put(WCMAppModel.PROP_DEPLOYSERVERPASSWORD, "*****");
            if (fileServerDeployment) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Performing file server deployment to " + host + ":" + port + " using deploymentserver: " + serverProps));
                }
                this.deployService.deployDifferenceFS(version, path, adapterName, host, port, remoteUsername, remotePassword, targetName, (NameMatcher)regexMatcher, true, false, false, callbacks);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Performing Alfresco deployment to " + host + ":" + port + " using deploymentserver: " + serverProps));
                }
                this.deployService.deployDifference(version, path, host, port, remoteUsername, remotePassword, targetPath, (NameMatcher)regexMatcher, true, false, false, callbacks);
            }
        }
        catch (Throwable err) {
            deployError = err;
            logger.error((Object)"Deployment Error", deployError);
        }
        if (report != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Differences successfully applied to " + serverUri));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to apply differences to " + serverUri));
        }
        this.createDeploymentReportNode(report, attemptRef, serverProps, version, websiteRef, startDate, deployError);
    }

    private NodeRef createDeploymentReportNode(final DeploymentReport report, final NodeRef attempt, Map<QName, Serializable> serverProps, int version, NodeRef websiteRef, Date startDate, final Throwable error) {
        logger.debug((Object)"createDeploymentReportNode called ");
        NodeRef reportRef = null;
        String serverUri = AVMDeployWebsiteAction.calculateServerUri(serverProps);
        final HashMap<QName, Object> reportProps = new HashMap<QName, Object>(4, 1.0f);
        reportProps.put(WCMAppModel.PROP_DEPLOYSERVER, serverUri);
        reportProps.put(WCMAppModel.PROP_DEPLOYVERSION, version);
        reportProps.put(WCMAppModel.PROP_DEPLOYSTARTTIME, startDate);
        reportProps.put(WCMAppModel.PROP_DEPLOYENDTIME, new Date());
        reportProps.put(WCMAppModel.PROP_DEPLOYSERVERNAMEUSED, serverProps.get(WCMAppModel.PROP_DEPLOYSERVERNAME));
        reportProps.put(WCMAppModel.PROP_DEPLOYSERVERUSERNAMEUSED, serverProps.get(WCMAppModel.PROP_DEPLOYSERVERUSERNAME));
        reportProps.put(WCMAppModel.PROP_DEPLOYSERVERTARGETUSED, serverProps.get(WCMAppModel.PROP_DEPLOYSERVERTARGET));
        reportProps.put(WCMAppModel.PROP_DEPLOYSOURCEPATHUSED, serverProps.get(WCMAppModel.PROP_DEPLOYSOURCEPATH));
        reportProps.put(WCMAppModel.PROP_DEPLOYEXCLUDESUSED, serverProps.get(WCMAppModel.PROP_DEPLOYEXCLUDES));
        reportProps.put(WCMAppModel.PROP_DEPLOYSERVERURLUSED, serverProps.get(WCMAppModel.PROP_DEPLOYSERVERURL));
        reportProps.put(WCMAppModel.PROP_DEPLOYSUCCESSFUL, report != null && error == null);
        if (report == null && error != null) {
            String errorMsg = error.getMessage();
            Throwable cause = error.getCause();
            if (cause != null) {
                errorMsg = cause.getMessage();
            }
            reportProps.put(WCMAppModel.PROP_DEPLOYFAILEDREASON, errorMsg);
        }
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> cb = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef reportRef = AVMDeployWebsiteAction.this.nodeService.createNode(attempt, WCMAppModel.ASSOC_DEPLOYMENTREPORTS, WCMAppModel.ASSOC_DEPLOYMENTREPORTS, WCMAppModel.TYPE_DEPLOYMENTREPORT, reportProps).getChildRef();
                ContentWriter writer = AVMDeployWebsiteAction.this.contentService.getWriter(reportRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.setEncoding("UTF-8");
                if (report == null) {
                    if (error == null) {
                        writer.putContent("");
                    } else {
                        StringWriter stack = new StringWriter();
                        PrintWriter stackPrint = new PrintWriter(stack);
                        error.printStackTrace(stackPrint);
                        writer.putContent(stack.toString());
                    }
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (DeploymentEvent event : report) {
                        builder.append(event.getType());
                        builder.append(" ");
                        builder.append(event.getDestination());
                        builder.append("\r\n");
                    }
                    if (error != null) {
                        builder.append("\r\n");
                        StringWriter stack = new StringWriter();
                        PrintWriter stackPrint = new PrintWriter(stack);
                        error.printStackTrace(stackPrint);
                        builder.append(stack.toString());
                    }
                    writer.putContent(builder.toString());
                }
                return reportRef;
            }
        };
        reportRef = tran.doInTransaction(cb, false, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created deplyoment report node (" + reportRef + ") for server " + serverUri));
        }
        return reportRef;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }
}

