/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import marquee.xmlrpc.XmlRpcClient;
import marquee.xmlrpc.XmlRpcCustomSerializer;
import marquee.xmlrpc.XmlRpcException;
import marquee.xmlrpc.XmlRpcParser;
import marquee.xmlrpc.XmlRpcSerializer;
import marquee.xmlrpc.serializers.HashtableSerializer;
import org.alfresco.repo.blog.BaseBlogIntegrationImplementation;
import org.alfresco.repo.blog.BlogDetails;
import org.alfresco.repo.blog.BlogIntegrationRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultBlogIntegrationImplementation
extends BaseBlogIntegrationImplementation {
    protected static final String ACTION_NEW_POST = "metaWeblog.newPost";
    protected static final String ACTION_EDIT_POST = "metaWeblog.editPost";
    protected static final String ACTION_GET_POST = "metaWeblog.getPost";
    protected static final String ACTION_DELETE_POST = "blogger.deletePost";

    protected abstract String getEndpointURL(BlogDetails var1);

    @Override
    public String newPost(BlogDetails blogDetails, String title, String body, boolean publish) {
        Hashtable<String, String> content = new Hashtable<String, String>();
        content.put("title", title);
        content.put("description", body);
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(blogDetails.getBlogId());
        params.add(blogDetails.getUserName());
        params.add(blogDetails.getPassword());
        params.add(content);
        params.add(publish);
        return (String)this.execute(this.getEndpointURL(blogDetails), ACTION_NEW_POST, params);
    }

    @Override
    public boolean updatePost(BlogDetails blogDetails, String postId, String title, String body, boolean publish) {
        Hashtable<String, String> content = new Hashtable<String, String>();
        content.put("title", title);
        content.put("description", body);
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(postId);
        params.add(blogDetails.getUserName());
        params.add(blogDetails.getPassword());
        params.add(content);
        params.add(publish);
        Object result = this.execute(this.getEndpointURL(blogDetails), ACTION_EDIT_POST, params);
        if (result.getClass().equals(Boolean.class)) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public Map<String, Object> getPost(BlogDetails blogDetails, String postId) {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(postId);
        params.add(blogDetails.getUserName());
        params.add(blogDetails.getPassword());
        return (Map)this.execute(this.getEndpointURL(blogDetails), ACTION_GET_POST, params);
    }

    @Override
    public boolean deletePost(BlogDetails blogDetails, String postId) {
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(blogDetails.getBlogId());
        params.add(postId);
        params.add(blogDetails.getUserName());
        params.add(blogDetails.getPassword());
        params.add(true);
        Object result = this.execute(this.getEndpointURL(blogDetails), ACTION_DELETE_POST, params);
        if (result.getClass().equals(Boolean.class)) {
            return (Boolean)result;
        }
        return false;
    }

    private XmlRpcClient getClient(String url) {
        XmlRpcClient client = null;
        try {
            XmlRpcSerializer.registerCustomSerializer((XmlRpcCustomSerializer)new HashtableSerializer());
            XmlRpcParser.setDriver((String)"org.apache.xerces.parsers.SAXParser");
            client = new XmlRpcClient(new URL(url));
        }
        catch (MalformedURLException exception) {
            throw new BlogIntegrationRuntimeException("Blog url '" + url + "' is invalid.", exception);
        }
        return client;
    }

    protected Object execute(String url, String method, List<Object> params) {
        Object result = null;
        try {
            XmlRpcClient client = this.getClient(url);
            result = client.invoke(method, params);
        }
        catch (XmlRpcException exception) {
            throw new BlogIntegrationRuntimeException("Failed to execute blog action '" + method + "' @ url '" + url + "'", exception);
        }
        return result;
    }

    protected String checkForProtocol(String url) {
        if (url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        return url;
    }

    protected String checkForTrainlingSlash(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }
}

