/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.IOException;
import java.net.URL;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(EhCacheManagerFactoryBean.class);
    private Resource configLocation;
    private CacheManager cacheManager;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        PropertyCheck.mandatory((Object)this, (String)"configLocation", (Object)this.configLocation);
        try {
            URL configUrl = this.configLocation.getURL();
            this.logger.info((Object)("Initializing EHCache CacheManager using URL: " + this.configLocation));
            this.cacheManager = new CacheManager(configUrl);
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Unabled to read EHCache configuration file at " + this.configLocation, (Throwable)e);
        }
    }

    public Object getObject() {
        return this.cacheManager;
    }

    public Class getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Shutting down EHCache CacheManager");
        if (this.logger.isDebugEnabled()) {
            String[] caches;
            for (String cache : caches = this.cacheManager.getCacheNames()) {
                this.logger.debug((Object)("Shutting down EHCache instance " + cache));
            }
        }
        this.cacheManager.shutdown();
    }

    static {
        System.setProperty("net.sf.ehcache.use.classic.lru", "true");
    }
}

