/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalCache<K extends Serializable, V>
implements SimpleCache<K, V>,
TransactionListener,
InitializingBean {
    private static final String RESOURCE_KEY_TXN_DATA = "TransactionalCache.TxnData";
    private Log logger = LogFactory.getLog(TransactionalCache.class);
    private boolean isDebugEnabled = this.logger.isDebugEnabled();
    private String name;
    private SimpleCache<Serializable, Object> sharedCache;
    private int maxCacheSize = 500;
    private String resourceKeyTxnData;

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionalCache)) {
            return false;
        }
        TransactionalCache that = (TransactionalCache)obj;
        return EqualsHelper.nullSafeEquals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setSharedCache(SimpleCache<Serializable, Object> sharedCache) {
        this.sharedCache = sharedCache;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.name, (String)"name property not set");
        this.resourceKeyTxnData = "TransactionalCache.TxnData." + this.name;
        this.logger = LogFactory.getLog((String)(TransactionalCache.class.getName() + "." + this.name));
        this.isDebugEnabled = this.logger.isDebugEnabled();
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)AlfrescoTransactionSupport.getResource(this.resourceKeyTxnData);
        if (data == null) {
            data = new TransactionData();
            data.updatedItemsCache = new LRULinkedHashMap(23);
            data.removedItemsCache = new HashSet(13);
            AlfrescoTransactionSupport.bindListener(this);
            AlfrescoTransactionSupport.bindResource(this.resourceKeyTxnData, data);
        }
        return data;
    }

    public boolean contains(K key) {
        V value = this.get(key);
        return value != null;
    }

    public Collection<K> getKeys() {
        HashSet keys = null;
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            keys = new HashSet(23);
            TransactionData txnData = this.getTransactionData();
            if (!txnData.isClearOn) {
                Collection backingKeys = this.sharedCache.getKeys();
                keys.addAll(backingKeys);
            }
            keys.addAll(txnData.updatedItemsCache.keySet());
            keys.removeAll(txnData.removedItemsCache);
        } else {
            keys = this.sharedCache.getKeys();
        }
        return keys;
    }

    private V getSharedCacheValue(K key) {
        return (V)this.sharedCache.get(key);
    }

    public V get(K key) {
        TransactionData txnData;
        boolean ignoreSharedCache = false;
        if (AlfrescoTransactionSupport.getTransactionId() != null && !(txnData = this.getTransactionData()).isClosed) {
            try {
                if (!txnData.isClearOn && txnData.removedItemsCache.contains(key)) {
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("get returning null - item has been removed from transactional cache: \n   cache: " + this + "\n" + "   key: " + key));
                    }
                    return null;
                }
                CacheBucket bucket = (CacheBucket)txnData.updatedItemsCache.get(key);
                if (bucket != null) {
                    Object value = bucket.getValue();
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("Found item in transactional cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                    }
                    return (V)value;
                }
            }
            catch (CacheException e) {
                throw new AlfrescoRuntimeException("Cache failure", (Throwable)e);
            }
            ignoreSharedCache = txnData.isClearOn;
        }
        if (!ignoreSharedCache) {
            V value = this.getSharedCacheValue(key);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No value found in transaction - fetching instance from shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
            return value;
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("No value found in transaction and ignoring shared cache: \n   cache: " + this + "\n" + "   key: " + key));
        }
        return null;
    }

    public void put(K key, V value) {
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.put(key, value);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - adding item direct to shared cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit add: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            } else {
                if (txnData.updatedItemsCache.hasHitSize()) {
                    txnData.isClearOn = true;
                    if (!txnData.haveIssuedFullWarning && this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Transactional update cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                        txnData.haveIssuedFullWarning = true;
                    }
                }
                Object existingValueObj = this.sharedCache.get(key);
                CacheBucket<Object> bucket = null;
                bucket = existingValueObj == null ? new NewCacheBucket<V>(value) : new UpdateCacheBucket<Object>(existingValueObj, value);
                txnData.updatedItemsCache.put(key, bucket);
                txnData.removedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional update cache: \n   cache: " + this + "\n" + "   key: " + key + "\n" + "   value: " + value));
                }
            }
        }
    }

    public void remove(K key) {
        if (AlfrescoTransactionSupport.getTransactionId() == null) {
            this.sharedCache.remove(key);
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("No transaction - removing item from shared cache: \n   cache: " + this + "\n" + "   key: " + key));
            }
        } else {
            TransactionData txnData = this.getTransactionData();
            if (txnData.isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit remove: \n   cache: " + this + "\n" + "   key: " + key));
                }
            } else {
                if (!txnData.isClearOn) {
                    if (txnData.removedItemsCache.size() >= this.maxCacheSize) {
                        txnData.isClearOn = true;
                        if (!txnData.haveIssuedFullWarning && this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Transactional removal cache '" + this.name + "' is full (" + this.maxCacheSize + ")."));
                            txnData.haveIssuedFullWarning = true;
                        }
                    } else {
                        txnData.removedItemsCache.add(key);
                    }
                }
                txnData.updatedItemsCache.remove(key);
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In transaction - adding item direct to transactional removed cache: \n   cache: " + this + "\n" + "   key: " + key));
                }
            }
        }
    }

    public void clear() {
        if (AlfrescoTransactionSupport.getTransactionId() != null) {
            TransactionData txnData;
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("In transaction clearing cache: \n   cache: " + this + "\n" + "   txn: " + AlfrescoTransactionSupport.getTransactionId()));
            }
            if ((txnData = this.getTransactionData()).isClosed) {
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("In post-commit clear: \n   cache: " + this));
                }
            } else {
                txnData.isClearOn = true;
                txnData.updatedItemsCache.clear();
                txnData.removedItemsCache.clear();
            }
        } else {
            if (this.isDebugEnabled) {
                this.logger.debug((Object)"No transaction - clearing shared cache");
            }
            this.sharedCache.clear();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void afterCommit() {
        if (this.isDebugEnabled) {
            this.logger.debug((Object)"Processing after-commit");
        }
        TransactionData txnData = this.getTransactionData();
        try {
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)"Clear notification recieved in commit - clearing shared cache");
                }
            } else {
                for (Serializable key : txnData.removedItemsCache) {
                    this.sharedCache.remove(key);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in commit"));
                }
            }
            Set keys = txnData.updatedItemsCache.keySet();
            for (Map.Entry entry : txnData.updatedItemsCache.entrySet()) {
                Serializable key = (Serializable)entry.getKey();
                CacheBucket bucket = (CacheBucket)entry.getValue();
                bucket.doPostCommit(this.sharedCache, key);
            }
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("Added " + keys.size() + " values to shared cache"));
            }
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", (Throwable)e);
        }
        finally {
            this.removeCaches(txnData);
        }
    }

    @Override
    public void afterRollback() {
        TransactionData txnData = this.getTransactionData();
        try {
            if (txnData.isClearOn) {
                this.sharedCache.clear();
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)"Clear notification recieved in rollback - clearing shared cache");
                }
            } else {
                for (Serializable key : txnData.removedItemsCache) {
                    this.sharedCache.remove(key);
                }
                if (this.isDebugEnabled) {
                    this.logger.debug((Object)("Removed " + txnData.removedItemsCache.size() + " values from shared cache in rollback"));
                }
            }
        }
        catch (CacheException e) {
            throw new AlfrescoRuntimeException("Failed to transfer updates to shared cache", (Throwable)e);
        }
        finally {
            this.removeCaches(txnData);
        }
    }

    private void removeCaches(TransactionData txnData) {
        txnData.isClosed = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRULinkedHashMap<K1, V1>
    extends LinkedHashMap<K1, V1> {
        private static final long serialVersionUID = -4874684348174271106L;

        private LRULinkedHashMap(int initialSize) {
            super(initialSize);
        }

        private boolean hasHitSize() {
            return this.size() >= TransactionalCache.this.maxCacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K1, V1> eldest) {
            return this.size() > TransactionalCache.this.maxCacheSize;
        }
    }

    private class TransactionData {
        private LRULinkedHashMap<K, CacheBucket<V>> updatedItemsCache;
        private Set<K> removedItemsCache;
        private boolean haveIssuedFullWarning;
        private boolean isClearOn;
        private boolean isClosed;

        private TransactionData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = 7885689778259779578L;
        private final BV value;
        private final BV originalValue;

        public UpdateCacheBucket(BV originalValue, BV value) {
            this.originalValue = originalValue;
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key) {
            Object sharedValue = sharedCache.get(key);
            if (sharedValue != null) {
                if (sharedValue == this.originalValue) {
                    sharedCache.put(key, this.getValue());
                } else {
                    sharedCache.remove(key);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NewCacheBucket<BV>
    implements CacheBucket<BV> {
        private static final long serialVersionUID = -8536386687213957425L;
        private final BV value;

        public NewCacheBucket(BV value) {
            this.value = value;
        }

        @Override
        public BV getValue() {
            return this.value;
        }

        @Override
        public void doPostCommit(SimpleCache<Serializable, Object> sharedCache, Serializable key) {
            Object sharedValue = sharedCache.get(key);
            if (sharedValue != null) {
                sharedCache.remove(key);
            } else {
                sharedCache.put(key, this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CacheBucket<BV>
    extends Serializable {
        public BV getValue();

        public void doPostCommit(SimpleCache<Serializable, Object> var1, Serializable var2);
    }
}

