/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.DWGMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DWGMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private DWGMetadataExtracter extracter;
    private static final QName TIKA_LAST_AUTHOR_TEST_PROPERTY = QName.createQName((String)"TikaLastAuthorTestProp");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new DWGMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
        HashMap<String, Set<QName>> newMap = new HashMap<String, Set<QName>>(this.extracter.getMapping());
        HashSet<QName> tlaSet = new HashSet<QName>();
        tlaSet.add(TIKA_LAST_AUTHOR_TEST_PROPERTY);
        newMap.put("Last-Author", tlaSet);
        this.extracter.setMapping(newMap);
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : DWGMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            DWGMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        String mimetype = "application/dwg";
        for (String version : new String[]{"2004", "2007", "2010"}) {
            String filename = "quick" + version + ".dwg";
            URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/" + filename);
            File file = new File(url.getFile());
            Map<QName, Serializable> properties = this.extractFromFile(file, mimetype);
            DWGMetadataExtracterTest.assertFalse((String)("extractFromMimetype should return at least some properties, none found for " + mimetype), (boolean)properties.isEmpty());
            this.testCommonMetadata(mimetype, properties);
            this.testFileSpecificMetadata(mimetype, properties);
        }
    }

    @Override
    protected boolean skipAuthorCheck(String mimetype) {
        return true;
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        DWGMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)"Nevin Nollop", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
        DWGMetadataExtracterTest.assertTrue((String)("Test Property " + TIKA_LAST_AUTHOR_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(TIKA_LAST_AUTHOR_TEST_PROPERTY));
        DWGMetadataExtracterTest.assertEquals((String)("Test Property " + TIKA_LAST_AUTHOR_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)"paolon", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(TIKA_LAST_AUTHOR_TEST_PROPERTY))));
    }
}

