/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.ContentWorker;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MetadataExtracter
extends ContentWorker {
    public double getReliability(String var1);

    public boolean isSupported(String var1);

    public long getExtractionTime();

    public Map<QName, Serializable> extract(ContentReader var1, Map<QName, Serializable> var2);

    public Map<QName, Serializable> extract(ContentReader var1, OverwritePolicy var2, Map<QName, Serializable> var3);

    public Map<QName, Serializable> extract(ContentReader var1, OverwritePolicy var2, Map<QName, Serializable> var3, Map<String, Set<QName>> var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverwritePolicy {
        EAGER{

            @Override
            public Map<QName, Serializable> applyProperties(Map<QName, Serializable> extractedProperties, Map<QName, Serializable> targetProperties) {
                HashMap<QName, Serializable> modifiedProperties = new HashMap<QName, Serializable>(7);
                for (Map.Entry<QName, Serializable> entry : extractedProperties.entrySet()) {
                    QName propertyQName = entry.getKey();
                    Serializable extractedValue = entry.getValue();
                    if (extractedValue != null) {
                        targetProperties.put(propertyQName, extractedValue);
                    }
                    modifiedProperties.put(propertyQName, extractedValue);
                }
                return modifiedProperties;
            }
        }
        ,
        PRAGMATIC{

            @Override
            public Map<QName, Serializable> applyProperties(Map<QName, Serializable> extractedProperties, Map<QName, Serializable> targetProperties) {
                HashMap<QName, Serializable> modifiedProperties = new HashMap<QName, Serializable>(7);
                for (Map.Entry<QName, Serializable> entry : extractedProperties.entrySet()) {
                    String originalValueStr;
                    QName propertyQName = entry.getKey();
                    Serializable extractedValue = entry.getValue();
                    if (extractedValue == null) {
                        modifiedProperties.put(propertyQName, extractedValue);
                        continue;
                    }
                    if (!targetProperties.containsKey(propertyQName)) {
                        targetProperties.put(propertyQName, extractedValue);
                        modifiedProperties.put(propertyQName, extractedValue);
                        continue;
                    }
                    Serializable originalValue = targetProperties.get(propertyQName);
                    if (originalValue == null) {
                        targetProperties.put(propertyQName, extractedValue);
                        modifiedProperties.put(propertyQName, extractedValue);
                        continue;
                    }
                    if (!(originalValue instanceof String) || (originalValueStr = (String)((Object)originalValue)) != null && originalValueStr.length() > 0) continue;
                    targetProperties.put(propertyQName, extractedValue);
                    modifiedProperties.put(propertyQName, extractedValue);
                }
                return modifiedProperties;
            }
        }
        ,
        CAUTIOUS{

            @Override
            public Map<QName, Serializable> applyProperties(Map<QName, Serializable> extractedProperties, Map<QName, Serializable> targetProperties) {
                HashMap<QName, Serializable> modifiedProperties = new HashMap<QName, Serializable>(7);
                for (Map.Entry<QName, Serializable> entry : extractedProperties.entrySet()) {
                    QName propertyQName = entry.getKey();
                    Serializable extractedValue = entry.getValue();
                    if (extractedValue == null) {
                        modifiedProperties.put(propertyQName, extractedValue);
                        continue;
                    }
                    if (targetProperties.containsKey(propertyQName)) continue;
                    targetProperties.put(propertyQName, extractedValue);
                    modifiedProperties.put(propertyQName, extractedValue);
                }
                return modifiedProperties;
            }
        };


        public Map<QName, Serializable> applyProperties(Map<QName, Serializable> extractedProperties, Map<QName, Serializable> targetProperties) {
            throw new UnsupportedOperationException("Override this method");
        }
    }
}

