/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ArchiveContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class ArchiveContentTransformerTest
extends AbstractContentTransformerTest {
    private ArchiveContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new ArchiveContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        ArchiveContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/zip", "text/plain", new TransformationOptions()));
        ArchiveContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/x-tar", "text/plain", new TransformationOptions()));
        ArchiveContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/x-gtar", "text/plain", new TransformationOptions()));
    }

    protected boolean isQuickPhraseExpected(String targetMimetype) {
        return false;
    }

    protected boolean isQuickWordsExpected(String targetMimetype) {
        return false;
    }

    public void testRecursing() throws Exception {
        this.transformer.setIncludeContents("FALSE");
        ContentWriter writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer);
        String contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, false);
        this.transformer.setIncludeContents("TRUE");
        writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer);
        contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, true);
        TransformationOptions options = new TransformationOptions();
        this.transformer.setIncludeContents("FALSE");
        writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer, options);
        contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, false);
        this.transformer.setIncludeContents("TRUE");
        writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer, options);
        contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, true);
        options.setIncludeEmbedded(true);
        this.transformer.setIncludeContents("FALSE");
        writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer, options);
        contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, true);
        this.transformer.setIncludeContents("TRUE");
        writer = this.getTestWriter();
        this.transformer.transform(this.getTestReader(), writer, options);
        contents = writer.getReader().getContentString();
        this.testHasFiles(contents);
        this.testNested(contents, true);
    }

    private ContentReader getTestReader() throws IOException {
        FileContentReader sourceReader = new FileContentReader(ArchiveContentTransformerTest.loadQuickTestFile("zip"));
        sourceReader.setMimetype("application/zip");
        return sourceReader;
    }

    private ContentWriter getTestWriter() throws IOException {
        FileContentWriter writer = new FileContentWriter(File.createTempFile("test", ".txt"));
        writer.setMimetype("text/plain");
        return writer;
    }

    private void testHasFiles(String contents) {
        ArchiveContentTransformerTest.assertTrue((String)("Files not found in " + contents), (boolean)contents.contains("quick.txt"));
        ArchiveContentTransformerTest.assertTrue((String)("Files not found in " + contents), (boolean)contents.contains("quick.doc"));
        ArchiveContentTransformerTest.assertTrue((String)("Files not found in " + contents), (boolean)contents.contains("subfolder/quick.jpg"));
    }

    private void testNested(String contents, boolean shouldHaveRecursed) {
        ArchiveContentTransformerTest.assertEquals((String)("Recursion was " + shouldHaveRecursed + " but content was " + contents), (boolean)shouldHaveRecursed, (boolean)contents.contains("The quick brown fox jumps over the lazy dog"));
        ArchiveContentTransformerTest.assertEquals((String)("Recursion was " + shouldHaveRecursed + " but content was " + contents), (boolean)shouldHaveRecursed, (boolean)contents.contains("Le renard brun rapide saute par-dessus le chien paresseux"));
    }
}

