/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.repo.content.ContentMinimalContextTestSuite;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerWorker;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.BaseAlfrescoTestCase;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.exec.RuntimeExec;

public class RuntimeExecutableContentTransformerTest
extends BaseAlfrescoTestCase {
    private ContentTransformer transformer;

    protected void setUpContext() {
        this.ctx = ContentMinimalContextTestSuite.getContext();
    }

    protected void setUp() throws Exception {
        super.setUp();
        RuntimeExecutableContentTransformerWorker worker = new RuntimeExecutableContentTransformerWorker();
        RuntimeExec transformCommand = new RuntimeExec();
        HashMap<String, String> commandMap = new HashMap<String, String>(5);
        commandMap.put("Mac OS X", "mv -f ${source} ${target}");
        commandMap.put("Linux", "mv -f ${source} ${target}");
        commandMap.put(".*", "cmd /c copy /Y \"${source}\" \"${target}\"");
        transformCommand.setCommandMap(commandMap);
        transformCommand.setErrorCodes("1, 2");
        worker.setTransformCommand(transformCommand);
        worker.setMimetypeService(this.serviceRegistry.getMimetypeService());
        ArrayList<ExplictTransformationDetails> explicitTranformations = new ArrayList<ExplictTransformationDetails>(1);
        explicitTranformations.add(new ExplictTransformationDetails("text/plain", "text/xml"));
        worker.setExplicitTransformations(explicitTranformations);
        worker.afterPropertiesSet();
        ProxyContentTransformer transformer = new ProxyContentTransformer();
        transformer.setMimetypeService(this.serviceRegistry.getMimetypeService());
        transformer.setWorker(worker);
        this.transformer = transformer;
    }

    public void testCopyCommand() throws Exception {
        String content = "<A><B></B></A>";
        File sourceFile = TempFileProvider.createTempFile((String)(this.getName() + "_"), (String)".txt");
        FileContentWriter tempWriter = new FileContentWriter(sourceFile);
        tempWriter.setMimetype("text/plain");
        tempWriter.putContent(content);
        ContentReader reader = tempWriter.getReader();
        File targetFile = TempFileProvider.createTempFile((String)(this.getName() + "_"), (String)".xml");
        FileContentWriter writer = new FileContentWriter(targetFile);
        writer.setMimetype("text/xml");
        this.transformer.transform(reader, writer);
        ContentReader checkReader = writer.getReader();
        String checkContent = checkReader.getContentString();
        RuntimeExecutableContentTransformerTest.assertEquals((String)"Content not copied", (String)content, (String)checkContent);
    }
}

