/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.TransformerInfoException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TikaPoweredContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(TikaPoweredContentTransformer.class);
    protected List<String> sourceMimeTypes;
    protected static final String LINE_BREAK = "\r\n";
    public static final String WRONG_FORMAT_MESSAGE_ID = "transform.err.format_or_password";

    protected TikaPoweredContentTransformer(List<String> sourceMimeTypes) {
        this.sourceMimeTypes = sourceMimeTypes;
    }

    protected TikaPoweredContentTransformer(String[] sourceMimeTypes) {
        this(Arrays.asList(sourceMimeTypes));
    }

    protected abstract Parser getParser();

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!this.sourceMimeTypes.contains(sourceMimetype)) {
            return false;
        }
        return "text/plain".equals(targetMimetype) || "text/html".equals(targetMimetype) || "application/xhtml+xml".equals(targetMimetype) || "text/xml".equals(targetMimetype);
    }

    protected ContentHandler getContentHandler(String targetMimeType, Writer output) throws TransformerConfigurationException {
        if ("text/plain".equals(targetMimeType)) {
            return new BodyContentHandler(output);
        }
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(output));
        if ("text/html".equals(targetMimeType)) {
            handler.getTransformer().setOutputProperty("method", "html");
        } else if ("application/xhtml+xml".equals(targetMimeType) || "text/xml".equals(targetMimeType)) {
            handler.getTransformer().setOutputProperty("method", "xml");
        } else {
            throw new TransformerInfoException(WRONG_FORMAT_MESSAGE_ID, new IllegalArgumentException("Requested target type " + targetMimeType + " not supported"));
        }
        return handler;
    }

    protected ParseContext buildParseContext(Metadata metadata, String targetMimeType, TransformationOptions options) {
        return new ParseContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        Throwable e22;
        OutputStreamWriter ow;
        OutputStream os;
        block17: {
            InputStream is = reader.getContentInputStream();
            os = writer.getContentOutputStream();
            String encoding = writer.getEncoding();
            String targetMimeType = writer.getMimetype();
            ow = new OutputStreamWriter(os, encoding);
            Parser parser = this.getParser();
            Metadata metadata = new Metadata();
            ParseContext context = this.buildParseContext(metadata, targetMimeType, options);
            ContentHandler handler = this.getContentHandler(targetMimeType, ow);
            if (handler == null) {
                throw new TransformerConfigurationException("Unable to create Tika Handler for configured output " + targetMimeType);
            }
            try {
                parser.parse(is, handler, metadata, context);
                Object var14_13 = null;
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var14_14 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                if (ow != null) {
                    try {
                        ((Writer)ow).close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Throwable e22) {
                // empty catch block
            }
        }
        if (ow != null) {
            try {
                ((Writer)ow).close();
            }
            catch (Throwable e22) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Throwable e22) {}
        }
    }
}

