/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.util.Collections;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ProxyContentTransformer;
import org.alfresco.repo.content.transform.magick.ImageMagickContentTransformerWorker;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.exec.RuntimeExec;

public class ImageMagickContentTransformerTest
extends AbstractContentTransformerTest {
    private ImageMagickContentTransformerWorker worker;
    private ContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        RuntimeExec executer = new RuntimeExec();
        executer.setCommand(new String[]{"imconvert.exe", "${source}", "${options}", "${target}"});
        executer.setDefaultProperties(Collections.singletonMap("options", ""));
        this.worker = new ImageMagickContentTransformerWorker();
        this.worker.setMimetypeService(this.mimetypeService);
        this.worker.setExecuter(executer);
        this.worker.afterPropertiesSet();
        ProxyContentTransformer transformer = new ProxyContentTransformer();
        transformer.setMimetypeService(this.mimetypeService);
        transformer.setWorker(this.worker);
        this.transformer = transformer;
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        if (!this.worker.isAvailable()) {
            return;
        }
        boolean reliability = this.transformer.isTransformable("image/gif", "text/plain", new TransformationOptions());
        ImageMagickContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("image/gif", "image/jpeg", new TransformationOptions());
        ImageMagickContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
    }
}

