/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.debug.NodeStoreInspector;

public class DescriptorServiceTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ImporterBootstrap systemBootstrap;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.systemBootstrap = (ImporterBootstrap)((Object)this.applicationContext.getBean("systemBootstrap"));
        this.storeRef = new StoreRef("system", "Test_" + System.currentTimeMillis());
        this.systemBootstrap.setStoreUrl(this.storeRef.toString());
        this.systemBootstrap.bootstrap();
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        System.out.println(NodeStoreInspector.dumpNodeStore(this.nodeService, this.storeRef));
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testServerDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor serverDescriptor = descriptorService.getServerDescriptor();
        String major = serverDescriptor.getVersionMajor();
        String minor = serverDescriptor.getVersionMinor();
        String revision = serverDescriptor.getVersionRevision();
        String label = serverDescriptor.getVersionLabel();
        String build = serverDescriptor.getVersionBuild();
        String version = major + "." + minor + "." + revision;
        version = this.buildVersionString(version, label, build);
        DescriptorServiceTest.assertEquals((String)version, (String)serverDescriptor.getVersion());
        int schemaVersion = serverDescriptor.getSchema();
        DescriptorServiceTest.assertTrue((String)"Server schema version must be greater than 0", (schemaVersion > 0 ? 1 : 0) != 0);
    }

    public void testRepositoryDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        DescriptorService descriptorService = registry.getDescriptorService();
        Descriptor repoDescriptor = descriptorService.getInstalledRepositoryDescriptor();
        String major = repoDescriptor.getVersionMajor();
        String minor = repoDescriptor.getVersionMinor();
        String revision = repoDescriptor.getVersionRevision();
        String label = repoDescriptor.getVersionLabel();
        String build = repoDescriptor.getVersionBuild();
        String version = major + "." + minor + "." + revision;
        version = this.buildVersionString(version, label, build);
        DescriptorServiceTest.assertEquals((String)version, (String)repoDescriptor.getVersion());
        int schemaVersion = repoDescriptor.getSchema();
        DescriptorServiceTest.assertTrue((String)"Repository schema version must be greater than -1", (schemaVersion > -1 ? 1 : 0) != 0);
    }

    private String buildVersionString(String version, String label, String build) {
        boolean hasBuild;
        StringBuilder builder = new StringBuilder(version);
        boolean hasLabel = label != null && label.length() > 0;
        boolean bl = hasBuild = build != null && build.length() > 0;
        if (hasLabel || hasBuild) {
            builder.append(" (");
        }
        if (hasLabel) {
            builder.append(label);
        }
        if (hasBuild) {
            if (hasLabel) {
                builder.append(" ");
            }
            builder.append(build);
        }
        if (hasLabel || hasBuild) {
            builder.append(")");
        }
        return builder.toString();
    }
}

