/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryModelType
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnRemoveAspectPolicy {
    private static Log logger = LogFactory.getLog(DictionaryModelType.class);
    private static final String KEY_PENDING_MODELS = "dictionaryModelType.pendingModels";
    private static final String KEY_PENDING_DELETE_MODELS = "dictionaryModelType.pendingDeleteModels";
    private static final String KEY_WORKING_COPY = "dictionaryModelType.workingCopy";
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"DictionaryModelType");
    private DictionaryDAO dictionaryDAO;
    private NamespaceDAO namespaceDAO;
    private NodeService nodeService;
    private ContentService contentService;
    private PolicyComponent policyComponent;
    private WorkflowService workflowService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private TenantService tenantService;
    private TenantAdminService tenantAdminService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private DictionaryModelTypeTransactionListener transactionListener;
    private List<String> storeUrls;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setNamespaceDAO(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setStoreUrls(List<String> storeUrls) {
        this.storeUrls = storeUrls;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.transactionListener = new DictionaryModelTypeTransactionListener(this.nodeService, this.contentService);
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onContentUpdate: nodeRef=" + nodeRef + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        this.queueModel(nodeRef);
    }

    private void queueModel(NodeRef nodeRef) {
        CopyOnWriteArraySet<NodeRef> pendingModels = (CopyOnWriteArraySet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_PENDING_MODELS);
        if (pendingModels == null) {
            pendingModels = new CopyOnWriteArraySet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_PENDING_MODELS, pendingModels);
        }
        pendingModels.add(this.tenantService.getName(nodeRef));
        AlfrescoTransactionSupport.bindListener(this.transactionListener);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onUpdateProperties: nodeRef=" + nodeRef + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        Boolean beforeValue = (Boolean)before.get(ContentModel.PROP_MODEL_ACTIVE);
        Boolean afterValue = (Boolean)after.get(ContentModel.PROP_MODEL_ACTIVE);
        if (beforeValue == null && afterValue != null) {
            this.queueModel(nodeRef);
        } else if (afterValue == null && beforeValue != null) {
            this.queueModel(nodeRef);
        } else if (beforeValue != null && afterValue != null && !beforeValue.equals(afterValue)) {
            this.queueModel(nodeRef);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspect) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onRemoveAspect: nodeRef=" + nodeRef + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        if (aspect.equals((Object)ContentModel.ASPECT_WORKING_COPY)) {
            AlfrescoTransactionSupport.bindResource(KEY_WORKING_COPY, nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        boolean workingCopy = this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
        NodeRef wcNodeRef = (NodeRef)AlfrescoTransactionSupport.getResource(KEY_WORKING_COPY);
        if (wcNodeRef != null && wcNodeRef.equals((Object)nodeRef)) {
            workingCopy = true;
        }
        boolean isVersionNode = nodeRef.getStoreRef().getIdentifier().equals("version2Store");
        if (!workingCopy && !isVersionNode) {
            QName modelName = (QName)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_NAME);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("beforeDeleteNode: nodeRef=" + nodeRef + " validate model delete (modelName=" + modelName + ")"));
            }
            if (modelName != null) {
                this.validateModelDelete(modelName);
                CopyOnWriteArraySet<NodeRef> pendingModelDeletes = (CopyOnWriteArraySet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_PENDING_DELETE_MODELS);
                if (pendingModelDeletes == null) {
                    pendingModelDeletes = new CopyOnWriteArraySet<NodeRef>();
                    AlfrescoTransactionSupport.bindResource(KEY_PENDING_DELETE_MODELS, pendingModelDeletes);
                }
                pendingModelDeletes.add(this.tenantService.getName(nodeRef));
                AlfrescoTransactionSupport.bindListener(this.transactionListener);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeDeleteNode: nodeRef=" + nodeRef + " ignored (" + (workingCopy ? " workingCopy " : "") + (isVersionNode ? " isVersionNode " : "") + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        Boolean value;
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onCreateNode: nodeRef=" + nodeRef + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
        }
        if (this.nodeService.getType(nodeRef).equals((Object)ContentModel.TYPE_DICTIONARY_MODEL) && (value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE)) != null && value.booleanValue()) {
            this.queueModel(nodeRef);
        }
    }

    private void validateModelDelete(final QName modelName) {
        Collection aspectDefs;
        Collection typeDefs;
        Collection namespaceDefs;
        try {
            namespaceDefs = this.dictionaryDAO.getNamespaces(modelName);
            typeDefs = this.dictionaryDAO.getTypes(modelName);
            aspectDefs = this.dictionaryDAO.getAspects(modelName);
        }
        catch (DictionaryException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Dictionary model '" + modelName + "' does not exist ... skip delete validation : " + (Object)((Object)e)));
            }
            return;
        }
        this.validateModelDelete(namespaceDefs, typeDefs, aspectDefs, false);
        if (this.tenantService.isEnabled() && !this.tenantService.isTenantUser()) {
            List<Tenant> tenants = this.tenantAdminService.getAllTenants();
            for (Tenant tenant : tenants) {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() {
                        if (DictionaryModelType.this.dictionaryDAO.isModelInherited(modelName)) {
                            DictionaryModelType.this.validateModelDelete(namespaceDefs, typeDefs, aspectDefs, true);
                        }
                        return null;
                    }
                }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant.getTenantDomain()));
            }
        }
    }

    private void validateModelDelete(Collection<NamespaceDefinition> namespaceDefs, Collection<TypeDefinition> typeDefs, Collection<AspectDefinition> aspectDefs, boolean sharedModel) {
        List<WorkflowDefinition> workflowDefs;
        String tenantDomain = "";
        if (sharedModel) {
            tenantDomain = " for tenant [" + this.tenantService.getCurrentUserDomain() + "]";
        }
        if ((workflowDefs = this.workflowService.getDefinitions()).size() > 0 && namespaceDefs.size() > 0) {
            for (WorkflowDefinition workflowDef : workflowDefs) {
                String workflowDefName = workflowDef.getName();
                String workflowNamespaceURI = QName.createQName((String)BPMEngineRegistry.getLocalId(workflowDefName), (NamespacePrefixResolver)this.namespaceService).getNamespaceURI();
                for (NamespaceDefinition namespaceDef : namespaceDefs) {
                    if (!workflowNamespaceURI.equals(namespaceDef.getUri())) continue;
                    throw new AlfrescoRuntimeException("Failed to validate model delete" + tenantDomain + " - found workflow process definition " + workflowDefName + " using model namespace '" + namespaceDef.getUri() + "'");
                }
            }
        }
        for (TypeDefinition type : typeDefs) {
            this.validateClass(tenantDomain, (ClassDefinition)type);
        }
        for (AspectDefinition aspect : aspectDefs) {
            this.validateClass(tenantDomain, (ClassDefinition)aspect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClass(String tenantDomain, ClassDefinition classDef) {
        QName className = classDef.getName();
        String classType = "TYPE";
        if (classDef instanceof AspectDefinition) {
            classType = "ASPECT";
        }
        for (String storeUrl : this.storeUrls) {
            Object var10_9;
            StoreRef store = new StoreRef(storeUrl);
            ResultSet rs = this.searchService.query(store, "lucene", classType + ":\"" + className + "\"");
            try {
                if (rs.length() > 0) {
                    throw new AlfrescoRuntimeException("Failed to validate model delete" + tenantDomain + " - found " + rs.length() + " nodes in store " + store + " with " + classType + " '" + className + "'");
                }
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            {
            }
        }
        for (WorkflowDefinition workflowDef : this.workflowService.getDefinitions()) {
            for (WorkflowTaskDefinition workflowTaskDef : this.workflowService.getTaskDefinitions(workflowDef.getId())) {
                TypeDefinition workflowTypeDef = workflowTaskDef.metadata;
                if (!workflowTypeDef.getName().toString().equals(className)) continue;
                throw new AlfrescoRuntimeException("Failed to validate model delete" + tenantDomain + " - found task definition in workflow " + workflowDef.getName() + " with " + classType + " '" + className + "'");
            }
        }
    }

    private void validateModel(QName modelName, M2Model model, CompiledModel compiledModel) {
        List modelDiffs = this.dictionaryDAO.diffModel(model);
        for (M2ModelDiff modelDiff : modelDiffs) {
            if (modelDiff.getDiffType().equals("deleted")) {
                if (modelDiff.getElementType().equals("PROPERTY")) {
                    this.validatePropertyDelete(modelName, modelDiff.getElementName(), false);
                    continue;
                }
                if (modelDiff.getElementType().equals("TYPE_CONSTRAINT")) {
                    this.validateConstraintDelete(compiledModel, modelDiff.getElementName(), false);
                    continue;
                }
                throw new AlfrescoRuntimeException("Failed to validate model update - found deleted " + modelDiff.getElementType() + " '" + modelDiff.getElementName() + "'");
            }
            if (!modelDiff.getDiffType().equals("updated")) continue;
            throw new AlfrescoRuntimeException("Failed to validate model update - found non-incrementally updated " + modelDiff.getElementType() + " '" + modelDiff.getElementName() + "'");
        }
    }

    private void validatePropertyDelete(QName modelName, QName propertyName, boolean sharedModel) {
        String tenantDomain = "";
        if (sharedModel) {
            tenantDomain = " for tenant [" + this.tenantService.getCurrentUserDomain() + "]";
        }
        boolean found = false;
        for (PropertyDefinition prop : this.dictionaryDAO.getProperties(modelName, null)) {
            if (!prop.getName().equals((Object)propertyName)) continue;
            found = true;
            this.validateIndexedProperty(tenantDomain, prop);
            break;
        }
        if (!found) {
            throw new AlfrescoRuntimeException("Failed to validate property delete" + tenantDomain + " - property definition '" + propertyName + "' not defined in model '" + modelName + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIndexedProperty(String tenantDomain, PropertyDefinition propDef) {
        QName propName = propDef.getName();
        if (!propDef.isIndexed()) {
            throw new AlfrescoRuntimeException("Failed to validate property delete" + tenantDomain + " - cannot delete unindexed property definition '" + propName);
        }
        for (String storeUrl : this.storeUrls) {
            Object var10_9;
            StoreRef store = new StoreRef(storeUrl);
            String escapePropName = propName.toPrefixString().replace(":", "\\:");
            ResultSet rs = this.searchService.query(store, "lucene", "@" + escapePropName + ":*");
            try {
                if (rs.length() > 0) {
                    throw new AlfrescoRuntimeException("Failed to validate property delete" + tenantDomain + " - found " + rs.length() + " nodes in store " + store + " with PROPERTY '" + propName + "'");
                }
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            {
            }
        }
    }

    private void validateConstraintDelete(CompiledModel compiledModel, QName constraintName, boolean sharedModel) {
        String tenantDomain = "";
        if (sharedModel) {
            tenantDomain = " for tenant [" + this.tenantService.getCurrentUserDomain() + "]";
        }
        HashSet<QName> referencedBy = new HashSet<QName>(0);
        Collection allModels = this.dictionaryDAO.getModels();
        for (QName model : allModels) {
            Collection propDefs = null;
            propDefs = compiledModel.getModelDefinition().getName().equals((Object)model) ? compiledModel.getProperties() : this.dictionaryDAO.getProperties(model);
            for (PropertyDefinition propDef : propDefs) {
                for (ConstraintDefinition conDef : propDef.getConstraints()) {
                    if (!constraintName.equals((Object)conDef.getRef())) continue;
                    referencedBy.add(conDef.getName());
                }
            }
        }
        if (referencedBy.size() == 1) {
            throw new AlfrescoRuntimeException("Failed to validate constraint delete" + tenantDomain + " - constraint definition '" + constraintName + "' is being referenced by '" + referencedBy.toArray()[0] + "' property constraint");
        }
        if (referencedBy.size() > 1) {
            throw new AlfrescoRuntimeException("Failed to validate constraint delete" + tenantDomain + " - constraint definition '" + constraintName + "' is being referenced by " + referencedBy.size() + " property constraints");
        }
    }

    static /* synthetic */ NamespaceDAO access$800(DictionaryModelType x0) {
        return x0.namespaceDAO;
    }

    static /* synthetic */ void access$900(DictionaryModelType x0, QName x1, M2Model x2, CompiledModel x3) {
        x0.validateModel(x1, x2, x3);
    }

    static /* synthetic */ void access$1000(DictionaryModelType x0, QName x1) {
        x0.validateModelDelete(x1);
    }

    public class DictionaryModelTypeTransactionListener
    extends TransactionListenerAdapter {
        private String id = GUID.generate();
        private NodeService nodeService;
        private ContentService contentService;

        public DictionaryModelTypeTransactionListener(NodeService nodeService, ContentService contentService) {
            this.nodeService = nodeService;
            this.contentService = contentService;
        }

        public void afterCommit() {
            String tenantSystemUserName;
            String tenantDomain;
            Set pendingModels = (Set)AlfrescoTransactionSupport.getResource(DictionaryModelType.KEY_PENDING_MODELS);
            Set pendingDeleteModels = (Set)AlfrescoTransactionSupport.getResource(DictionaryModelType.KEY_PENDING_DELETE_MODELS);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("afterCommit: " + Thread.currentThread().getName() + " pendingModelsCnt=" + (pendingModels != null ? Integer.valueOf(pendingModels.size()) : "0") + ", pendingDeleteModelsCnt=" + (pendingDeleteModels != null ? Integer.valueOf(pendingDeleteModels.size()) : "0")));
            }
            HashSet<String> systemTenants = new HashSet<String>(10);
            if (pendingModels != null) {
                AlfrescoTransactionSupport.unbindResource(DictionaryModelType.KEY_PENDING_MODELS);
                for (NodeRef nodeRef : pendingModels) {
                    tenantDomain = DictionaryModelType.this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
                    tenantSystemUserName = DictionaryModelType.this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
                    systemTenants.add(tenantSystemUserName);
                }
            }
            if (pendingDeleteModels != null) {
                AlfrescoTransactionSupport.unbindResource(DictionaryModelType.KEY_PENDING_DELETE_MODELS);
                for (NodeRef nodeRef : pendingDeleteModels) {
                    tenantDomain = DictionaryModelType.this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
                    tenantSystemUserName = DictionaryModelType.this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
                    systemTenants.add(tenantSystemUserName);
                }
            }
            if (systemTenants.size() > 0) {
                for (final String tenantSystemUserName2 : systemTenants) {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                                public Object doWork() {
                                    DictionaryModelType.this.dictionaryDAO.destroy();
                                    if (logger.isTraceEnabled()) {
                                        logger.trace((Object)("afterCommit: Dictionary destroyed [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                    }
                                    return null;
                                }
                            }, (String)tenantSystemUserName2);
                            return null;
                        }
                    };
                    DictionaryModelType.this.transactionService.getRetryingTransactionHelper().doInTransaction(work, true, true);
                }
            }
        }

        public void beforeCommit(boolean readOnly) {
            Set pendingModels;
            if (DictionaryModelType.this.jobLockService != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: " + Thread.currentThread().getName() + " attempt to get transactional lock [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
                try {
                    DictionaryModelType.this.jobLockService.getTransactionalLock(LOCK_QNAME, 60000L, 3000L, 10);
                }
                catch (LockAcquisitionException lae) {
                    throw new ConcurrencyFailureException(lae.getMessage());
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: " + Thread.currentThread().getName() + " got transactional lock [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
            }
            if ((pendingModels = (Set)AlfrescoTransactionSupport.getResource(DictionaryModelType.KEY_PENDING_MODELS)) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("beforeCommit: pendinpolicy-context.xmlgModelsCnt=" + pendingModels.size() + " [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                }
                for (NodeRef pendingNodeRef : pendingModels) {
                    String tenantDomain = DictionaryModelType.this.tenantService.getDomain(pendingNodeRef.getStoreRef().getIdentifier());
                    String tenantSystemUserName = DictionaryModelType.this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
                    final NodeRef nodeRef = DictionaryModelType.this.tenantService.getBaseName(pendingNodeRef);
                    AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        public Object doWork() {
                            if (!DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).exists(nodeRef)) {
                                return null;
                            }
                            isActive = false;
                            value = (Boolean)DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE);
                            if (value != null) {
                                isActive = value;
                            }
                            if (!DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
                                if (isActive) {
                                    contentReader = DictionaryModelTypeTransactionListener.access$700(DictionaryModelTypeTransactionListener.this).getReader(nodeRef, ContentModel.PROP_CONTENT);
                                    if (contentReader != null) {
                                        m2Model = null;
                                        is = null;
                                        try {
                                            is = contentReader.getContentInputStream();
                                            m2Model = M2Model.createModel((InputStream)is);
                                            var7_7 = null;
                                            ** if (is == null) goto lbl-1000
                                        }
                                        catch (Throwable var6_11) {
                                            var7_8 = null;
                                            if (is != null) {
                                                try {
                                                    is.close();
                                                }
                                                catch (IOException e) {
                                                    DictionaryModelType.access$000().error((Object)("Failed to close input stream for " + nodeRef));
                                                }
                                            }
                                            throw var6_11;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException e) {
                                                DictionaryModelType.access$000().error((Object)("Failed to close input stream for " + nodeRef));
                                            }
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                        compiledModel = m2Model.compile(DictionaryModelType.access$200(DictionaryModelType.this), DictionaryModelType.access$800(DictionaryModelType.this));
                                        modelDefinition = compiledModel.getModelDefinition();
                                        props = DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).getProperties(nodeRef);
                                        props.put(ContentModel.PROP_MODEL_NAME, modelDefinition.getName());
                                        props.put(ContentModel.PROP_MODEL_DESCRIPTION, modelDefinition.getDescription());
                                        props.put(ContentModel.PROP_MODEL_AUTHOR, modelDefinition.getAuthor());
                                        props.put(ContentModel.PROP_MODEL_PUBLISHED_DATE, modelDefinition.getPublishedDate());
                                        props.put(ContentModel.PROP_MODEL_VERSION, modelDefinition.getVersion());
                                        DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).setProperties(nodeRef, props);
                                        DictionaryModelType.access$900(DictionaryModelType.this, modelDefinition.getName(), m2Model, compiledModel);
                                        if (DictionaryModelType.access$000().isTraceEnabled()) {
                                            DictionaryModelType.access$000().trace((Object)("beforeCommit: activating nodeRef=" + nodeRef + " (" + modelDefinition.getName() + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                        }
                                    }
                                } else {
                                    modelName = (QName)DictionaryModelTypeTransactionListener.access$600(DictionaryModelTypeTransactionListener.this).getProperty(nodeRef, ContentModel.PROP_MODEL_NAME);
                                    if (modelName != null) {
                                        DictionaryModelType.access$1000(DictionaryModelType.this, modelName);
                                        if (DictionaryModelType.access$000().isTraceEnabled()) {
                                            DictionaryModelType.access$000().trace((Object)("beforeCommit: deactivating nodeRef=" + nodeRef + " (" + modelName + ") [" + AlfrescoTransactionSupport.getTransactionId() + "]"));
                                        }
                                    }
                                }
                            }
                            return null;
                        }
                    }, (String)tenantSystemUserName);
                }
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DictionaryModelTypeTransactionListener) {
                DictionaryModelTypeTransactionListener that = (DictionaryModelTypeTransactionListener)obj;
                return this.id.equals(that.id);
            }
            return false;
        }

        static /* synthetic */ NodeService access$600(DictionaryModelTypeTransactionListener x0) {
            return x0.nodeService;
        }

        static /* synthetic */ ContentService access$700(DictionaryModelTypeTransactionListener x0) {
            return x0.contentService;
        }
    }
}

