/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.types.period;

import java.util.Calendar;
import java.util.Date;
import org.alfresco.repo.dictionary.types.period.AbstractPeriodProvider;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.PeriodProvider;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCalendarPeriodProvider
extends AbstractPeriodProvider {
    private static Log logger = LogFactory.getLog(AbstractCalendarPeriodProvider.class);

    public String getDefaultExpression() {
        return "1";
    }

    public PeriodProvider.ExpressionMutiplicity getExpressionMutiplicity() {
        return PeriodProvider.ExpressionMutiplicity.OPTIONAL;
    }

    public Date getNextDate(Date date, String expression) {
        int value;
        block2: {
            value = 1;
            try {
                value = Integer.parseInt(expression);
            }
            catch (NumberFormatException nfe) {
                value = 1;
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)("\"" + expression + "\" is not a valid period expression!"));
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.add(calendar, value);
        Date next = calendar.getTime();
        return next;
    }

    public abstract void add(Calendar var1, int var2);

    public QName getExpressionDataType() {
        return DataTypeDefinition.INT;
    }
}

