/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import junit.framework.TestCase;
import org.alfresco.repo.domain.avm.AVMStoreDAO;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.springframework.context.ApplicationContext;

public class AVMStoreDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private AVMStoreDAO avmStoreDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.avmStoreDAO = (AVMStoreDAO)this.ctx.getBean("newAvmStoreDAO");
    }

    private AVMStoreEntity get(final String avmStoreName, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<AVMStoreEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<AVMStoreEntity>(){

            @Override
            public AVMStoreEntity execute() throws Throwable {
                AVMStoreEntity avmStoreEntity = null;
                avmStoreEntity = autoCreate ? AVMStoreDAOTest.this.avmStoreDAO.createStore(avmStoreName) : AVMStoreDAOTest.this.avmStoreDAO.getStore(avmStoreName);
                return avmStoreEntity;
            }
        };
        try {
            return this.txnHelper.doInTransaction(callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get avmStore '" + avmStoreName + "'.", e);
            }
            return null;
        }
    }

    public void testCreateWithCommit() throws Exception {
        String avmStore = GUID.generate();
        AVMStoreEntity avmStoreEntity = this.get(avmStore, true, true);
        AVMStoreEntity avmStoreCheck = this.get(avmStoreEntity.getName(), false, true);
        AVMStoreDAOTest.assertEquals((String)"avmStore ID changed", (Object)avmStoreEntity.getId(), (Object)avmStoreCheck.getId());
    }

    public void testCreateWithRollback() throws Exception {
        final String avmStore = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            @Override
            public Pair<Long, String> execute() throws Throwable {
                AVMStoreDAOTest.this.get(avmStore, true, true);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            AVMStoreDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.get(avmStore, false, false);
    }

    public void testCaseInsensitivity() throws Exception {
        String avmStore = "AAA-" + GUID.generate();
        AVMStoreEntity lowercase = this.get(avmStore.toLowerCase(), true, true);
        AVMStoreEntity uppercase = this.get(avmStore.toUpperCase(), false, true);
        AVMStoreDAOTest.assertNotNull((Object)uppercase);
        AVMStoreDAOTest.assertEquals((String)"Upper and lowercase avmStore instance IDs were not the same", (Object)lowercase.getId(), (Object)uppercase.getId());
    }

    public void testDelete() throws Exception {
        String avmStore = GUID.generate();
        AVMStoreEntity avmStoreEntity = this.get(avmStore, true, true);
        this.getAndCheck(avmStoreEntity.getId(), avmStoreEntity);
        this.avmStoreDAO.deleteStore(avmStoreEntity.getId());
        try {
            this.getAndCheck(avmStoreEntity.getId(), avmStoreEntity);
            AVMStoreDAOTest.fail((String)"Entity still exists");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
    }

    private void getAndCheck(final Long avmStoreId, AVMStoreEntity checkAVMStoreEntity) {
        RetryingTransactionHelper.RetryingTransactionCallback<AVMStoreEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<AVMStoreEntity>(){

            @Override
            public AVMStoreEntity execute() throws Throwable {
                AVMStoreEntity storeEntity = AVMStoreDAOTest.this.avmStoreDAO.getStore(avmStoreId);
                return storeEntity;
            }
        };
        AVMStoreEntity result = this.txnHelper.doInTransaction(callback, true, false);
        AVMStoreDAOTest.assertNotNull((String)("Failed to find result for ID " + avmStoreId), (Object)result);
        AVMStoreDAOTest.assertEquals((String)"ContentData retrieved not the same as persisted: ", (Object)checkAVMStoreEntity, (Object)result);
    }
}

