/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.avm.AVMChildEntryEntity;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.avm.AVMMergeLinkEntity;
import org.alfresco.repo.domain.avm.AbstractAVMNodeLinksDAOImpl;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMNodeLinksDAOImpl
extends AbstractAVMNodeLinksDAOImpl {
    private static final String SELECT_AVM_NODE_CHILD_ENTRY = "alfresco.avm.select_AVMChildEntry";
    private static final String SELECT_AVM_NODE_CHILD_ENTRY_L = "alfresco.avm.select_AVMChildEntryL";
    private static final String SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME = "alfresco.avm.select_AVMChildEntryByParentAndName";
    private static final String SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME_L = "alfresco.avm.select_AVMChildEntryByParentAndNameL";
    private static final String SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_CHILD = "alfresco.avm.select_AVMChildEntryByParentAndChild";
    private static final String SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT = "alfresco.avm.select_AVMNodeChildEntriesByParent";
    private static final String SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT_AND_NAME_PATTERN = "alfresco.avm.select_AVMNodeChildEntriesByParentAndNamePattern";
    private static final String SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT_AND_NAME_PATTERN_L = "alfresco.avm.select_AVMNodeChildEntriesByParentAndNamePatternL";
    private static final String SELECT_AVM_NODE_CHILD_ENTRIES_BY_CHILD = "alfresco.avm.select_AVMNodeChildEntriesByChild";
    private static final String INSERT_AVM_NODE_CHILD_ENTRY = "alfresco.avm.insert_AVMChildEntry";
    private static final String UPDATE_AVM_NODE_CHILD_ENTRY = "alfresco.avm.update_AVMChildEntry";
    private static final String DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME = "alfresco.avm.delete_AVMChildEntryByParentAndName";
    private static final String DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME_L = "alfresco.avm.delete_AVMChildEntryByParentAndNameL";
    private static final String DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_CHILD = "alfresco.avm.delete_AVMChildEntryByParentAndChild";
    private static final String DELETE_AVM_NODE_CHILD_ENTRIES_BY_PARENT = "alfresco.avm.delete_AVMNodeChildEntriesByParent";
    private static final String INSERT_AVM_MERGE_LINK = "alfresco.avm.insert_AVMMergeLink";
    private static final String DELETE_AVM_MERGE_LINK = "alfresco.avm.delete_AVMMergeLink";
    private static final String SELECT_AVM_MERGE_LINKS_BY_FROM = "alfresco.avm.select_AVMMergeLinksByFrom";
    private static final String SELECT_AVM_MERGE_LINK_BY_TO = "alfresco.avm.select_AVMMergeLinkByTo";
    private static final String INSERT_AVM_HISTORY_LINK = "alfresco.avm.insert_AVMHistoryLink";
    private static final String DELETE_AVM_HISTORY_LINK = "alfresco.avm.delete_AVMHistoryLink";
    private static final String SELECT_AVM_HISTORY_LINKS_BY_ANCESTOR = "alfresco.avm.select_AVMHistoryLinksByAncestor";
    private static final String SELECT_AVM_HISTORY_LINK_BY_DESCENDENT = "alfresco.avm.select_AVMHistoryLinkByDescendent";
    private static final String SELECT_AVM_HISTORY_LINK = "alfresco.avm.select_AVMHistoryLink";
    private SqlMapClientTemplate template;
    private boolean toLower = true;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    public void setToLower(boolean toLower) {
        this.toLower = toLower;
    }

    @Override
    protected AVMChildEntryEntity getChildEntryEntity(AVMChildEntryEntity childEntryEntity) {
        if (this.toLower) {
            return (AVMChildEntryEntity)this.template.queryForObject(SELECT_AVM_NODE_CHILD_ENTRY_L, (Object)childEntryEntity);
        }
        return (AVMChildEntryEntity)this.template.queryForObject(SELECT_AVM_NODE_CHILD_ENTRY, (Object)childEntryEntity);
    }

    @Override
    protected AVMChildEntryEntity getChildEntryEntity(long parentNodeId, String name) {
        AVMChildEntryEntity childEntryEntity = new AVMChildEntryEntity(parentNodeId, name);
        if (this.toLower) {
            return (AVMChildEntryEntity)this.template.queryForObject(SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME_L, (Object)childEntryEntity);
        }
        return (AVMChildEntryEntity)this.template.queryForObject(SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME, (Object)childEntryEntity);
    }

    @Override
    protected AVMChildEntryEntity getChildEntryEntity(long parentNodeId, long childNodeId) {
        AVMChildEntryEntity childEntryEntity = new AVMChildEntryEntity(parentNodeId, childNodeId);
        return (AVMChildEntryEntity)this.template.queryForObject(SELECT_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_CHILD, (Object)childEntryEntity);
    }

    @Override
    protected List<AVMChildEntryEntity> getChildEntryEntitiesByParent(long parentNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", parentNodeId);
        return this.template.queryForList(SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT, params);
    }

    @Override
    protected List<AVMChildEntryEntity> getChildEntryEntitiesByParent(long parentNodeId, String childNamePattern) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("id", parentNodeId);
        params.put("pattern", childNamePattern);
        if (this.toLower) {
            return this.template.queryForList(SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT_AND_NAME_PATTERN_L, params);
        }
        return this.template.queryForList(SELECT_AVM_NODE_CHILD_ENTRIES_BY_PARENT_AND_NAME_PATTERN, params);
    }

    @Override
    protected List<AVMChildEntryEntity> getChildEntryEntitiesByChild(long childNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", childNodeId);
        return this.template.queryForList(SELECT_AVM_NODE_CHILD_ENTRIES_BY_CHILD, params);
    }

    @Override
    protected void createChildEntryEntity(AVMChildEntryEntity childEntryEntity) {
        this.template.insert(INSERT_AVM_NODE_CHILD_ENTRY, (Object)childEntryEntity);
    }

    @Override
    protected int updateChildEntryEntity(AVMChildEntryEntity childEntryEntity) {
        return this.template.update(UPDATE_AVM_NODE_CHILD_ENTRY, (Object)childEntryEntity);
    }

    @Override
    protected int deleteChildEntryEntity(long parentNodeId, String name) {
        AVMChildEntryEntity childEntryEntity = new AVMChildEntryEntity(parentNodeId, name);
        if (this.toLower) {
            return this.template.delete(DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME_L, (Object)childEntryEntity);
        }
        return this.template.delete(DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_NAME, (Object)childEntryEntity);
    }

    @Override
    protected int deleteChildEntryEntity(long parentNodeId, long childNodeId) {
        AVMChildEntryEntity childEntryEntity = new AVMChildEntryEntity(parentNodeId, childNodeId);
        return this.template.delete(DELETE_AVM_NODE_CHILD_ENTRY_BY_PARENT_AND_CHILD, (Object)childEntryEntity);
    }

    @Override
    protected int deleteChildEntryEntities(long parentNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", parentNodeId);
        return this.template.delete(DELETE_AVM_NODE_CHILD_ENTRIES_BY_PARENT, params);
    }

    @Override
    protected void createMergeLinkEntity(long mergeFromNodeId, long mergeToNodeId) {
        AVMMergeLinkEntity mergeLinkEntity = new AVMMergeLinkEntity(mergeFromNodeId, mergeToNodeId);
        this.template.insert(INSERT_AVM_MERGE_LINK, (Object)mergeLinkEntity);
    }

    @Override
    protected int deleteMergeLinkEntity(long mergeFromNodeId, long mergeToNodeId) {
        AVMMergeLinkEntity mLinkEntity = new AVMMergeLinkEntity(mergeFromNodeId, mergeToNodeId);
        return this.template.delete(DELETE_AVM_MERGE_LINK, (Object)mLinkEntity);
    }

    @Override
    protected AVMMergeLinkEntity getMergeLinkEntityByTo(long mergeToNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", mergeToNodeId);
        return (AVMMergeLinkEntity)this.template.queryForObject(SELECT_AVM_MERGE_LINK_BY_TO, params);
    }

    @Override
    protected List<AVMMergeLinkEntity> getMergeLinkEntitiesByFrom(long mergeFromNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", mergeFromNodeId);
        return this.template.queryForList(SELECT_AVM_MERGE_LINKS_BY_FROM, params);
    }

    @Override
    protected void createHistoryLinkEntity(long ancestorNodeId, long mergeToNodeId) {
        AVMHistoryLinkEntity hLinkEntity = new AVMHistoryLinkEntity(ancestorNodeId, mergeToNodeId);
        this.template.insert(INSERT_AVM_HISTORY_LINK, (Object)hLinkEntity);
    }

    @Override
    protected int deleteHistoryLinkEntity(long ancestorNodeId, long descendentNodeId) {
        AVMHistoryLinkEntity hLinkEntity = new AVMHistoryLinkEntity(ancestorNodeId, descendentNodeId);
        return this.template.delete(DELETE_AVM_HISTORY_LINK, (Object)hLinkEntity);
    }

    @Override
    protected AVMHistoryLinkEntity getHistoryLinkEntityByDescendent(long descendentNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", descendentNodeId);
        return (AVMHistoryLinkEntity)this.template.queryForObject(SELECT_AVM_HISTORY_LINK_BY_DESCENDENT, params);
    }

    @Override
    protected AVMHistoryLinkEntity getHistoryLinkEntity(long ancestorNodeId, long descendentNodeId) {
        AVMHistoryLinkEntity hLinkEntity = new AVMHistoryLinkEntity(ancestorNodeId, descendentNodeId);
        return (AVMHistoryLinkEntity)this.template.queryForObject(SELECT_AVM_HISTORY_LINK, (Object)hLinkEntity);
    }

    @Override
    protected List<AVMHistoryLinkEntity> getHistoryLinkEntitiesByAncestor(long ancestorNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", ancestorNodeId);
        return this.template.queryForList(SELECT_AVM_HISTORY_LINKS_BY_ANCESTOR, params);
    }
}

