/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.domain.avm.AVMVersionLayeredNodeEntryEntity;
import org.alfresco.repo.domain.avm.AVMVersionRootEntity;
import org.alfresco.repo.domain.avm.AbstractAVMVersionRootDAOImpl;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMVersionRootDAOImpl
extends AbstractAVMVersionRootDAOImpl {
    private static final String INSERT_AVM_VERSION_ROOT = "alfresco.avm.insert_AVMVersionRoot";
    private static final String DELETE_AVM_VERSION_ROOT = "alfresco.avm.delete_AVMVersionRoot";
    private static final String UPDATE_AVM_VERSION_ROOT = "alfresco.avm.update_AVMVersionRoot";
    private static final String SELECT_AVM_VERSION_ROOT_MAX_VERSION = "alfresco.avm.select_AVMVersionRootMaxVersion";
    private static final String SELECT_AVM_VERSION_ROOT_MAX_VERSION_ID = "alfresco.avm.select_AVMVersionRootMaxVersionID";
    private static final String SELECT_AVM_VERSION_ROOT_BY_ID = "alfresco.avm.select_AVMVersionRootById";
    private static final String SELECT_AVM_VERSION_ROOT_BY_STORE_VERSION = "alfresco.avm.select_AVMVersionRootByStoreVersion";
    private static final String SELECT_AVM_VERSION_ROOT_BY_ROOT_NODE_ID = "alfresco.avm.select_AVMVersionRootByRootNodeId";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_STORE_ID = "alfresco.avm.select_AVMVersionRootsByStoreId";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_DATE_TO = "alfresco.avm.select_AVMVersionRootsByTo";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_DATE_FROM = "alfresco.avm.select_AVMVersionRootsByFrom";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_DATES_BETWEEN = "alfresco.avm.select_AVMVersionRootsBetween";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_VERSION_TO = "alfresco.avm.select_AVMVersionRootsByVersionTo";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_VERSION_FROM = "alfresco.avm.select_AVMVersionRootsByVersionFrom";
    private static final String SELECT_AVM_VERSION_ROOTS_BY_VERSIONS_BETWEEN = "alfresco.avm.select_AVMVersionRootsByVersionsBetween";
    private static final String INSERT_AVM_VERSION_LAYERED_NODE_ENTRY = "alfresco.avm.insert_AVMVersionLayeredNodeEntry";
    private static final String DELETE_AVM_VERSION_LAYERED_NODE_ENTRIES = "alfresco.avm.delete_AVMVersionLayeredNodeEntries";
    private static final String SELECT_AVM_VERSION_LAYERED_NODE_ENTRIES = "alfresco.avm.select_AVMVersionLayeredNodeEntries";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    @Override
    protected AVMVersionRootEntity createVersionRootEntity(AVMVersionRootEntity newVersionRootEntity) {
        Long id = (Long)this.template.insert(INSERT_AVM_VERSION_ROOT, (Object)newVersionRootEntity);
        newVersionRootEntity.setId(id);
        return newVersionRootEntity;
    }

    @Override
    protected void updateVersionRootEntity(AVMVersionRootEntity updateVersionRootEntity) {
        this.template.update(UPDATE_AVM_VERSION_ROOT, (Object)updateVersionRootEntity, 1);
    }

    @Override
    protected AVMVersionRootEntity getVersionRootEntityMaxVersion(long storeId) {
        AVMStoreEntity storeEntity = new AVMStoreEntity();
        storeEntity.setId(storeId);
        return (AVMVersionRootEntity)this.template.queryForObject(SELECT_AVM_VERSION_ROOT_MAX_VERSION, (Object)storeEntity);
    }

    @Override
    protected Long getVersionRootEntityMaxVersionId(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        Integer maxVersionId = (Integer)this.template.queryForObject(SELECT_AVM_VERSION_ROOT_MAX_VERSION_ID, params);
        if (maxVersionId == null) {
            return null;
        }
        return new Long(maxVersionId.intValue());
    }

    @Override
    protected AVMVersionRootEntity getVersionRootEntityById(long vrEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", vrEntityId);
        return (AVMVersionRootEntity)this.template.queryForObject(SELECT_AVM_VERSION_ROOT_BY_ID, params);
    }

    @Override
    protected AVMVersionRootEntity getVersionRootEntityByStoreVersion(long storeId, int version) {
        AVMVersionRootEntity vrEntity = new AVMVersionRootEntity();
        vrEntity.setStoreId(storeId);
        vrEntity.setVersion(version);
        return (AVMVersionRootEntity)this.template.queryForObject(SELECT_AVM_VERSION_ROOT_BY_STORE_VERSION, (Object)vrEntity);
    }

    @Override
    protected AVMVersionRootEntity getVersionRootEntityByRootNodeId(long rootNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", rootNodeId);
        return (AVMVersionRootEntity)this.template.queryForObject(SELECT_AVM_VERSION_ROOT_BY_ROOT_NODE_ID, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getAllVersionRootEntitiesByStoreId(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_STORE_ID, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByTo(long storeId, long to) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("id", storeId);
        params.put("to", to);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_DATE_TO, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByFrom(long storeId, long from) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("id", storeId);
        params.put("from", from);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_DATE_FROM, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByBetween(long storeId, long from, long to) {
        HashMap<String, Long> params = new HashMap<String, Long>(3);
        params.put("id", storeId);
        params.put("from", from);
        params.put("to", to);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_DATES_BETWEEN, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsBetween(long storeId, long from, long to) {
        HashMap<String, Long> params = new HashMap<String, Long>(3);
        params.put("id", storeId);
        params.put("from", from);
        params.put("to", to);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_VERSIONS_BETWEEN, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsFrom(long storeId, long from) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("id", storeId);
        params.put("from", from);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_VERSION_FROM, params);
    }

    @Override
    protected List<AVMVersionRootEntity> getVersionRootEntitiesByVersionsTo(long storeId, long to) {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("id", storeId);
        params.put("to", to);
        return this.template.queryForList(SELECT_AVM_VERSION_ROOTS_BY_VERSION_TO, params);
    }

    @Override
    protected int deleteVersionRootEntity(long vrEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", vrEntityId);
        return this.template.delete(DELETE_AVM_VERSION_ROOT, params);
    }

    @Override
    protected AVMVersionLayeredNodeEntryEntity createVersionLayeredNodeEntryEntity(long versionRootId, String md5sum, String path) {
        AVMVersionLayeredNodeEntryEntity vlneEntity = new AVMVersionLayeredNodeEntryEntity();
        vlneEntity.setVersionRootId(versionRootId);
        vlneEntity.setMd5sum(md5sum);
        vlneEntity.setPath(path);
        this.template.insert(INSERT_AVM_VERSION_LAYERED_NODE_ENTRY, (Object)vlneEntity);
        return vlneEntity;
    }

    @Override
    protected int deleteVersionLayeredNodeEntryEntities(long versionRootId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", versionRootId);
        return this.template.delete(DELETE_AVM_VERSION_LAYERED_NODE_ENTRIES, params);
    }

    @Override
    protected List<AVMVersionLayeredNodeEntryEntity> getVersionLayeredNodeEntryEntities(long versionRootId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", versionRootId);
        return this.template.queryForList(SELECT_AVM_VERSION_LAYERED_NODE_ENTRIES, params);
    }
}

