/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.patch;

import java.util.Date;
import junit.framework.TestCase;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.domain.patch.AppliedPatchEntity;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class AppliedPatchDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private AppliedPatchDAO appliedPatchDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.appliedPatchDAO = (AppliedPatchDAO)this.ctx.getBean("appliedPatchDAO");
    }

    private AppliedPatch create(String id, boolean allNull) throws Exception {
        final AppliedPatchEntity appliedPatch = new AppliedPatchEntity();
        appliedPatch.setId(id);
        if (!allNull) {
            appliedPatch.setDescription(id);
            appliedPatch.setFixesFromSchema(0);
            appliedPatch.setFixesToSchema(1);
            appliedPatch.setTargetSchema(2);
            appliedPatch.setAppliedOnDate(new Date());
            appliedPatch.setAppliedToSchema(1);
            appliedPatch.setAppliedToServer("blah");
            appliedPatch.setWasExecuted(true);
            appliedPatch.setSucceeded(true);
            appliedPatch.setReport("All good in test " + this.getName());
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AppliedPatchDAOTest.this.appliedPatchDAO.createAppliedPatch(appliedPatch);
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback);
        return appliedPatch;
    }

    private AppliedPatch get(final String id) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<AppliedPatch> callback = new RetryingTransactionHelper.RetryingTransactionCallback<AppliedPatch>(){

            @Override
            public AppliedPatch execute() throws Throwable {
                return AppliedPatchDAOTest.this.appliedPatchDAO.getAppliedPatch(id);
            }
        };
        return this.txnHelper.doInTransaction(callback);
    }

    public void testCreateEmpty() throws Exception {
        String id = this.getName() + "-" + System.currentTimeMillis();
        this.create(id, true);
    }

    public void testCreatePopulated() throws Exception {
        String id = this.getName() + "-" + System.currentTimeMillis();
        this.create(id, false);
    }

    public void testCreateWithRollback() throws Exception {
        final String id = this.getName() + "-" + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AppliedPatchDAOTest.this.create(id, false);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction(callback);
            AppliedPatchDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.get(id);
    }
}

