/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyClassEntity {
    private Long id;
    private Class<?> javaClass;
    private String javaClassName;
    private String javaClassNameShort;
    private long javaClassNameCrc;

    public int hashCode() {
        return this.javaClass == null ? 0 : this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyClassEntity) {
            PropertyClassEntity that = (PropertyClassEntity)obj;
            return EqualsHelper.nullSafeEquals(this.javaClass, that.javaClass);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("PropertyClassEntity").append("[ ID=").append(this.id).append(", javaClass=").append(this.javaClass).append("]");
        return sb.toString();
    }

    public Pair<Long, Class<?>> getEntityPair() {
        return new Pair((Object)this.id, this.getJavaClass());
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null && this.javaClassName != null) {
            try {
                this.javaClass = Class.forName(this.javaClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AlfrescoRuntimeException("Property class '" + this.javaClassName + "' is not available to the VM");
            }
        }
        return this.javaClass;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setJavaClass(Class<?> javaClass) {
        this.javaClass = javaClass;
        this.javaClassName = javaClass.getName();
        Pair<String, Long> crcPair = CrcHelper.getStringCrcPair(this.javaClassName, 32, true, true);
        this.javaClassNameShort = (String)crcPair.getFirst();
        this.javaClassNameCrc = (Long)crcPair.getSecond();
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public String getJavaClassNameShort() {
        return this.javaClassNameShort;
    }

    public void setJavaClassNameShort(String javaClassNameShort) {
        this.javaClassNameShort = javaClassNameShort;
    }

    public long getJavaClassNameCrc() {
        return this.javaClassNameCrc;
    }

    public void setJavaClassNameCrc(long javaClassNameCrc) {
        this.javaClassNameCrc = javaClassNameCrc;
    }
}

