/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.processor.node.ContentModelField;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.QNameFieldProcessor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationFieldProcessor
extends QNameFieldProcessor<AssociationDefinition> {
    private static final Log logger = LogFactory.getLog(AssociationFieldProcessor.class);

    public AssociationFieldProcessor() {
    }

    public AssociationFieldProcessor(NamespaceService namespaceService, DictionaryService dictionaryService) {
        super(namespaceService, dictionaryService);
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected FieldGroup getGroup(AssociationDefinition assocDef) {
        return null;
    }

    @Override
    public Field makeField(AssociationDefinition assocDef, Object value, FieldGroup group) {
        AssociationFieldDefinition fieldDef = this.makeAssociationFieldDefinition(assocDef, group);
        return new ContentModelField(assocDef, fieldDef, value);
    }

    @Override
    protected Object getValue(QName name, ContentModelItemData<?> data) {
        Serializable values = data.getAssociationValue(name);
        if (values == null) {
            return Collections.emptyList();
        }
        if (values instanceof Collection) {
            return this.getValues((Collection)((Object)values));
        }
        return Collections.singletonList(values.toString());
    }

    private List<String> getValues(Collection<?> collection) {
        ArrayList<String> results = new ArrayList<String>(collection.size());
        for (Object value : collection) {
            results.add(value.toString());
        }
        return results;
    }

    public AssociationFieldDefinition makeAssociationFieldDefinition(AssociationDefinition assocDef, FieldGroup group) {
        String name = this.getPrefixedName((ClassAttributeDefinition)assocDef);
        String endpointType = assocDef.getTargetClass().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
        AssociationFieldDefinition fieldDef = new AssociationFieldDefinition(name, endpointType, AssociationFieldDefinition.Direction.TARGET);
        this.populateFieldDefinition(assocDef, fieldDef, group, "assoc_");
        fieldDef.setEndpointMandatory(assocDef.isTargetMandatory());
        fieldDef.setEndpointMany(assocDef.isTargetMany());
        return fieldDef;
    }

    @Override
    protected String getRegistryKey() {
        return "assoc";
    }

    @Override
    protected AssociationDefinition getTypeDefinition(QName fullName, ContentModelItemData<?> itemData, boolean isForcedField) {
        AssociationDefinition assocDefinition = itemData.getAssociationDefinition(fullName);
        if (assocDefinition == null && isForcedField) {
            assocDefinition = this.dictionaryService.getAssociation(fullName);
        }
        return assocDefinition;
    }
}

