/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.forms.DataTypeParameters;
import org.alfresco.service.cmr.repository.PeriodProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PeriodDataTypeParameters
implements DataTypeParameters,
Serializable {
    private static final long serialVersionUID = -3654041242831123509L;
    protected List<PeriodProvider> providers = new ArrayList<PeriodProvider>(8);

    public void addPeriodProvider(PeriodProvider pp) {
        if (pp.getPeriodType() != "duration" && pp.getPeriodType() != "cron") {
            this.providers.add(pp);
        }
    }

    public Object getAsObject() {
        return this.providers;
    }

    public Object getAsJSON() {
        JSONArray periods = new JSONArray();
        try {
            for (PeriodProvider pp : this.providers) {
                boolean hasExpression = !pp.getExpressionMutiplicity().equals((Object)PeriodProvider.ExpressionMutiplicity.NONE);
                JSONObject period = new JSONObject();
                period.put("type", (Object)pp.getPeriodType());
                period.put("label", (Object)pp.getDisplayLabel());
                period.put("hasExpression", hasExpression);
                if (hasExpression) {
                    period.put("expressionMandatory", pp.getExpressionMutiplicity().equals((Object)PeriodProvider.ExpressionMutiplicity.MANDATORY));
                    period.put("expressionType", (Object)pp.getExpressionDataType().toPrefixString());
                    period.put("defaultExpression", (Object)pp.getDefaultExpression());
                }
                periods.put((Object)period);
            }
        }
        catch (JSONException je) {
            periods = new JSONArray();
        }
        return periods;
    }
}

