/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.imap.AbstractMimeMessage;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.namespace.QName;

public class ContentModelMessage
extends AbstractMimeMessage {
    public ContentModelMessage(FileInfo fileInfo, ServiceRegistry serviceRegistry, boolean generateBody) throws MessagingException {
        super(fileInfo, serviceRegistry, generateBody);
    }

    public void buildMessageInternal() throws MessagingException {
        if (this.generateBody) {
            this.setMessageHeaders();
            this.buildContentModelMessage();
        }
    }

    private void buildContentModelMessage() throws MessagingException {
        Map<QName, Serializable> properties = this.messageFileInfo.getProperties();
        String prop = null;
        this.setSentDate(this.messageFileInfo.getModifiedDate());
        InternetAddress[] addressList = this.buildSenderFromAddress();
        this.addFrom((Address[])addressList);
        addressList = this.buildRecipientToAddress();
        this.addRecipients(MimeMessage.RecipientType.TO, (Address[])addressList);
        prop = (String)((Object)properties.get(ContentModel.PROP_TITLE));
        try {
            prop = prop == null || prop.equals("") ? this.messageFileInfo.getName() : prop;
            prop = MimeUtility.encodeText((String)prop, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.setSubject(prop);
        this.setContent(this.buildContentModelMultipart());
    }

    private Multipart buildContentModelMultipart() throws MessagingException {
        AlfrescoMimeMultipart rootMultipart = new AlfrescoMimeMultipart("alternative", this.messageFileInfo);
        String bodyTxt = this.getEmailBodyText(ImapService.EmailBodyType.TEXT_PLAIN);
        rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyTxt, ImapService.EmailBodyType.TEXT_PLAIN.getSubtype(), ImapService.EmailBodyType.TEXT_PLAIN.getMimeType()));
        String bodyHtml = this.getEmailBodyText(ImapService.EmailBodyType.TEXT_HTML);
        rootMultipart.addBodyPart((BodyPart)this.getTextBodyPart(bodyHtml, ImapService.EmailBodyType.TEXT_HTML.getSubtype(), ImapService.EmailBodyType.TEXT_HTML.getMimeType()));
        return rootMultipart;
    }

    private MimeBodyPart getTextBodyPart(String bodyText, String subtype, String mimeType) throws MessagingException {
        MimeBodyPart result = new MimeBodyPart();
        result.setText(bodyText, "UTF-8", subtype);
        result.addHeader("Content-Type", mimeType + ";charset=utf-8");
        result.addHeader("Content-Transfer-Encoding", "base64");
        return result;
    }

    class AlfrescoMimeMultipart
    extends MimeMultipart {
        public AlfrescoMimeMultipart(String subtype, FileInfo messageFileInfo) {
            String boundary = this.getBoundaryValue(messageFileInfo);
            ContentType cType = new ContentType("multipart", subtype, null);
            cType.setParameter("boundary", boundary);
            this.contentType = cType.toString();
        }

        public String getBoundaryValue(FileInfo messageFileInfo) {
            StringBuffer s = new StringBuffer();
            s.append("----=_Part_").append(messageFileInfo.getNodeRef().getId());
            return s.toString();
        }
    }
}

