/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import org.alfresco.repo.importer.ImportContentHandler;
import org.alfresco.repo.importer.Importer;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultContentHandler
implements ImportContentHandler,
ErrorHandler {
    private ImportContentHandler targetHandler = null;
    private Importer importer = null;

    public DefaultContentHandler(ImportContentHandler targetHandler) {
        ParameterCheck.mandatory((String)"targetHandler", (Object)targetHandler);
        this.targetHandler = targetHandler;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
        this.targetHandler.setImporter(importer);
    }

    public InputStream importStream(String content) {
        return this.targetHandler.importStream(content);
    }

    public void setDocumentLocator(Locator locator) {
        this.targetHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.importer.start();
        this.targetHandler.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        try {
            this.targetHandler.endDocument();
            Object var2_1 = null;
            this.importer.end();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.importer.end();
            throw throwable;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.targetHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.targetHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.targetHandler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.targetHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.targetHandler.skippedEntity(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(SAXParseException exception) throws SAXException {
        try {
            this.targetHandler.error(exception);
            Object var3_2 = null;
            this.importer.error(exception);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.importer.error(exception);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatalError(SAXParseException exception) throws SAXException {
        try {
            this.targetHandler.error(exception);
            Object var3_2 = null;
            this.importer.error(exception);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.importer.error(exception);
            throw throwable;
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.targetHandler.warning(exception);
    }
}

