/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.invitation.InvitationImpl;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.ModeratedInvitationImpl;
import org.alfresco.repo.invitation.NominatedInvitationImpl;
import org.alfresco.repo.invitation.WorkflowModelModeratedInvitation;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.PasswordGenerator;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionNotFound;
import org.alfresco.service.cmr.invitation.InvitationExceptionUserError;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvitationServiceImpl
implements InvitationService,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final Log logger = LogFactory.getLog(InvitationServiceImpl.class);
    private WorkflowService workflowService;
    private PersonService personService;
    private SiteService siteService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private UserNameGenerator usernameGenerator;
    private PasswordGenerator passwordGenerator;
    private PolicyComponent policyComponent;
    public static final int MAX_NUM_INVITEE_USER_NAME_GEN_TRIES = 10;
    private int maxUserNameGenRetries = 10;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"WorkflowService", (Object)this.workflowService);
        PropertyCheck.mandatory((Object)this, (String)"PersonService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"SiteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"AuthenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"PermissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"NamespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"NodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"UserNameGenerator", (Object)this.usernameGenerator);
        PropertyCheck.mandatory((Object)this, (String)"PasswordGenerator", (Object)this.passwordGenerator);
        PropertyCheck.mandatory((Object)this, (String)"PolicyComponent", (Object)this.policyComponent);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    @Override
    public List<String> getInvitationServiceWorkflowNames() {
        ArrayList<String> ret = new ArrayList<String>(3);
        ret.add("jbpm$inwf:invitation-nominated");
        ret.add("jbpm$imwf:invitation-moderated");
        ret.add("jbpm$wf:invite");
        return ret;
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        NodeRef person = this.personService.getPerson(inviteeUserName);
        Serializable firstNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_FIRSTNAME);
        Serializable lastNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_LASTNAME);
        Serializable emailVal = this.getNodeService().getProperty(person, ContentModel.PROP_EMAIL);
        String firstName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
        String lastName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
        String email = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)emailVal);
        return this.inviteNominated(firstName, lastName, email, inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    @Override
    public NominatedInvitation inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        return this.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, null, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
    }

    private NominatedInvitation inviteNominated(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole, String serverPath, String acceptUrl, String rejectUrl) {
        if (resourceType == Invitation.ResourceType.WEB_SITE) {
            return this.startNominatedInvite(inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        }
        throw new InvitationException("unknown resource type", new Object[0]);
    }

    @Override
    public ModeratedInvitation inviteModerated(String inviteeComments, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole) {
        if (resourceType == Invitation.ResourceType.WEB_SITE) {
            return this.startModeratedInvite(inviteeComments, inviteeUserName, resourceType, resourceName, inviteeRole);
        }
        throw new InvitationException("unknown resource type", new Object[0]);
    }

    @Override
    public Invitation accept(String invitationId, String ticket) {
        Invitation invitation = this.getInvitation(invitationId);
        if (invitation instanceof NominatedInvitation) {
            if (ticket == null || !ticket.equals(((NominatedInvitation)invitation).getTicket())) {
                throw new InvitationException("Response to invite has supplied an invalid ticket. The response to the invitation could thus not be processed", new Object[0]);
            }
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            wfTaskQuery.setProcessId(invitationId);
            wfTaskQuery.setActive(Boolean.TRUE);
            wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING);
            wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
            List<WorkflowTask> wf_invite_tasks = this.workflowService.queryTasks(wfTaskQuery);
            if (wf_invite_tasks.size() == 0) {
                Object[] objs = new Object[]{invitationId};
                throw new InvitationExceptionUserError("invitation.invite.already_finished", objs);
            }
            for (WorkflowTask workflowTask : wf_invite_tasks) {
                this.workflowService.endTask(workflowTask.id, "accept");
            }
            return invitation;
        }
        throw new InvitationException("State error, cannot call accept a moderated invitation", new Object[0]);
    }

    @Override
    public Invitation approve(String invitationId, String reason) {
        Invitation invitation = this.getInvitation(invitationId);
        if (invitation instanceof ModeratedInvitation) {
            String approverUserName = this.authenticationService.getCurrentUserName();
            this.checkManagerRole(approverUserName, invitation.getResourceType(), invitation.getResourceName());
            WorkflowTaskQuery wfModeratedTaskQuery = new WorkflowTaskQuery();
            wfModeratedTaskQuery.setActive(Boolean.TRUE);
            wfModeratedTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfModeratedTaskQuery.setTaskName(WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
            wfModeratedTaskQuery.setProcessName(WorkflowModelModeratedInvitation.WF_PROCESS_INVITATION_MODERATED);
            wfModeratedTaskQuery.setProcessId(invitationId);
            List<WorkflowTask> wf_moderated_tasks = this.workflowService.queryTasks(wfModeratedTaskQuery);
            for (WorkflowTask workflowTask : wf_moderated_tasks) {
                HashMap<QName, Serializable> wfReviewProps = new HashMap<QName, Serializable>();
                wfReviewProps.put(ContentModel.PROP_OWNER, (Serializable)((Object)approverUserName));
                wfReviewProps.put(WorkflowModelModeratedInvitation.WF_PROP_REVIEW_COMMENTS, (Serializable)((Object)reason));
                this.workflowService.updateTask(workflowTask.id, wfReviewProps, null, null);
                this.workflowService.endTask(workflowTask.id, "approve");
            }
        } else {
            throw new InvitationException("State error, cannot call approve on this type of invitation" + invitation.getClass().getName(), new Object[0]);
        }
        return invitation;
    }

    @Override
    public Invitation reject(String invitationId, String reason) {
        Invitation invitation = this.getInvitation(invitationId);
        if (invitation instanceof NominatedInvitation) {
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            wfTaskQuery.setProcessId(invitationId);
            wfTaskQuery.setActive(Boolean.TRUE);
            wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING);
            wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
            List<WorkflowTask> wf_invite_tasks = this.workflowService.queryTasks(wfTaskQuery);
            if (wf_invite_tasks.size() == 0) {
                Object[] objs = new Object[]{invitationId};
                throw new InvitationExceptionUserError("invitation.invite.already_finished", objs);
            }
            for (WorkflowTask workflowTask : wf_invite_tasks) {
                this.workflowService.endTask(workflowTask.id, "reject");
            }
            return invitation;
        }
        if (invitation instanceof ModeratedInvitation) {
            WorkflowTaskQuery wfModeratedTaskQuery = new WorkflowTaskQuery();
            String rejecterUserName = this.authenticationService.getCurrentUserName();
            this.checkManagerRole(rejecterUserName, invitation.getResourceType(), invitation.getResourceName());
            wfModeratedTaskQuery.setActive(Boolean.TRUE);
            wfModeratedTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfModeratedTaskQuery.setTaskName(WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
            wfModeratedTaskQuery.setProcessName(WorkflowModelModeratedInvitation.WF_PROCESS_INVITATION_MODERATED);
            wfModeratedTaskQuery.setProcessId(invitationId);
            List<WorkflowTask> wf_moderated_tasks = this.workflowService.queryTasks(wfModeratedTaskQuery);
            for (WorkflowTask workflowTask : wf_moderated_tasks) {
                HashMap<QName, Serializable> wfReviewProps = new HashMap<QName, Serializable>();
                wfReviewProps.put(ContentModel.PROP_OWNER, (Serializable)((Object)rejecterUserName));
                wfReviewProps.put(WorkflowModelModeratedInvitation.WF_PROP_REVIEW_COMMENTS, (Serializable)((Object)reason));
                this.workflowService.updateTask(workflowTask.id, wfReviewProps, null, null);
                this.workflowService.endTask(workflowTask.id, "reject");
            }
            return invitation;
        }
        return invitation;
    }

    @Override
    public Invitation cancel(String invitationId) {
        Invitation invitation = this.getInvitation(invitationId);
        if (invitation instanceof NominatedInvitation) {
            String approverUserName = this.authenticationService.getCurrentUserName();
            this.checkManagerRole(approverUserName, invitation.getResourceType(), invitation.getResourceName());
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            wfTaskQuery.setProcessId(invitationId);
            wfTaskQuery.setActive(Boolean.TRUE);
            wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING);
            wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
            List<WorkflowTask> wf_invite_tasks = this.workflowService.queryTasks(wfTaskQuery);
            for (WorkflowTask workflowTask : wf_invite_tasks) {
                this.workflowService.endTask(workflowTask.id, "cancel");
            }
        }
        if (invitation instanceof ModeratedInvitation) {
            String currentUserName = this.authenticationService.getCurrentUserName();
            if (!currentUserName.equals(((ModeratedInvitation)invitation).getInviteeUserName())) {
                this.checkManagerRole(currentUserName, invitation.getResourceType(), invitation.getResourceName());
            }
            this.workflowService.cancelWorkflow(invitationId);
        }
        return invitation;
    }

    @Override
    public Invitation getInvitation(String invitationId) {
        this.validateInvitationId(invitationId);
        WorkflowInstance wi = null;
        try {
            wi = this.workflowService.getWorkflowById(invitationId);
        }
        catch (WorkflowException we) {
            // empty catch block
        }
        if (wi == null) {
            Object[] objs = new Object[]{invitationId};
            throw new InvitationExceptionNotFound("invitation.error.not_found", objs);
        }
        String workflowName = wi.definition.getName();
        if (workflowName.equals("jbpm$inwf:invitation-nominated")) {
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            wfTaskQuery.setProcessId(invitationId);
            wfTaskQuery.setTaskState(WorkflowTaskState.COMPLETED);
            wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_TO_SITE);
            List<WorkflowTask> inviteStartTasks = this.workflowService.queryTasks(wfTaskQuery);
            if (inviteStartTasks.size() < 1) {
                Object[] objs = new Object[]{invitationId};
                throw new InvitationExceptionNotFound("invitation.error.not_found", objs);
            }
            WorkflowTask task = inviteStartTasks.get(0);
            NominatedInvitationImpl result = new NominatedInvitationImpl(task.properties);
            result.setSentInviteDate(task.path.instance.startDate);
            result.setInviteId(invitationId);
            return result;
        }
        if (workflowName.equals("jbpm$imwf:invitation-moderated")) {
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            wfTaskQuery.setProcessId(invitationId);
            wfTaskQuery.setTaskState(WorkflowTaskState.COMPLETED);
            wfTaskQuery.setTaskName(WorkflowModelModeratedInvitation.WF_START_TASK);
            List<WorkflowTask> inviteStartTasks = this.workflowService.queryTasks(wfTaskQuery);
            if (inviteStartTasks.size() < 1) {
                Object[] objs = new Object[]{invitationId};
                throw new InvitationExceptionNotFound("invitation.error.not_found", objs);
            }
            WorkflowTask task = inviteStartTasks.get(0);
            ModeratedInvitationImpl result = new ModeratedInvitationImpl(task.properties);
            result.setInviteId(invitationId);
            return result;
        }
        return null;
    }

    @Override
    public List<Invitation> listPendingInvitationsForInvitee(String invitee) {
        InvitationSearchCriteriaImpl crit = new InvitationSearchCriteriaImpl();
        crit.setInvitationType(InvitationSearchCriteria.InvitationType.ALL);
        crit.setInvitee(invitee);
        return this.searchInvitation(crit);
    }

    @Override
    public List<Invitation> listPendingInvitationsForResource(Invitation.ResourceType resourceType, String resourceName) {
        InvitationSearchCriteriaImpl crit = new InvitationSearchCriteriaImpl();
        crit.setInvitationType(InvitationSearchCriteria.InvitationType.ALL);
        crit.setResourceType(resourceType);
        crit.setResourceName(resourceName);
        return this.searchInvitation(crit);
    }

    @Override
    public List<Invitation> searchInvitation(InvitationSearchCriteria criteria) {
        Object val2;
        Object val1;
        boolean crap;
        Set<QName> keys;
        Invitation result;
        String workflowId;
        ArrayList<Invitation> ret = new ArrayList<Invitation>();
        InvitationSearchCriteria.InvitationType toSearch = criteria.getInvitationType();
        if (toSearch == InvitationSearchCriteria.InvitationType.ALL || toSearch == InvitationSearchCriteria.InvitationType.NOMINATED) {
            WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
            HashMap<QName, Object> wfNominatedQueryProps = new HashMap<QName, Object>(10, 1.0f);
            if (criteria.getInviter() != null) {
                wfNominatedQueryProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME, criteria.getInviter());
            }
            if (criteria.getInvitee() != null) {
                wfNominatedQueryProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME, criteria.getInvitee());
            }
            if (criteria.getResourceType() != null) {
                wfNominatedQueryProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TYPE, criteria.getResourceType().toString());
            }
            if (criteria.getResourceName() != null) {
                wfNominatedQueryProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME, criteria.getResourceName());
            }
            wfTaskQuery.setProcessCustomProps(wfNominatedQueryProps);
            wfTaskQuery.setActive(Boolean.TRUE);
            wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING);
            wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
            List<WorkflowTask> wf_invite_tasks = this.workflowService.queryTasks(wfTaskQuery);
            for (WorkflowTask workflowTask : wf_invite_tasks) {
                workflowId = workflowTask.path.instance.id;
                result = this.getInvitation(workflowId);
                keys = wfNominatedQueryProps.keySet();
                crap = false;
                for (QName key : keys) {
                    if (key.equals((Object)WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME) && !(val1 = wfNominatedQueryProps.get(key)).equals(val2 = ((NominatedInvitation)result).getInviteeUserName())) {
                        crap = true;
                        logger.debug((Object)("ALFCOM-2598 key:" + key + "query:" + val1 + "task:" + val2));
                        break;
                    }
                    if (key.equals((Object)WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME) && !(val1 = wfNominatedQueryProps.get(key)).equals(val2 = result.getResourceName())) {
                        crap = true;
                        logger.debug((Object)("ALFCOM-2598 key:" + key + "query:" + val1 + "task:" + val2));
                        break;
                    }
                    if (!key.equals((Object)WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TYPE) || (val1 = wfNominatedQueryProps.get(key)).equals(val2 = result.getResourceType().toString())) continue;
                    crap = true;
                    logger.debug((Object)("ALFCOM-2598 key:" + key + "query:" + val1 + "task:" + val2));
                    break;
                }
                if (crap) continue;
                ret.add(result);
            }
        }
        if (toSearch == InvitationSearchCriteria.InvitationType.ALL || toSearch == InvitationSearchCriteria.InvitationType.MODERATED) {
            WorkflowTaskQuery wfModeratedTaskQuery = new WorkflowTaskQuery();
            HashMap<QName, Object> wfQueryModeratedProps = new HashMap<QName, Object>(3, 1.0f);
            if (criteria.getInvitee() != null) {
                wfQueryModeratedProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_USER_NAME, criteria.getInvitee());
            }
            if (criteria.getResourceType() != null) {
                wfQueryModeratedProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_TYPE, criteria.getResourceType().toString());
            }
            if (criteria.getResourceName() != null) {
                wfQueryModeratedProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_NAME, criteria.getResourceName());
            }
            wfModeratedTaskQuery.setProcessCustomProps(wfQueryModeratedProps);
            wfModeratedTaskQuery.setActive(Boolean.TRUE);
            wfModeratedTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
            wfModeratedTaskQuery.setTaskName(WorkflowModelModeratedInvitation.WF_REVIEW_TASK);
            wfModeratedTaskQuery.setProcessName(WorkflowModelModeratedInvitation.WF_PROCESS_INVITATION_MODERATED);
            List<WorkflowTask> wf_moderated_tasks = this.workflowService.queryTasks(wfModeratedTaskQuery);
            for (WorkflowTask workflowTask : wf_moderated_tasks) {
                workflowId = workflowTask.path.instance.id;
                result = new ModeratedInvitationImpl(workflowTask.properties);
                keys = wfQueryModeratedProps.keySet();
                crap = false;
                for (QName key : keys) {
                    val1 = wfQueryModeratedProps.get(key);
                    if (val1.equals(val2 = workflowTask.properties.get(key))) continue;
                    crap = true;
                    logger.debug((Object)("ALFCOM-2598 key:" + key + "query:" + val1 + "task:" + val2));
                    break;
                }
                ((InvitationImpl)((Object)result)).setInviteId(workflowId);
                if (crap) continue;
                ret.add(result);
            }
        }
        return ret;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public MutableAuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setUserNameGenerator(UserNameGenerator usernameGenerator) {
        this.usernameGenerator = usernameGenerator;
    }

    public UserNameGenerator getUserNameGenerator() {
        return this.usernameGenerator;
    }

    public void setPasswordGenerator(PasswordGenerator passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    public PasswordGenerator getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    private String createInviteePerson(String inviteeFirstName, String inviteeLastName, String inviteeEmail) {
        String inviteeUserName = null;
        int i = 0;
        while (this.personService.personExists(inviteeUserName = this.usernameGenerator.generateUserName(inviteeFirstName, inviteeLastName, inviteeEmail, i)) && ++i < this.getMaxUserNameGenRetries()) {
        }
        if (this.personService.personExists(inviteeUserName)) {
            logger.debug((Object)"Failed - unable to generate username for invitee.");
            Object[] objs = new Object[]{inviteeFirstName, inviteeLastName, inviteeEmail};
            throw new InvitationException("invitation.invite.unable_generate_id", objs);
        }
        final HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, inviteeUserName);
        properties.put(ContentModel.PROP_FIRSTNAME, inviteeFirstName);
        properties.put(ContentModel.PROP_LASTNAME, inviteeLastName);
        properties.put(ContentModel.PROP_EMAIL, inviteeEmail);
        final String finalUserName = inviteeUserName;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                NodeRef person = InvitationServiceImpl.this.personService.createPerson(properties);
                InvitationServiceImpl.this.permissionService.setPermission(person, finalUserName, "All", true);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return inviteeUserName;
    }

    private String createInviteeDisabledAccount(String inviteeUserName) {
        char[] generatedPassword = this.passwordGenerator.generatePassword().toCharArray();
        this.authenticationService.createAuthentication(inviteeUserName, generatedPassword);
        this.authenticationService.setAuthenticationEnabled(inviteeUserName, false);
        return String.valueOf(generatedPassword);
    }

    private ModeratedInvitation startModeratedInvite(String inviteeComments, String inviteeUserName, Invitation.ResourceType resourceType, String resourceName, String inviteeRole) {
        NodeRef inviteeNodeRef = this.personService.getPerson(inviteeUserName);
        SiteInfo siteInfo = this.siteService.getSite(resourceName);
        if (this.siteService.isMember(resourceName, inviteeUserName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed - invitee user is already a member of the site.");
            }
            Object[] objs = new Object[]{inviteeUserName, "", resourceName};
            throw new InvitationExceptionUserError("invitation.invite.already_member", objs);
        }
        String roleGroup = this.siteService.getSiteRoleGroup(resourceName, "SiteManager");
        String workflowDescription = this.generateWorkflowDescription(siteInfo, "invitation.moderated.workflow.description");
        NodeRef wfPackage = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> workflowProps = new HashMap<QName, Serializable>(16);
        workflowProps.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        workflowProps.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)inviteeNodeRef);
        workflowProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)workflowDescription));
        workflowProps.put(WorkflowModelModeratedInvitation.ASSOC_GROUP_ASSIGNEE, (Serializable)((Object)roleGroup));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_COMMENTS, (Serializable)((Object)inviteeComments));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_ROLE, (Serializable)((Object)inviteeRole));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_INVITEE_USER_NAME, (Serializable)((Object)inviteeUserName));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_NAME, (Serializable)((Object)resourceName));
        workflowProps.put(WorkflowModelModeratedInvitation.WF_PROP_RESOURCE_TYPE, (Serializable)((Object)resourceType.toString()));
        WorkflowDefinition wfDefinition = this.workflowService.getDefinitionByName("jbpm$imwf:invitation-moderated");
        if (wfDefinition == null) {
            Object[] objs = new Object[]{"jbpm$imwf:invitation-moderated"};
            throw new InvitationException("invitation.error.noworkflow", objs);
        }
        WorkflowPath wfPath = this.workflowService.startWorkflow(wfDefinition.getId(), workflowProps);
        String workflowId = wfPath.instance.id;
        String wfPathId = wfPath.id;
        List<WorkflowTask> wfTasks = this.workflowService.getTasksForWorkflowPath(wfPathId);
        if (wfTasks.size() == 0) {
            Object[] objs = new Object[]{"jbpm$imwf:invitation-moderated"};
            throw new InvitationException("invitation.error.notasks", objs);
        }
        try {
            WorkflowTask wfStartTask = wfTasks.get(0);
            this.workflowService.endTask(wfStartTask.id, null);
        }
        catch (RuntimeException err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed - caught error during Invite workflow transition: " + err.getMessage()));
            }
            throw err;
        }
        ModeratedInvitationImpl result = new ModeratedInvitationImpl(workflowProps);
        result.setInviteId(workflowId);
        return result;
    }

    private NominatedInvitation startNominatedInvite(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, Invitation.ResourceType resourceType, String siteShortName, String inviteeSiteRole, String serverPath, String acceptUrl, String rejectUrl) {
        QName inviteToSiteTaskQName;
        String inviterUserName = this.authenticationService.getCurrentUserName();
        boolean created = false;
        this.checkManagerRole(inviterUserName, resourceType, siteShortName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startInvite() inviterUserName=" + inviterUserName + " inviteeUserName=" + inviteeUserName + " inviteeFirstName=" + inviteeFirstName + " inviteeLastName=" + inviteeLastName + " inviteeEmail=" + inviteeEmail + " siteShortName=" + siteShortName + " inviteeSiteRole=" + inviteeSiteRole));
        }
        if (inviteeUserName == null || inviteeUserName.trim().length() == 0) {
            inviteeUserName = null;
            Set<NodeRef> peopleWithInviteeEmail = this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)inviteeEmail));
            if (peopleWithInviteeEmail.size() > 0) {
                for (NodeRef personRef : peopleWithInviteeEmail) {
                    Serializable firstNameVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_FIRSTNAME);
                    Serializable lastNameVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_LASTNAME);
                    String personFirstName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
                    String personLastName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
                    if (personFirstName == null || !personFirstName.equalsIgnoreCase(inviteeFirstName) || personLastName == null || !personLastName.equalsIgnoreCase(inviteeLastName)) continue;
                    Serializable userNamePropertyVal = this.getNodeService().getProperty(personRef, ContentModel.PROP_USERNAME);
                    inviteeUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)userNamePropertyVal);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("not explictly passed username - found matching email, resolved inviteeUserName=" + inviteeUserName));
                }
            }
            if (inviteeUserName == null) {
                if (!this.authenticationService.isAuthenticationCreationAllowed()) {
                    throw new InvitationException("invitation.invite.authentication_chain", new Object[0]);
                }
                inviteeUserName = this.createInviteePerson(inviteeFirstName, inviteeLastName, inviteeEmail);
                created = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("not explictly passed username - created new person, inviteeUserName=" + inviteeUserName));
                }
            }
        } else {
            NodeRef person = this.personService.getPerson(inviteeUserName);
            Serializable firstNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_FIRSTNAME);
            Serializable lastNameVal = this.getNodeService().getProperty(person, ContentModel.PROP_LASTNAME);
            Serializable emailVal = this.getNodeService().getProperty(person, ContentModel.PROP_EMAIL);
            firstNameVal = (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)firstNameVal);
            lastNameVal = (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)lastNameVal);
            emailVal = (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)emailVal);
        }
        if (this.siteService.isMember(siteShortName, inviteeUserName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed - invitee user is already a member of the site.");
            }
            Object[] objs = new Object[]{inviteeUserName, inviteeEmail, siteShortName};
            throw new InvitationExceptionUserError("invitation.invite.already_member", objs);
        }
        final String initeeUserNameFinal = inviteeUserName;
        String inviteePassword = created ? (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() {
                return InvitationServiceImpl.this.createInviteeDisabledAccount(initeeUserNameFinal);
            }
        }, (String)AuthenticationUtil.getSystemUserName()) : null;
        String inviteTicket = GUID.generate();
        WorkflowDefinition wfDefinition = this.workflowService.getDefinitionByName("jbpm$inwf:invitation-nominated");
        if (wfDefinition == null) {
            Object[] objs = new Object[]{"jbpm$inwf:invitation-nominated"};
            throw new InvitationException("invitation.error.noworkflow", objs);
        }
        NodeRef inviteeNodeRef = this.personService.getPerson(inviteeUserName);
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        String siteDescription = siteInfo.getDescription();
        if (siteDescription == null) {
            siteDescription = "";
        } else if (siteDescription.length() > 255) {
            siteDescription = siteDescription.substring(0, 255);
        }
        String workflowDescription = this.generateWorkflowDescription(siteInfo, "invitation.nominated.workflow.description");
        HashMap<QName, Serializable> workflowProps = new HashMap<QName, Serializable>(32);
        workflowProps.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)workflowDescription));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME, (Serializable)((Object)inviterUserName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME, (Serializable)((Object)inviteeUserName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_EMAIL, (Serializable)((Object)inviteeEmail));
        workflowProps.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)inviteeNodeRef);
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_FIRSTNAME, (Serializable)((Object)inviteeFirstName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_LASTNAME, (Serializable)((Object)inviteeLastName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_GEN_PASSWORD, (Serializable)((Object)inviteePassword));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME, (Serializable)((Object)siteShortName));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TITLE, (Serializable)((Object)siteInfo.getTitle()));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_DESCRIPTION, (Serializable)((Object)siteDescription));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TYPE, (Serializable)((Object)resourceType.toString()));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE, (Serializable)((Object)inviteeSiteRole));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_SERVER_PATH, (Serializable)((Object)serverPath));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_ACCEPT_URL, (Serializable)((Object)acceptUrl));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_REJECT_URL, (Serializable)((Object)rejectUrl));
        workflowProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITE_TICKET, (Serializable)((Object)inviteTicket));
        WorkflowPath wfPath = this.workflowService.startWorkflow(wfDefinition.getId(), workflowProps);
        String workflowId = wfPath.instance.id;
        String wfPathId = wfPath.id;
        List<WorkflowTask> wfTasks = this.workflowService.getTasksForWorkflowPath(wfPathId);
        if (wfTasks.size() == 0) {
            Object[] objs = new Object[]{"jbpm$inwf:invitation-nominated"};
            throw new InvitationException("invitation.error.notasks", objs);
        }
        String wfTaskName = wfTasks.get((int)0).name;
        QName wfTaskNameQName = QName.createQName((String)wfTaskName, (NamespacePrefixResolver)this.namespaceService);
        if (!wfTaskNameQName.equals((Object)(inviteToSiteTaskQName = WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_TO_SITE))) {
            Object[] objs = new Object[]{wfPathId, WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_TO_SITE};
            throw new InvitationException("invitation.error.wrong_first_task", objs);
        }
        WorkflowTask wfStartTask = wfTasks.get(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting Invite workflow task by attaching empty package...");
        }
        NodeRef wfPackage = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> wfTaskProps = new HashMap<QName, Serializable>(1, 1.0f);
        wfTaskProps.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        wfTaskProps.put(WorkflowModel.PROP_WORKFLOW_INSTANCE_ID, (Serializable)((Object)workflowId));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Updating Invite workflow task...");
        }
        this.workflowService.updateTask(wfStartTask.id, wfTaskProps, null, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Transitioning Invite workflow task...");
        }
        try {
            this.workflowService.endTask(wfStartTask.id, "sendInvite");
        }
        catch (RuntimeException err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed - caught error during Invite workflow transition: " + err.getMessage()));
            }
            throw err;
        }
        NominatedInvitationImpl result = new NominatedInvitationImpl(workflowProps);
        result.setTicket(inviteTicket);
        result.setInviteId(workflowId);
        result.setSentInviteDate(new Date());
        return result;
    }

    private void checkManagerRole(String userId, Invitation.ResourceType resourceType, String siteShortName) {
        String inviterRole = this.siteService.getMembersRole(siteShortName, userId);
        if (inviterRole == null || !inviterRole.equals("SiteManager")) {
            Object[] objs = new Object[]{userId, siteShortName};
            throw new InvitationExceptionForbidden("invitation.invite.not_site_manager", objs);
        }
    }

    private void validateInvitationId(String invitationId) {
        String ID_SEPERATOR_REGEX = "\\$";
        String[] parts = invitationId.split("\\$");
        if (parts.length != 2) {
            Object[] objs = new Object[]{invitationId};
            throw new InvitationExceptionUserError("invitation.error.invalid_inviteId_format", objs);
        }
    }

    private int getMaxUserNameGenRetries() {
        return this.maxUserNameGenRetries;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        logger.debug((Object)"beforeDeleteNode");
        final NodeRef siteRef = nodeRef;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                String siteName;
                QName type = InvitationServiceImpl.this.nodeService.getType(siteRef);
                if (type.equals((Object)SiteModel.TYPE_SITE) && (siteName = (String)((Object)InvitationServiceImpl.this.nodeService.getProperty(siteRef, ContentModel.PROP_NAME))) != null) {
                    logger.debug((Object)("Invitation service delete node fired " + type + ", " + siteName));
                    List<Invitation> invitations = InvitationServiceImpl.this.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, siteName);
                    for (Invitation invitation : invitations) {
                        logger.debug((Object)("cancel workflow " + invitation.getInviteId()));
                        InvitationServiceImpl.this.workflowService.cancelWorkflow(invitation.getInviteId());
                    }
                }
                return null;
            }
        }, (String)"System");
    }

    protected String generateWorkflowDescription(SiteInfo siteInfo, String messageId) {
        String siteTitle = siteInfo.getTitle();
        if (siteTitle == null || siteTitle.length() == 0) {
            siteTitle = siteInfo.getShortName();
        }
        return I18NUtil.getMessage((String)messageId, (Object[])new Object[]{siteTitle});
    }
}

