/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class ModeratedActionReject
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 4377660284993206875L;
    private static final Log logger = LogFactory.getLog(ModeratedActionReject.class);
    private MutableAuthenticationDao mutableAuthenticationDao;
    private PersonService personService;
    private WorkflowService workflowService;
    private ActionService actionService;
    private TemplateService templateService;
    private String rejectTemplate = "/alfresco/bootstrap/invite/moderated-reject-email.ftl";

    protected void initialiseHandler(BeanFactory factory) {
        ServiceRegistry services = (ServiceRegistry)factory.getBean("ServiceRegistry");
        this.mutableAuthenticationDao = (MutableAuthenticationDao)factory.getBean("authenticationDao");
        this.personService = services.getPersonService();
        this.workflowService = services.getWorkflowService();
        this.templateService = services.getTemplateService();
        this.actionService = services.getActionService();
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        String resourceType = (String)executionContext.getVariable("imwf_resourceType");
        String resourceName = (String)executionContext.getVariable("imwf_resourceName");
        String inviteeUserName = (String)executionContext.getVariable("imwf_inviteeUserName");
        String inviteeRole = (String)executionContext.getVariable("imwf_inviteeRole");
        String reviewer = (String)executionContext.getVariable("imwf_reviewer");
        String reviewComments = (String)executionContext.getVariable("imwf_reviewComments");
        try {
            HashMap<String, String> model = new HashMap<String, String>(8, 1.0f);
            model.put("resourceName", resourceName);
            model.put("resourceType", resourceType);
            model.put("inviteeRole", inviteeRole);
            model.put("reviewComments", reviewComments);
            model.put("reviewer", reviewer);
            model.put("inviteeUserName", inviteeUserName);
            String emailMsg = this.templateService.processTemplate("freemarker", this.rejectTemplate, model);
            Action emailAction = this.actionService.createAction("mail");
            emailAction.setParameterValue("to", (Serializable)((Object)inviteeUserName));
            emailAction.setParameterValue("from", (Serializable)((Object)reviewer));
            emailAction.setParameterValue("subject", (Serializable)((Object)("Rejected invitation to web site:" + resourceName)));
            emailAction.setParameterValue("text", (Serializable)((Object)emailMsg));
            emailAction.setExecuteAsynchronously(true);
            this.actionService.executeAction(emailAction, null);
        }
        catch (Exception e) {
            logger.error((Object)"unable to send reject email", (Throwable)e);
        }
    }
}

