/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import com.werken.saxpath.XPathReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Search
extends BaseScopableProcessorExtension {
    private static Log logger = LogFactory.getLog(Search.class);
    protected ServiceRegistry services;
    protected StoreRef storeRef;
    protected Repository repository;

    public void setStoreUrl(String storeRef) {
        if (this.storeRef != null) {
            throw new IllegalStateException("Default store URL can only be set once.");
        }
        this.storeRef = new StoreRef(storeRef);
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setRepositoryHelper(Repository repository) {
        this.repository = repository;
    }

    public ScriptNode findNode(NodeRef ref) {
        ParameterCheck.mandatory((String)"ref", (Object)ref);
        String query = "ID:" + LuceneQueryParser.escape((String)ref.toString());
        Object[] result = this.query(ref.getStoreRef().toString(), query, null, "lucene");
        if (result.length != 0) {
            return (ScriptNode)result[0];
        }
        return null;
    }

    public ScriptNode findNode(String ref) {
        ParameterCheck.mandatoryString((String)"ref", (String)ref);
        return this.findNode(new NodeRef(ref));
    }

    public ScriptNode findNode(String referenceType, String[] reference) {
        ParameterCheck.mandatoryString((String)"referenceType", (String)referenceType);
        ParameterCheck.mandatory((String)"reference", (Object)reference);
        ScriptNode result = null;
        NodeRef nodeRef = this.repository.findNodeRef(referenceType, reference);
        if (nodeRef != null) {
            result = new ScriptNode(nodeRef, this.services, this.getScope());
        }
        return result;
    }

    public Scriptable xpathSearch(String search) {
        return this.xpathSearch(null, search);
    }

    public Scriptable xpathSearch(String store, String search) {
        if (search != null && search.length() != 0) {
            Object[] results = this.query(store, search, null, "xpath");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public boolean isValidXpathQuery(String query) {
        try {
            XPathReader reader = new XPathReader();
            reader.parse(query);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Scriptable luceneSearch(String search) {
        return this.luceneSearch(null, search);
    }

    public Scriptable luceneSearch(String store, String search) {
        if (search != null && search.length() != 0) {
            Object[] results = this.query(store, search, null, "lucene");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public Scriptable luceneSearch(String search, String sortColumn, boolean asc) {
        return this.luceneSearch(null, search, sortColumn, asc, 0);
    }

    public Scriptable luceneSearch(String search, String sortColumn, boolean asc, int max) {
        return this.luceneSearch(null, search, sortColumn, asc, max);
    }

    public Scriptable luceneSearch(String store, String search, String sortColumn, boolean asc) {
        return this.luceneSearch(store, search, sortColumn, asc, 0);
    }

    public Scriptable luceneSearch(String store, String search, String sortColumn, boolean asc, int max) {
        if (search == null || search.length() == 0) {
            return Context.getCurrentContext().newArray(this.getScope(), 0);
        }
        SortColumn[] sort = null;
        if (sortColumn != null && sortColumn.length() != 0) {
            sort = new SortColumn[]{new SortColumn(sortColumn, asc)};
        }
        Object[] results = this.query(store, search, sort, "lucene", max, 0);
        return Context.getCurrentContext().newArray(this.getScope(), results);
    }

    public Scriptable savedSearch(ScriptNode savedSearch) {
        String search = null;
        try {
            SAXReader reader;
            Document document;
            Element rootElement;
            Element queryElement;
            ContentReader content;
            if (savedSearch != null && (content = this.services.getContentService().getReader(savedSearch.getNodeRef(), ContentModel.PROP_CONTENT)) != null && content.exists() && (queryElement = (rootElement = (document = (reader = new SAXReader()).read((Reader)new StringReader(content.getContentString()))).getRootElement()).element("query")) != null) {
                search = queryElement.getText();
            }
        }
        catch (Throwable err) {
            throw new AlfrescoRuntimeException("Failed to find or load saved Search: " + savedSearch.getNodeRef(), err);
        }
        if (search != null) {
            Object[] results = this.query(null, search, null, "lucene");
            return Context.getCurrentContext().newArray(this.getScope(), results);
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public Scriptable savedSearch(String searchRef) {
        if (searchRef != null) {
            return this.savedSearch(new ScriptNode(new NodeRef(searchRef), this.services, null));
        }
        return Context.getCurrentContext().newArray(this.getScope(), 0);
    }

    public ScriptNode[] tagSearch(String store, String tag) {
        StoreRef searchStoreRef = null;
        searchStoreRef = store != null ? new StoreRef(store) : this.storeRef;
        List<NodeRef> nodeRefs = this.services.getTaggingService().findTaggedNodes(searchStoreRef, tag);
        ScriptNode[] nodes = new ScriptNode[nodeRefs.size()];
        int index = 0;
        for (NodeRef node : nodeRefs) {
            nodes[index] = new ScriptNode(node, this.services, this.getScope());
            ++index;
        }
        return nodes;
    }

    public Scriptable query(Object search) {
        Serializable obj;
        Object[] results = null;
        if (search instanceof Serializable && (obj = new ValueConverter().convertValueForRepo((Serializable)search)) instanceof Map) {
            Map def = (Map)((Object)obj);
            String query = (String)def.get("query");
            if (query == null || query.length() == 0) {
                throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'query' value.");
            }
            String store = (String)def.get("store");
            String language = (String)def.get("language");
            List sort = (List)def.get("sort");
            Map page = (Map)def.get("page");
            String namespace = (String)def.get("namespace");
            String onerror = (String)def.get("onerror");
            String defaultField = (String)def.get("defaultField");
            SortColumn[] sortColumns = null;
            if (sort != null) {
                sortColumns = new SortColumn[sort.size()];
                int index = 0;
                for (Map column : sort) {
                    String strCol = (String)column.get("column");
                    if (strCol == null || strCol.length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'sort: column' value.");
                    }
                    Boolean boolAsc = (Boolean)column.get("ascending");
                    boolean ascending = boolAsc != null ? boolAsc : false;
                    sortColumns[index++] = new SortColumn(strCol, ascending);
                }
            }
            int maxResults = -1;
            int skipResults = 0;
            if (page != null) {
                if (page.get("maxItems") != null) {
                    Object maxItems = page.get("maxItems");
                    if (maxItems instanceof Number) {
                        maxResults = ((Number)maxItems).intValue();
                    } else if (maxItems instanceof String) {
                        maxResults = Integer.parseInt((String)maxItems);
                    }
                }
                if (page.get("skipCount") != null) {
                    Object skipCount = page.get("skipCount");
                    if (skipCount instanceof Number) {
                        skipResults = ((Number)page.get("skipCount")).intValue();
                    } else if (skipCount instanceof String) {
                        skipResults = Integer.parseInt((String)skipCount);
                    }
                }
            }
            HashMap<String, String> queryTemplates = null;
            List templates = (List)def.get("templates");
            if (templates != null) {
                queryTemplates = new HashMap<String, String>(templates.size(), 1.0f);
                for (Map template : templates) {
                    String field = (String)template.get("field");
                    if (field == null || field.length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'template: field' value.");
                    }
                    String t = (String)template.get("template");
                    if (t == null || t.length() == 0) {
                        throw new AlfrescoRuntimeException("Failed to search: Missing mandatory 'template: template' value.");
                    }
                    queryTemplates.put(field, t);
                }
            }
            SearchParameters sp = new SearchParameters();
            sp.addStore(store != null ? new StoreRef(store) : this.storeRef);
            sp.setLanguage(language != null ? language : "lucene");
            sp.setQuery(query);
            if (defaultField != null) {
                sp.setDefaultFieldName(defaultField);
            }
            if (namespace != null) {
                sp.setNamespace(namespace);
            }
            if (maxResults > 0) {
                sp.setLimit(maxResults);
                sp.setLimitBy(LimitBy.FINAL_SIZE);
            }
            if (skipResults > 0) {
                sp.setSkipCount(skipResults);
            }
            if (sort != null) {
                for (SortColumn sd : sortColumns) {
                    sp.addSort(sd.column, sd.asc);
                }
            }
            if (queryTemplates != null) {
                for (String field : queryTemplates.keySet()) {
                    sp.addQueryTemplate(field, (String)queryTemplates.get(field));
                }
            }
            boolean exceptionOnError = true;
            if (onerror != null && !onerror.equals("exception")) {
                if (onerror.equals("no-results")) {
                    exceptionOnError = false;
                } else {
                    throw new AlfrescoRuntimeException("Failed to search: Unknown value supplied for 'onerror': " + onerror);
                }
            }
            results = this.query(sp, exceptionOnError);
        }
        if (results == null) {
            results = new Object[]{};
        }
        return Context.getCurrentContext().newArray(this.getScope(), results);
    }

    public String ISO9075Encode(String s) {
        return ISO9075.encode((String)s);
    }

    public String ISO9075Decode(String s) {
        return ISO9075.decode((String)s);
    }

    protected Object[] query(String store, String search, SortColumn[] sort, String language) {
        return this.query(store, search, sort, language, -1, 0);
    }

    protected Object[] query(String store, String search, SortColumn[] sort, String language, int maxResults, int skipResults) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(store != null ? new StoreRef(store) : this.storeRef);
        sp.setLanguage(language != null ? language : "lucene");
        sp.setQuery(search);
        if (maxResults > 0) {
            sp.setLimit(maxResults);
            sp.setLimitBy(LimitBy.FINAL_SIZE);
        }
        if (skipResults > 0) {
            sp.setSkipCount(skipResults);
        }
        if (sort != null) {
            for (SortColumn sd : sort) {
                sp.addSort(sd.column, sd.asc);
            }
        }
        return this.query(sp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] query(SearchParameters sp, boolean exceptionOnError) {
        Object[] objectArray;
        LinkedHashSet<ScriptNode> set;
        block10: {
            set = null;
            ResultSet results = null;
            try {
                try {
                    results = this.services.getSearchService().query(sp);
                    if (results.length() != 0) {
                        set = new LinkedHashSet<ScriptNode>(results.length(), 1.0f);
                        for (ResultSetRow row : results) {
                            NodeRef nodeRef = row.getNodeRef();
                            set.add(new ScriptNode(nodeRef, this.services, this.getScope()));
                        }
                    }
                    Object var9_9 = null;
                    if (results == null) break block10;
                }
                catch (Throwable err) {
                    if (exceptionOnError) {
                        throw new AlfrescoRuntimeException("Failed to execute search: " + sp.getQuery(), err);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to execute search: " + sp.getQuery()), err);
                    }
                    Object var9_10 = null;
                    if (results != null) {
                        results.close();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (results == null) throw throwable;
                results.close();
                throw throwable;
            }
            results.close();
        }
        if (set != null) {
            objectArray = set.toArray(new Object[set.size()]);
            return objectArray;
        }
        objectArray = new Object[]{};
        return objectArray;
    }

    public class SortColumn {
        public String column;
        public boolean asc;

        public SortColumn(String column, boolean asc) {
            this.column = column;
            this.asc = asc;
        }
    }
}

