/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderServiceImpl
implements FileFolderService {
    private static final String XPATH_QUERY_SHALLOW_ALL = "./*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static final String XPATH_QUERY_DEEP_ALL = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static final String XPATH_QUERY_DEEP_FOLDERS = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "'))]";
    private static final String XPATH_QUERY_DEEP_FILES = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static final QueryParameterDefinition[] PARAMS_ANY_NAME = new QueryParameterDefinition[1];
    private static Log logger = LogFactory.getLog(FileFolderServiceImpl.class);
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private CopyService copyService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private Set<String> systemNamespaces = new HashSet<String>(5);
    private List<String> systemPaths;
    private static final String LUCENE_MULTI_CHAR_WILDCARD = "*";

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setSystemNamespaces(List<String> systemNamespaces) {
        this.systemNamespaces.addAll(systemNamespaces);
    }

    public void setSystemPaths(List<String> systemPaths) {
        this.systemPaths = systemPaths;
    }

    public void init() {
    }

    private List<FileInfo> toFileInfo(List<NodeRef> nodeRefs) throws InvalidTypeException {
        ArrayList<FileInfo> results = new ArrayList<FileInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            if (!this.nodeService.exists(nodeRef)) continue;
            FileInfo fileInfo = this.toFileInfo(nodeRef, true);
            results.add(fileInfo);
        }
        return results;
    }

    private FileInfo toFileInfo(NodeRef nodeRef, boolean addTranslations) throws InvalidTypeException {
        Map properties = this.nodeService.getProperties(nodeRef);
        QName typeQName = this.nodeService.getType(nodeRef);
        boolean isFolder = this.isFolder(typeQName);
        FileInfoImpl fileInfo = new FileInfoImpl(nodeRef, isFolder, properties);
        return fileInfo;
    }

    private boolean isFolder(QName typeQName) throws InvalidTypeException {
        FileFolderServiceType type = this.getType(typeQName);
        switch (type) {
            case FILE: {
                return false;
            }
            case FOLDER: {
                return true;
            }
            case SYSTEM_FOLDER: {
                throw new InvalidTypeException("This service should ignore type " + ContentModel.TYPE_SYSTEM_FOLDER);
            }
        }
        throw new InvalidTypeException("Type is not handled by this service: " + typeQName);
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        return this.nodeService.exists(nodeRef);
    }

    @Override
    public FileFolderServiceType getType(QName typeQName) {
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                return FileFolderServiceType.SYSTEM_FOLDER;
            }
            return FileFolderServiceType.FOLDER;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT) || this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_LINK)) {
            return FileFolderServiceType.FILE;
        }
        return FileFolderServiceType.INVALID;
    }

    @Override
    public List<FileInfo> list(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.listSimple(contextNodeRef, true, true);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for files and folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFiles(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.listSimple(contextNodeRef, false, true);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for files: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFolders(NodeRef contextNodeRef) {
        List<NodeRef> nodeRefs = this.listSimple(contextNodeRef, true, false);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Shallow search for folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listDeepFolders(NodeRef contextNodeRef, SubFolderFilter filter) {
        List<NodeRef> nodeRefs = this.listSimpleDeep(contextNodeRef, true, false, filter);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deep search for files: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public NodeRef searchSimple(NodeRef contextNodeRef, String name) {
        NodeRef childNodeRef = this.nodeService.getChildByName(contextNodeRef, ContentModel.ASSOC_CONTAINS, name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Simple name search results: \n   parent: " + contextNodeRef + "\n" + "   name: " + name + "\n" + "   result: " + childNodeRef));
        }
        return childNodeRef;
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        return this.search(contextNodeRef, namePattern, true, true, includeSubFolders);
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        List<NodeRef> nodeRefs = this.searchInternal(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        Iterator<FileInfo> iterator = results.iterator();
        while (iterator.hasNext()) {
            FileInfo file = iterator.next();
            if (file.isFolder() && !folderSearch) {
                iterator.remove();
                continue;
            }
            if (file.isFolder() || fileSearch) continue;
            iterator.remove();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deep search: \n   context: " + contextNodeRef + "\n" + "   pattern: " + namePattern + "\n" + "   files: " + fileSearch + "\n" + "   folders: " + folderSearch + "\n" + "   deep: " + includeSubFolders + "\n" + "   results: " + results));
        }
        return results;
    }

    private List<NodeRef> searchInternal(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        if (!fileSearch && !folderSearch) {
            return Collections.emptyList();
        }
        if (namePattern == null) {
            namePattern = LUCENE_MULTI_CHAR_WILDCARD;
        }
        boolean anyName = namePattern.equals(LUCENE_MULTI_CHAR_WILDCARD);
        List<Object> nodeRefs = null;
        if (anyName) {
            nodeRefs = includeSubFolders ? this.listSimpleDeep(contextNodeRef, folderSearch, fileSearch, null) : this.listSimple(contextNodeRef, folderSearch, fileSearch);
        } else {
            QueryParameterDefinition[] params = null;
            if (namePattern != null) {
                namePattern = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_XPATH_LIKE, (String)namePattern);
                params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, namePattern)};
            } else {
                params = PARAMS_ANY_NAME;
            }
            String query = null;
            query = includeSubFolders ? (!fileSearch && folderSearch ? XPATH_QUERY_DEEP_FOLDERS : (fileSearch && !folderSearch ? XPATH_QUERY_DEEP_FILES : XPATH_QUERY_DEEP_ALL)) : XPATH_QUERY_SHALLOW_ALL;
            nodeRefs = this.searchService.selectNodes(contextNodeRef, query, params, (NamespacePrefixResolver)this.namespaceService, false);
        }
        return nodeRefs;
    }

    private List<NodeRef> listSimple(NodeRef contextNodeRef, boolean folders, boolean files) {
        Collection qnames;
        HashSet<QName> searchTypeQNames = new HashSet<QName>(10);
        if (folders) {
            qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
            searchTypeQNames.addAll(qnames);
            searchTypeQNames.add(ContentModel.TYPE_FOLDER);
        }
        if (files) {
            qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
            searchTypeQNames.addAll(qnames);
            searchTypeQNames.add(ContentModel.TYPE_CONTENT);
            qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_LINK, true);
            searchTypeQNames.addAll(qnames);
            searchTypeQNames.add(ContentModel.TYPE_LINK);
        }
        qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
        searchTypeQNames.removeAll(qnames);
        searchTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
        if (searchTypeQNames.size() == 0) {
            return Collections.emptyList();
        }
        List childAssocRefs = this.nodeService.getChildAssocs(contextNodeRef, searchTypeQNames);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>(childAssocRefs.size());
        for (ChildAssociationRef assocRef : childAssocRefs) {
            result.add(assocRef.getChildRef());
        }
        return result;
    }

    private List<NodeRef> listSimpleDeep(NodeRef contextNodeRef, boolean folders, boolean files, SubFolderFilter folderFilter) {
        HashSet<QName> folderTypeQNames = new HashSet<QName>(10);
        HashSet<QName> fileTypeQNames = new HashSet<QName>(10);
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
        folderTypeQNames.addAll(qnames);
        folderTypeQNames.add(ContentModel.TYPE_FOLDER);
        Collection systemFolderQNames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
        folderTypeQNames.removeAll(systemFolderQNames);
        folderTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
        if (files) {
            Collection fileQNames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
            fileTypeQNames.addAll(fileQNames);
            fileTypeQNames.add(ContentModel.TYPE_CONTENT);
            Collection linkQNames = this.dictionaryService.getSubTypes(ContentModel.TYPE_LINK, true);
            fileTypeQNames.addAll(linkQNames);
            fileTypeQNames.add(ContentModel.TYPE_LINK);
        }
        if (!folders && !files) {
            return Collections.emptyList();
        }
        if (folderTypeQNames.size() == 0) {
            return Collections.emptyList();
        }
        Stack<NodeRef> toSearch = new Stack<NodeRef>();
        toSearch.push(contextNodeRef);
        while (!toSearch.empty()) {
            NodeRef currentDir = (NodeRef)toSearch.pop();
            List folderAssocRefs = this.nodeService.getChildAssocs(currentDir, folderTypeQNames);
            for (ChildAssociationRef folderRef : folderAssocRefs) {
                boolean include = true;
                if (folderFilter != null) {
                    include = folderFilter.isEnterSubfolder(folderRef);
                    if (include) {
                        toSearch.push(folderRef.getChildRef());
                    }
                } else {
                    toSearch.push(folderRef.getChildRef());
                }
                if (!folders || !include) continue;
                result.add(folderRef.getChildRef());
            }
            if (!files) continue;
            List fileAssocRefs = this.nodeService.getChildAssocs(currentDir, fileTypeQNames);
            for (ChildAssociationRef fileRef : fileAssocRefs) {
                result.add(fileRef.getChildRef());
            }
        }
        logger.debug((Object)("search deep finished size:" + result.size()));
        return result;
    }

    @Override
    public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
        Set nodeRefRenameSet = TransactionalResourceHelper.getSet("RuleTrigger.NodeSet");
        String marker = sourceNodeRef.toString() + "rename";
        nodeRefRenameSet.add(marker);
        return this.moveOrCopy(sourceNodeRef, null, newName, true);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo copy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, targetParentRef, newName, false);
    }

    private FileInfo moveOrCopy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName, boolean move) throws FileExistsException, FileNotFoundException {
        boolean changedParent;
        FileInfo beforeFileInfo = this.toFileInfo(sourceNodeRef, true);
        if (newName == null) {
            newName = beforeFileInfo.getName();
        }
        boolean nameChanged = !newName.equals(beforeFileInfo.getName());
        ChildAssociationRef assocRef = this.nodeService.getPrimaryParent(sourceNodeRef);
        if (targetParentRef == null) {
            targetParentRef = assocRef.getParentRef();
        }
        boolean bl = changedParent = !targetParentRef.equals((Object)assocRef.getParentRef());
        if (!nameChanged && !changedParent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Doing nothing - neither filename or parent has changed: \n   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   new name: " + newName));
            }
            return beforeFileInfo;
        }
        QName existingQName = assocRef.getQName();
        QName qname = nameChanged && !this.systemNamespaces.contains(existingQName.getNamespaceURI()) ? QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)newName)) : existingQName;
        QName targetParentType = this.nodeService.getType(targetParentRef);
        QName assocTypeQname = null;
        if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_FOLDER)) {
            assocTypeQname = ContentModel.ASSOC_CONTAINS;
        } else if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_CONTAINER)) {
            assocTypeQname = ContentModel.ASSOC_CHILDREN;
        } else {
            throw new InvalidTypeException("Unexpected type (" + targetParentType + ") for target parent: " + targetParentRef);
        }
        NodeRef targetNodeRef = null;
        if (move) {
            if (!this.isSystemPath(sourceNodeRef)) {
                if (nameChanged) {
                    this.nodeService.setProperty(sourceNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)GUID.generate()));
                }
                try {
                    ChildAssociationRef newAssocRef = this.nodeService.moveNode(sourceNodeRef, targetParentRef, assocTypeQname, qname);
                    targetNodeRef = newAssocRef.getChildRef();
                }
                catch (DuplicateChildNodeNameException e) {
                    throw new FileExistsException(targetParentRef, newName);
                }
            } else {
                targetNodeRef = sourceNodeRef;
            }
        } else {
            try {
                targetNodeRef = this.copyService.copy(sourceNodeRef, targetParentRef, assocTypeQname, qname, true);
            }
            catch (DuplicateChildNodeNameException e) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        String currentName = (String)((Object)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_NAME));
        if (!currentName.equals(newName)) {
            try {
                String newMimetype;
                String targetMimetype;
                this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
                ContentData contentData = (ContentData)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_CONTENT);
                String oldExt = this.getExtension(beforeFileInfo.getName());
                String newExt = this.getExtension(newName);
                if (!(contentData == null || newExt.length() == 0 || "tmp".equalsIgnoreCase(newExt) || newExt.equalsIgnoreCase(oldExt) || (targetMimetype = contentData.getMimetype()).equalsIgnoreCase(newMimetype = this.mimetypeService.guessMimetype(newName)))) {
                    contentData = ContentData.setMimetype((ContentData)contentData, (String)newMimetype);
                    this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
            }
            catch (DuplicateChildNodeNameException e) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        FileInfo afterFileInfo = this.toFileInfo(targetNodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + (move ? "Moved" : "Copied") + " node: \n" + "   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   after: " + afterFileInfo));
        }
        return afterFileInfo;
    }

    private boolean isSystemPath(NodeRef nodeRef) {
        Path path = this.nodeService.getPath(nodeRef);
        String prefixedPath = path.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return this.systemPaths.contains(prefixedPath);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, null);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, assocQName);
    }

    private FileInfo createImpl(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, name);
        if (assocQName == null) {
            assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        }
        ChildAssociationRef assocRef = null;
        try {
            assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName, properties);
        }
        catch (DuplicateChildNodeNameException e) {
            throw new FileExistsException(parentNodeRef, name);
        }
        NodeRef nodeRef = assocRef.getChildRef();
        FileInfo fileInfo = this.toFileInfo(nodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created: \n   parent: " + parentNodeRef + "\n" + "   created: " + fileInfo));
        }
        return fileInfo;
    }

    @Override
    public void delete(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted: \n   node: " + nodeRef));
        }
    }

    public FileInfo makeFolders(NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(this, parentNodeRef, pathElements, folderTypeQName);
    }

    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(service, parentNodeRef, pathElements, folderTypeQName);
    }

    @Override
    public List<FileInfo> getNamePath(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null) {
            rootNodeRef = this.nodeService.getRootNode(nodeRef.getStoreRef());
        }
        try {
            ArrayList<FileInfo> results = new ArrayList<FileInfo>(10);
            Path path = this.nodeService.getPath(nodeRef);
            boolean foundRoot = false;
            for (Path.Element element : path) {
                Path.ChildAssocElement assocElement = (Path.ChildAssocElement)element;
                NodeRef childNodeRef = assocElement.getRef().getChildRef();
                if (childNodeRef.equals((Object)rootNodeRef)) {
                    foundRoot = true;
                    continue;
                }
                if (!foundRoot) continue;
                FileInfo pathInfo = this.toFileInfo(childNodeRef, true);
                results.add(pathInfo);
            }
            if (!foundRoot || results.size() == 0) {
                throw new FileNotFoundException(nodeRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Built name path for node: \n   root: " + rootNodeRef + "\n" + "   node: " + nodeRef + "\n" + "   path: " + results));
            }
            return results;
        }
        catch (InvalidNodeRefException e) {
            throw new FileNotFoundException(nodeRef);
        }
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements) throws FileNotFoundException {
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path elements list is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        StringBuilder currentPath = new StringBuilder(pathElements.size() << 4);
        int folderCount = pathElements.size() - 1;
        for (int i = 0; i < folderCount; ++i) {
            String pathElement = pathElements.get(i);
            NodeRef folderNodeRef = this.searchSimple(parentNodeRef, pathElement);
            if (folderNodeRef == null) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("Folder not found: " + currentPath);
                throw new FileNotFoundException(sb.toString());
            }
            parentNodeRef = folderNodeRef;
        }
        String pathElement = pathElements.get(pathElements.size() - 1);
        NodeRef fileNodeRef = this.searchSimple(parentNodeRef, pathElement);
        if (fileNodeRef == null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("File not found: " + currentPath);
            throw new FileNotFoundException(sb.toString());
        }
        FileInfo result = this.getFileInfo(fileNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resoved path element: \n   root: " + rootNodeRef + "\n" + "   path: " + currentPath + "\n" + "   node: " + result));
        }
        return result;
    }

    @Override
    public FileInfo getFileInfo(NodeRef nodeRef) {
        try {
            return this.toFileInfo(nodeRef, true);
        }
        catch (InvalidTypeException e) {
            return null;
        }
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content reader for a folder: " + fileInfo);
        }
        return this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content writer for a folder: " + fileInfo);
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        if (writer.getMimetype() == null) {
            String name = fileInfo.getName();
            writer.setMimetype(this.mimetypeService.guessMimetype(name));
        }
        return writer;
    }

    private String getExtension(String name) {
        int index;
        String result = "";
        if (name != null && (index = (name = name.trim()).lastIndexOf(46)) > -1 && index < name.length() - 1) {
            result = name.substring(index + 1);
        }
        return result;
    }

    private static class InvalidTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -310101369475434280L;

        public InvalidTypeException(String msg) {
            super(msg);
        }
    }
}

