/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.springframework.util.FileCopyUtils;

public class LoaderCOCIThread
extends AbstractLoaderThread {
    private int filesPerIteration;
    private FileInfo[] filesInfo;

    public LoaderCOCIThread(LoaderSession session, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose, long filesPerIteration) {
        super(session, loaderName, testPeriod, testTotal, testLoadDepth, verbose);
        this.filesPerIteration = (int)filesPerIteration;
    }

    protected String doLoading(LoaderServerProxy serverProxy, NodeRef workingRootNodeRef) throws Exception {
        ArrayList<HashMap<String, Serializable>> arrVersionProp = new ArrayList<HashMap<String, Serializable>>();
        byte[][] bytes = new byte[this.filesPerIteration][];
        for (int i = 0; i < this.filesPerIteration; ++i) {
            File file = this.getFile();
            bytes[i] = FileCopyUtils.copyToByteArray((File)file);
            arrVersionProp.add(new HashMap());
        }
        serverProxy.loaderRemote.coci(serverProxy.ticket, this.getNodesRef(this.filesInfo), bytes, arrVersionProp);
        return String.format("update version %d files in folder: %s", this.filesPerIteration, workingRootNodeRef.toString());
    }

    protected void doBefore(LoaderServerProxy loaderServerProxy, NodeRef nodeRef) throws Exception {
        List<String> folderPath = super.chooseFolderPath();
        NodeRef folderNodeRef = this.makeFolders(loaderServerProxy.ticket, loaderServerProxy, nodeRef, folderPath);
        String[] fileNames = new String[this.filesPerIteration];
        NodeRef[] parentNodeRefs = new NodeRef[this.filesPerIteration];
        QName[] types = new QName[this.filesPerIteration];
        for (int i = 0; i < this.filesPerIteration; ++i) {
            fileNames[i] = GUID.generate();
            parentNodeRefs[i] = folderNodeRef;
            types[i] = ContentModel.TYPE_CONTENT;
        }
        this.filesInfo = loaderServerProxy.fileFolderRemote.create(loaderServerProxy.ticket, parentNodeRefs, fileNames, types);
    }

    public String getSummary() {
        String summary = super.getSummary();
        summary = summary + String.format("%d files per iteration", this.filesPerIteration);
        return summary;
    }

    NodeRef[] getNodesRef(FileInfo[] filesInfoList) {
        NodeRef[] nr = new NodeRef[filesInfoList.length];
        for (int i = 0; i < filesInfoList.length; ++i) {
            nr[i] = filesInfoList[i].getNodeRef();
        }
        return nr;
    }
}

