/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.io.File;
import java.util.List;
import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.springframework.util.FileCopyUtils;

public class LoaderUploadThread
extends AbstractLoaderThread {
    private int filesPerUpload;

    public LoaderUploadThread(LoaderSession session, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose, long filesPerUpload) {
        super(session, loaderName, testPeriod, testTotal, testLoadDepth, verbose);
        this.filesPerUpload = (int)filesPerUpload;
    }

    protected String doLoading(LoaderServerProxy serverProxy, NodeRef workingRootNodeRef) throws Exception {
        List<String> folderPath = super.chooseFolderPath();
        NodeRef folderNodeRef = this.makeFolders(serverProxy.ticket, serverProxy, workingRootNodeRef, folderPath);
        byte[][] bytes = new byte[this.filesPerUpload][];
        String[] filenames = new String[this.filesPerUpload];
        for (int i = 0; i < this.filesPerUpload; ++i) {
            File file = this.getFile();
            bytes[i] = FileCopyUtils.copyToByteArray((File)file);
            filenames[i] = GUID.generate();
            int index = file.getName().lastIndexOf(46);
            if (index <= 0) continue;
            String ext = file.getName().substring(index + 1, file.getName().length());
            int n = i;
            filenames[n] = filenames[n] + "." + ext;
        }
        FileInfo[] fileInfos = serverProxy.loaderRemote.uploadContent(serverProxy.ticket, folderNodeRef, filenames, bytes);
        String msg = String.format("Uploaded %d files to folder: %s", fileInfos.length, folderPath.toString());
        return msg;
    }

    public String getSummary() {
        String summary = super.getSummary();
        summary = summary + String.format("%d files per iteration", this.filesPerUpload);
        return summary;
    }
}

