/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MLContentInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(MLContentInterceptor.class);
    private NodeService nodeService;
    private ContentService contentService;
    private MultilingualContentService multilingualContentService;

    public void setNodeService(NodeService bean) {
        this.nodeService = bean;
    }

    public void setContentService(ContentService directContentService) {
        this.contentService = directContentService;
    }

    public void setMultilingualContentService(MultilingualContentService directMultilingualContentService) {
        this.multilingualContentService = directMultilingualContentService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Object ret = null;
        if (methodName.equals("getReader")) {
            Object[] args = invocation.getArguments();
            NodeRef nodeRef = (NodeRef)args[0];
            if (nodeRef.getStoreRef().getProtocol().equals("avm") || !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                return invocation.proceed();
            }
            QName propertyQName = null;
            propertyQName = args.length == 1 ? ContentModel.PROP_CONTENT : (QName)args[1];
            NodeRef pivotNodeRef = this.multilingualContentService.getPivotTranslation(nodeRef);
            if (pivotNodeRef == null) {
                ret = invocation.proceed();
            } else {
                ContentReader pivotContentReader = this.contentService.getReader(pivotNodeRef, propertyQName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converted reader for empty translation: \n   Empty Translation: " + nodeRef + "\n" + "   Pivot Translation: " + pivotNodeRef + "\n" + "   Reader:            " + pivotContentReader));
                }
                ret = pivotContentReader;
            }
        } else {
            ret = invocation.proceed();
        }
        return ret;
    }
}

