/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilingualDocumentAspect
implements CopyServicePolicies.OnCopyNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private PolicyComponent policyComponent;
    private MultilingualContentService multilingualContentService;
    private NodeService nodeService;

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_MULTILINGUAL_DOCUMENT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.ASPECT_MULTILINGUAL_DOCUMENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.ASPECT_MULTILINGUAL_DOCUMENT, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        this.multilingualContentService.unmakeTranslation(nodeRef);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Locale localeBefore = (Locale)before.get(ContentModel.PROP_LOCALE);
        Locale localeAfter = null;
        Serializable objLocaleAfter = after.get(ContentModel.PROP_LOCALE);
        if (objLocaleAfter != null) {
            localeAfter = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)objLocaleAfter);
        }
        if (localeBefore == null || !localeBefore.equals(localeAfter)) {
            int childSize;
            NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(nodeRef);
            int transSize = this.multilingualContentService.getTranslations(mlContainer).size();
            if (transSize != (childSize = this.nodeService.getChildAssocs(mlContainer, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL).size())) {
                throw new IllegalArgumentException("The locale " + localeAfter + " can't be changed for the node " + nodeRef + " because this locale is already in use in an other translation of the same " + ContentModel.TYPE_MULTILINGUAL_CONTAINER + ".");
            }
            Locale localMlContainer = (Locale)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE);
            if (localeBefore != null && localeBefore.equals(localMlContainer)) {
                this.nodeService.setProperty(mlContainer, ContentModel.PROP_LOCALE, (Serializable)localeAfter);
            }
        }
    }
}

