/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.io.DefaultRaesZipDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.ZipDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.module.tool.InstalledFiles;
import org.alfresco.repo.module.tool.ModuleManagementTool;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.util.TempFileProvider;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManagementToolTest
extends TestCase {
    private ModuleManagementTool manager = new ModuleManagementTool();
    ZipDetector defaultDetector = new DefaultRaesZipDetector("amp|war");

    public void testBasicInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        String ampV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        this.manager.installModule(ampLocation, warLocation);
        ArrayList<String> files = new ArrayList<String>(10);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files.add("/WEB-INF/lib/test.jar");
        files.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        files.add("/WEB-INF/classes/alfresco/module/test");
        files.add("/WEB-INF/licenses/license.txt");
        files.add("/scripts/test.js");
        files.add("/images/test.jpg");
        files.add("/jsp/test.jsp");
        files.add("/css/test.css");
        files.add("/extra.txt");
        this.checkForFileExistance(warLocation, files);
        InstalledFiles installed0 = new InstalledFiles(warLocation, "test");
        installed0.load();
        ModuleManagementToolTest.assertNotNull((Object)installed0);
        ModuleManagementToolTest.assertEquals((int)8, (int)installed0.getAdds().size());
        ModuleManagementToolTest.assertEquals((int)1, (int)installed0.getMkdirs().size());
        ModuleManagementToolTest.assertEquals((int)1, (int)installed0.getUpdates().size());
        String backup = null;
        String orig = null;
        for (Map.Entry<String, String> update : installed0.getUpdates().entrySet()) {
            this.checkContentsOfFile(warLocation + update.getKey(), "VERSIONONE");
            this.checkContentsOfFile(warLocation + update.getValue(), "ORIGIONAL");
            backup = update.getValue();
            orig = update.getKey();
        }
        try {
            this.manager.installModule(ampLocation, warLocation);
            ModuleManagementToolTest.fail((String)"The module is already installed so an exception should have been raised since we are not forcing an overwite");
        }
        catch (ModuleManagementToolException exception) {
            // empty catch block
        }
        this.manager.installModule(ampV2Location, warLocation);
        ArrayList<String> files2 = new ArrayList<String>(12);
        files.add("/WEB-INF/classes/alfresco/module/test/module.properties");
        files.add("/WEB-INF/classes/alfresco/module/test/modifications.install");
        files2.add("/WEB-INF/lib/test.jar");
        files2.add("/WEB-INF/classes/alfresco/module/test/module-context.xml");
        files2.add("/WEB-INF/classes/alfresco/module/test");
        files2.add("/WEB-INF/licenses/license.txt");
        files2.add("/scripts/test2.js");
        files2.add("/scripts/test3.js");
        files2.add("/images/test.jpg");
        files2.add("/css/test.css");
        files2.add("/WEB-INF/classes/alfresco/module/test/version2");
        files2.add("/WEB-INF/classes/alfresco/module/test/version2/version2-context.xml");
        this.checkForFileExistance(warLocation, files2);
        ArrayList<String> files3 = new ArrayList<String>(2);
        files3.add("/scripts/test.js");
        files3.add("/jsp/test.jsp");
        files3.add("/extra.txt");
        files3.add(backup);
        this.checkForFileNonExistance(warLocation, files3);
        InstalledFiles installed1 = new InstalledFiles(warLocation, "test");
        installed1.load();
        ModuleManagementToolTest.assertNotNull((Object)installed1);
        ModuleManagementToolTest.assertEquals((int)8, (int)installed1.getAdds().size());
        ModuleManagementToolTest.assertEquals((int)1, (int)installed1.getMkdirs().size());
        ModuleManagementToolTest.assertEquals((int)0, (int)installed1.getUpdates().size());
        this.checkContentsOfFile(warLocation + orig, "ORIGIONAL");
        try {
            this.manager.installModule(ampLocation, warLocation);
            ModuleManagementToolTest.fail((String)"An earlier version of this module is already installed so an exception should have been raised since we are not forcing an overwite");
        }
        catch (ModuleManagementToolException exception) {
            // empty catch block
        }
    }

    public void testDependencySuccess() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String testAmpV1Location = this.getFileLocation(".amp", "module/test_v1.amp");
        String testAmpV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        String testAmpDepV1Location = this.getFileLocation(".amp", "module/dependent_on_test_v1.amp");
        String testAmpDepV2Location = this.getFileLocation(".amp", "module/dependent_on_test_v2.amp");
        this.manager.installModule(testAmpV1Location, warLocation, false, false, false);
        this.manager.installModule(testAmpDepV1Location, warLocation, false, false, false);
        try {
            this.manager.installModule(testAmpDepV2Location, warLocation, false, false, false);
            ModuleManagementToolTest.fail((String)"Failed to detect inadequate dependency on the test amp");
        }
        catch (ModuleManagementToolException e) {
            System.out.println("Expected: " + e.getMessage());
        }
        this.manager.installModule(testAmpV2Location, warLocation, false, false, false);
        this.manager.installModule(testAmpDepV2Location, warLocation, false, false, false);
    }

    public void testPreviewInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.installModule(ampLocation, warLocation, true, false, true);
    }

    public void testForcedInstall() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.installModule(ampLocation, warLocation, false, false, false);
        this.manager.installModule(ampLocation, warLocation, false, true, false);
    }

    public void testInstallFromDir() throws Exception {
        this.manager.setVerbose(true);
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        String ampV2Location = this.getFileLocation(".amp", "module/test_v2.amp");
        int index = ampV2Location.lastIndexOf(File.separator);
        System.out.println(index);
        String directoryLocation = ampV2Location.substring(0, index);
        try {
            this.manager.installModules(directoryLocation, warLocation);
        }
        catch (ModuleManagementToolException exception) {
            exception.printStackTrace();
            System.out.println("Expected failure: " + exception.getMessage());
        }
    }

    public void testList() throws Exception {
        String warLocation = this.getFileLocation(".war", "module/test.war");
        String ampLocation = this.getFileLocation(".amp", "module/test_v1.amp");
        this.manager.listModules(warLocation);
        this.manager.installModule(ampLocation, warLocation);
        this.manager.listModules(warLocation);
    }

    private String getFileLocation(String extension, String location) throws IOException {
        File file = TempFileProvider.createTempFile((String)"moduleManagementToolTest-", (String)extension);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(location);
        ModuleManagementToolTest.assertNotNull((Object)is);
        FileOutputStream os = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        return file.getPath();
    }

    private void checkForFileExistance(String warLocation, List<String> files) {
        for (String file : files) {
            de.schlichtherle.io.File file0 = new de.schlichtherle.io.File(warLocation + file, this.defaultDetector);
            ModuleManagementToolTest.assertTrue((String)("The file/dir " + file + " does not exist in the WAR."), (boolean)file0.exists());
        }
    }

    private void checkForFileNonExistance(String warLocation, List<String> files) {
        for (String file : files) {
            de.schlichtherle.io.File file0 = new de.schlichtherle.io.File(warLocation + file, this.defaultDetector);
            ModuleManagementToolTest.assertFalse((String)("The file/dir " + file + " does exist in the WAR."), (boolean)file0.exists());
        }
    }

    private void checkContentsOfFile(String location, String expectedContents) throws IOException {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(location, this.defaultDetector);
        ModuleManagementToolTest.assertTrue((boolean)file.exists());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file)));
        String line = reader.readLine();
        ModuleManagementToolTest.assertNotNull((Object)line);
        ModuleManagementToolTest.assertEquals((String)expectedContents, (String)line.trim());
    }
}

