/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.TestWithUserUtils;
import org.springframework.context.ApplicationContext;

public class ArchiveAndRestoreTest
extends TestCase {
    private static final String USER_A = "aaaaa";
    private static final String USER_B = "bbbbb";
    private static final QName ASPECT_ATTACHABLE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"attachable");
    private static final QName ASSOC_ATTACHMENTS = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"attachments");
    private static final QName QNAME_A = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"a");
    private static final QName QNAME_B = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"b");
    private static final QName QNAME_AA = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa");
    private static final QName QNAME_BB = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bb");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeArchiveService nodeArchiveService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private OwnableService ownableService;
    private TransactionService transactionService;
    private UserTransaction txn;
    private StoreRef workStoreRef;
    private NodeRef workStoreRootNodeRef;
    private StoreRef archiveStoreRef;
    private NodeRef archiveStoreRootNodeRef;
    private NodeRef a;
    private NodeRef b;
    private NodeRef aa;
    private NodeRef bb;
    AssociationRef assocAtoB;
    AssociationRef assocAAtoBB;
    ChildAssociationRef childAssocAtoAA;
    ChildAssociationRef childAssocBtoBB;
    ChildAssociationRef childAssocBtoAA;
    ChildAssociationRef childAssocAtoBB;
    private NodeRef a_;
    private NodeRef b_;
    private NodeRef aa_;
    private NodeRef bb_;
    ChildAssociationRef childAssocAtoAA_;
    ChildAssociationRef childAssocBtoBB_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        this.nodeService = serviceRegistry.getNodeService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.ownableService = (OwnableService)ctx.getBean("ownableService");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        IntegrityChecker.setWarnInTransaction();
        try {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            this.workStoreRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
            this.workStoreRootNodeRef = this.nodeService.getRootNode(this.workStoreRef);
            this.archiveStoreRef = this.nodeService.createStore("workspace", "archive" + this.getName() + System.currentTimeMillis());
            this.archiveStoreRootNodeRef = this.nodeService.getRootNode(this.archiveStoreRef);
            StoreArchiveMap archiveMap = (StoreArchiveMap)ctx.getBean("storeArchiveMap");
            archiveMap.put(this.workStoreRef, this.archiveStoreRef);
            TestWithUserUtils.createUser(USER_A, USER_A, this.workStoreRootNodeRef, this.nodeService, this.authenticationService);
            TestWithUserUtils.createUser(USER_B, USER_B, this.workStoreRootNodeRef, this.nodeService, this.authenticationService);
            this.permissionService.setPermission(this.workStoreRootNodeRef, USER_A, "All", true);
            this.permissionService.setPermission(this.workStoreRootNodeRef, USER_B, "All", true);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.authenticationComponent.clearCurrentSecurityContext();
            throw throwable;
        }
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationService.authenticate(USER_A, USER_A.toCharArray());
        this.createNodeStructure();
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createNodeStructure() throws Exception {
        HashMap<QName, String> properties = new HashMap<QName, String>(5);
        properties.put(ContentModel.PROP_NODE_UUID, "a");
        this.a = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_A, ContentModel.TYPE_FOLDER, properties).getChildRef();
        this.nodeService.addAspect(this.a, ASPECT_ATTACHABLE, null);
        properties.put(ContentModel.PROP_NODE_UUID, "aa");
        this.childAssocAtoAA = this.nodeService.createNode(this.a, ContentModel.ASSOC_CONTAINS, QNAME_AA, ContentModel.TYPE_CONTENT, properties);
        this.aa = this.childAssocAtoAA.getChildRef();
        this.nodeService.addAspect(this.aa, ASPECT_ATTACHABLE, null);
        properties.put(ContentModel.PROP_NODE_UUID, "b");
        this.b = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, QNAME_B, ContentModel.TYPE_FOLDER, properties).getChildRef();
        properties.put(ContentModel.PROP_NODE_UUID, "bb");
        this.childAssocBtoBB = this.nodeService.createNode(this.b, ContentModel.ASSOC_CONTAINS, QNAME_BB, ContentModel.TYPE_CONTENT, properties);
        this.bb = this.childAssocBtoBB.getChildRef();
        this.assocAtoB = this.nodeService.createAssociation(this.a, this.b, ASSOC_ATTACHMENTS);
        this.assocAAtoBB = this.nodeService.createAssociation(this.aa, this.bb, ASSOC_ATTACHMENTS);
        this.childAssocBtoAA = this.nodeService.addChild(this.b, this.aa, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"aa"));
        this.childAssocAtoBB = this.nodeService.addChild(this.a, this.bb, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"bb"));
        this.a_ = new NodeRef(this.archiveStoreRef, this.a.getId());
        this.b_ = new NodeRef(this.archiveStoreRef, this.b.getId());
        this.aa_ = new NodeRef(this.archiveStoreRef, this.aa.getId());
        this.bb_ = new NodeRef(this.archiveStoreRef, this.bb.getId());
        this.childAssocAtoAA_ = new ChildAssociationRef(this.childAssocAtoAA.getTypeQName(), this.a_, this.childAssocAtoAA.getQName(), this.aa_);
        this.childAssocBtoBB_ = new ChildAssociationRef(this.childAssocBtoBB.getTypeQName(), this.b_, this.childAssocBtoBB.getQName(), this.bb_);
    }

    private void verifyNodeExistence(NodeRef nodeRef, boolean exists) {
        ArchiveAndRestoreTest.assertEquals((String)("Node should " + (exists ? "" : "not") + "exist"), (boolean)exists, (boolean)this.nodeService.exists(nodeRef));
    }

    private void verifyChildAssocExistence(ChildAssociationRef childAssocRef, boolean exists) {
        List childAssocs = this.nodeService.getChildAssocs(childAssocRef.getParentRef(), (QNamePattern)childAssocRef.getTypeQName(), (QNamePattern)childAssocRef.getQName());
        if (exists) {
            ArchiveAndRestoreTest.assertEquals((String)("Expected exactly one match for child association: " + childAssocRef), (int)1, (int)childAssocs.size());
        } else {
            ArchiveAndRestoreTest.assertEquals((String)("Expected zero matches for child association: " + childAssocRef), (int)0, (int)childAssocs.size());
        }
    }

    private void verifyTargetAssocExistence(AssociationRef assocRef, boolean exists) {
        List assocs = this.nodeService.getTargetAssocs(assocRef.getSourceRef(), (QNamePattern)assocRef.getTypeQName());
        if (exists) {
            ArchiveAndRestoreTest.assertEquals((String)("Expected exactly one match for target association: " + assocRef), (int)1, (int)assocs.size());
        } else {
            ArchiveAndRestoreTest.assertEquals((String)("Expected zero matches for target association: " + assocRef), (int)0, (int)assocs.size());
        }
    }

    public void verifyAll() {
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyChildAssocExistence(this.childAssocAtoAA, true);
        this.verifyChildAssocExistence(this.childAssocBtoBB, true);
        this.verifyChildAssocExistence(this.childAssocAtoBB, true);
        this.verifyChildAssocExistence(this.childAssocBtoAA, true);
        this.verifyTargetAssocExistence(this.assocAtoB, true);
        this.verifyTargetAssocExistence(this.assocAAtoBB, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testSetUp() throws Exception {
        this.verifyAll();
    }

    public void testGetStoreArchiveNode() throws Exception {
        NodeRef archiveNodeRef = this.nodeService.getStoreArchiveNode(this.workStoreRef);
        ArchiveAndRestoreTest.assertEquals((String)"Mapping of archived store is not correct", (Object)this.archiveStoreRootNodeRef, (Object)archiveNodeRef);
    }

    public void testArchivedAspect() throws Exception {
        this.nodeService.deleteNode(this.a);
        ArchiveAndRestoreTest.assertTrue((String)"Archived aspect not present", (boolean)this.nodeService.hasAspect(this.a_, ContentModel.ASPECT_ARCHIVED));
        Map properties = this.nodeService.getProperties(this.a_);
        ArchiveAndRestoreTest.assertNotNull((String)"Original owner property not present", properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
        ArchiveAndRestoreTest.assertEquals((String)"Original owner property is incorrect", (Object)USER_A, properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER));
    }

    public void testArchiveAndRestoreNodeBB() throws Exception {
        this.nodeService.deleteNode(this.bb);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.bb_, true);
        Map bb_Properties = this.nodeService.getProperties(this.bb_);
        ChildAssociationRef bb_originalParent = (ChildAssociationRef)bb_Properties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        ArchiveAndRestoreTest.assertNotNull((String)"Original parent not stored", (Object)bb_originalParent);
        this.nodeService.restoreNode(this.bb_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreNodeB() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.b_, true);
        this.verifyNodeExistence(this.bb_, true);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreAll_B_A() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.nodeService.deleteNode(this.a);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreAll_A_B() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.verifyAll();
    }

    public void testArchiveAndRestoreWithMissingAssocTargets() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.nodeService.restoreNode(this.a_, null, null, null);
        this.nodeService.restoreNode(this.b_, null, null, null);
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyChildAssocExistence(this.childAssocAtoAA, true);
        this.verifyChildAssocExistence(this.childAssocBtoBB, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testTypeDetection() {
        this.nodeService.setType(this.a, ContentModel.TYPE_CONTAINER);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.a_, false);
    }

    public void testArchiveVsDeletePerformance() throws Exception {
        int iterations = 100;
        long cumulatedArchiveTimeNs = 0L;
        long cumulatedRestoreTimeNs = 0L;
        for (int i = 0; i < iterations; ++i) {
            long start = System.nanoTime();
            this.nodeService.deleteNode(this.b);
            long end = System.nanoTime();
            cumulatedArchiveTimeNs += end - start;
            start = System.nanoTime();
            this.nodeService.restoreNode(this.b_, null, null, null);
            end = System.nanoTime();
            cumulatedRestoreTimeNs += end - start;
        }
        double averageArchiveTimeMs = (double)cumulatedArchiveTimeNs / 1000000.0 / (double)iterations;
        double averageRestoreTimeMs = (double)cumulatedRestoreTimeNs / 1000000.0 / (double)iterations;
        System.out.println("Average archive time: " + averageArchiveTimeMs + " ms");
        System.out.println("Average restore time: " + averageRestoreTimeMs + " ms");
        StoreArchiveMap archiveMap = (StoreArchiveMap)ctx.getBean("storeArchiveMap");
        archiveMap.clear();
        long cumulatedDeleteTimeNs = 0L;
        long cumulatedCreateTimeNs = 0L;
        for (int i = 0; i < iterations; ++i) {
            long start = System.nanoTime();
            this.nodeService.deleteNode(this.b);
            long end = System.nanoTime();
            cumulatedDeleteTimeNs += end - start;
            this.nodeService.deleteNode(this.a);
            start = System.nanoTime();
            this.createNodeStructure();
            end = System.nanoTime();
            cumulatedCreateTimeNs += end - start;
        }
        double averageDeleteTimeMs = (double)cumulatedDeleteTimeNs / 1000000.0 / (double)iterations;
        double averageCreateTimeMs = (double)cumulatedCreateTimeNs / 1000000.0 / (double)iterations;
        System.out.println("Average delete time: " + averageDeleteTimeMs + " ms");
        System.out.println("Average create time: " + averageCreateTimeMs + " ms");
    }

    public void testInTransactionRestore() throws Exception {
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.a_);
        ArchiveAndRestoreTest.assertEquals((String)"Expected failure", (Object)((Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_ARCHIVE_NODE), (Object)((Object)report.getStatus()));
        ArchiveAndRestoreTest.assertEquals((String)"Transaction should still be valid", (int)0, (int)this.txn.getStatus());
    }

    public void testInTransactionPurge() throws Exception {
        this.nodeArchiveService.purgeArchivedNode(this.a_);
        ArchiveAndRestoreTest.assertEquals((String)"Transaction should still be valid", (int)0, (int)this.txn.getStatus());
    }

    private void commitAndBeginNewTransaction() throws Exception {
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    public void testRestoreToMissingParent() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.b_, this.a, null, null);
        ArchiveAndRestoreTest.assertEquals((String)"Incorrect report status", (Object)((Object)RestoreNodeReport.RestoreStatus.FAILURE_INVALID_PARENT), (Object)((Object)report.getStatus()));
    }

    public void testMassRestore() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        List<RestoreNodeReport> reports = this.nodeArchiveService.restoreAllArchivedNodes(this.workStoreRef);
        ArchiveAndRestoreTest.assertEquals((String)"Incorrect number of node reports", (int)2, (int)reports.size());
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.aa, true);
        this.verifyNodeExistence(this.bb, true);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testMassPurge() throws Exception {
        this.nodeService.deleteNode(this.a);
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
        this.nodeArchiveService.purgeAllArchivedNodes(this.workStoreRef);
        this.commitAndBeginNewTransaction();
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.aa, false);
        this.verifyNodeExistence(this.bb, false);
        this.verifyNodeExistence(this.a_, false);
        this.verifyNodeExistence(this.b_, false);
        this.verifyNodeExistence(this.aa_, false);
        this.verifyNodeExistence(this.bb_, false);
    }

    public void testDeletedOwnership() throws Exception {
        String bOwner = this.ownableService.getOwner(this.b);
        ArchiveAndRestoreTest.assertEquals((String)"User A must own 'b'", (String)USER_A, (String)bOwner);
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        this.nodeService.deleteNode(this.b);
        String b_Owner = this.ownableService.getOwner(this.b_);
        ArchiveAndRestoreTest.assertEquals((String)"User B must own 'b_'", (String)USER_B, (String)b_Owner);
    }

    public void testPermissionsForRestore() throws Exception {
        this.authenticationService.authenticate(USER_A, USER_A.toCharArray());
        this.nodeService.deleteNode(this.a);
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        this.nodeService.deleteNode(this.b);
        this.commitAndBeginNewTransaction();
        List<RestoreNodeReport> restoredByB = this.nodeArchiveService.restoreAllArchivedNodes(this.workStoreRef);
        ArchiveAndRestoreTest.assertEquals((String)"User B should be able to see only B's delete", (int)1, (int)restoredByB.size());
    }

    public void testPermissionsLackingOnDestination() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.permissionService.setPermission(this.workStoreRootNodeRef, USER_B, "AddChildren", false);
        this.commitAndBeginNewTransaction();
        this.authenticationService.authenticate(USER_B, USER_B.toCharArray());
        RestoreNodeReport report = this.nodeArchiveService.restoreArchivedNode(this.b_);
        ArchiveAndRestoreTest.assertEquals((String)"Expected permission denied status", (Object)((Object)RestoreNodeReport.RestoreStatus.FAILURE_PERMISSION), (Object)((Object)report.getStatus()));
    }

    public void testAR1519ArchiveCleansDuplicateUuid() throws Exception {
        this.nodeService.deleteNode(this.b);
        this.verifyNodeExistence(this.b_, true);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a_, true);
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NODE_UUID, this.a.getId());
        NodeRef aRecreated = this.nodeService.createNode(this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
        ArchiveAndRestoreTest.assertEquals((String)"NodeRef for recreated node should be the same as the original", (Object)this.a, (Object)aRecreated);
        props.put(ContentModel.PROP_NODE_UUID, this.b.getId());
        NodeRef bRecreated = this.nodeService.createNode(this.a, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
        ArchiveAndRestoreTest.assertEquals((String)"NodeRef for recreated node should be the same as the original", (Object)this.b, (Object)bRecreated);
        this.verifyNodeExistence(this.a, true);
        this.verifyNodeExistence(this.b, true);
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
        this.nodeService.deleteNode(this.a);
        this.verifyNodeExistence(this.a, false);
        this.verifyNodeExistence(this.b, false);
        this.verifyNodeExistence(this.a_, true);
        this.verifyNodeExistence(this.b_, true);
    }
}

