/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.cleanup;

import java.util.Collections;
import java.util.List;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.cleanup.NodeCleanupRegistry;
import org.alfresco.repo.node.cleanup.NodeCleanupWorker;
import org.alfresco.repo.node.db.DbNodeServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeCleanupWorker
implements NodeCleanupWorker {
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"NodeCleanup");
    private static final long LOCK_TTL = 60000L;
    protected final Log logger;
    private NodeCleanupRegistry registry;
    protected TransactionService transactionService;
    protected JobLockService jobLockService;
    protected DbNodeServiceImpl dbNodeService;
    protected NodeDAO nodeDAO;
    private ThreadLocal<String> lockToken = new ThreadLocal();
    private VmShutdownListener shutdownListener = new VmShutdownListener("NodeCleanup");

    public AbstractNodeCleanupWorker() {
        this.logger = LogFactory.getLog(this.getClass());
    }

    public void setRegistry(NodeCleanupRegistry registry) {
        this.registry = registry;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setDbNodeService(DbNodeServiceImpl dbNodeService) {
        this.dbNodeService = dbNodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void register() {
        PropertyCheck.mandatory((Object)this, (String)"registry", (Object)this.registry);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"dbNodeService", (Object)this.dbNodeService);
        PropertyCheck.mandatory((Object)this, (String)"nodeDAO", (Object)this.nodeDAO);
        this.registry.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> doClean() {
        try {
            try {
                this.lockToken.set(null);
                String token = this.jobLockService.getLock(LOCK, 60000L);
                this.lockToken.set(token);
                List<String> list = this.doCleanWithTxn();
                Object var5_7 = null;
                String token2 = this.lockToken.get();
                if (token2 == null) return list;
                this.jobLockService.releaseLock(token2, LOCK);
                return list;
            }
            catch (LockAcquisitionException e) {
                List<String> list = Collections.singletonList("Node cleanup in process: " + e.getMessage());
                Object var5_8 = null;
                String token2 = this.lockToken.get();
                if (token2 == null) return list;
                this.jobLockService.releaseLock(token2, LOCK);
                return list;
            }
            catch (Throwable e) {
                StringBuilder sb;
                if (this.logger.isDebugEnabled()) {
                    sb = new StringBuilder(1024);
                    StackTraceUtil.buildStackTrace((String)("Node cleanup failed:    Worker: " + this.getClass().getName() + "\n" + "   Error:  " + e.getMessage()), (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)Integer.MAX_VALUE);
                    this.logger.debug((Object)sb.toString());
                }
                sb = new StringBuilder(1024);
                StackTraceUtil.buildStackTrace((String)("Node cleanup failed:    Worker: " + this.getClass().getName() + "\n" + "   Error:  " + e.getMessage()), (StackTraceElement[])e.getStackTrace(), (StringBuilder)sb, (int)20);
                List<String> list = Collections.singletonList(sb.toString());
                Object var5_9 = null;
                String token2 = this.lockToken.get();
                if (token2 == null) return list;
                this.jobLockService.releaseLock(token2, LOCK);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            String token2 = this.lockToken.get();
            if (token2 == null) throw throwable;
            this.jobLockService.releaseLock(token2, LOCK);
            throw throwable;
        }
    }

    private List<String> doCleanWithTxn() {
        final RetryingTransactionHelper.RetryingTransactionCallback<List<String>> doCleanCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            @Override
            public List<String> execute() throws Throwable {
                return AbstractNodeCleanupWorker.this.doCleanInternal();
            }
        };
        AuthenticationUtil.RunAsWork<List<String>> doCleanRunAs = new AuthenticationUtil.RunAsWork<List<String>>(){

            public List<String> doWork() throws Exception {
                return (List)AbstractNodeCleanupWorker.this.transactionService.getRetryingTransactionHelper().doInTransaction(doCleanCallback, false, true);
            }
        };
        return (List)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)doCleanRunAs, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void refreshLock() throws LockAcquisitionException {
        String token = this.lockToken.get();
        if (token != null && !this.shutdownListener.isVmShuttingDown()) {
            this.jobLockService.refreshLock(token, LOCK, 60000L);
        } else {
            this.jobLockService.refreshLock("lock token not available", LOCK, 60000L);
        }
    }

    protected abstract List<String> doCleanInternal() throws Throwable;
}

