/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.node.index.IndexTransactionTracker;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullIndexRecoveryComponent
extends AbstractReindexComponent {
    private static final String ERR_INDEX_OUT_OF_DATE = "index.recovery.out_of_date";
    private static final String MSG_TRACKING_STARTING = "index.tracking.starting";
    private static final String MSG_TRACKING_COMPLETE = "index.tracking.complete";
    private static final String MSG_TRACKING_PROGRESS = "index.tracking.progress";
    private static final String MSG_RECOVERY_STARTING = "index.recovery.starting";
    private static final String MSG_RECOVERY_COMPLETE = "index.recovery.complete";
    private static final String MSG_RECOVERY_PROGRESS = "index.recovery.progress";
    private static final String MSG_RECOVERY_TERMINATED = "index.recovery.terminated";
    private static final String MSG_RECOVERY_ERROR = "index.recovery.error";
    private static Log logger = LogFactory.getLog(FullIndexRecoveryComponent.class);
    private RecoveryMode recoveryMode = RecoveryMode.VALIDATE;
    private boolean lockServer;
    private IndexTransactionTracker indexTracker;
    private boolean stopOnError;
    private int maxTransactionsPerLuceneCommit = 100;
    private static final int MAX_TRANSACTIONS_PER_ITERATION = 1000;

    public void setRecoveryMode(String recoveryMode) {
        this.recoveryMode = RecoveryMode.valueOf(recoveryMode);
    }

    public void setMaxTransactionsPerLuceneCommit(int maxTransactionsPerLuceneCommit) {
        this.maxTransactionsPerLuceneCommit = maxTransactionsPerLuceneCommit;
    }

    public void setLockServer(boolean lockServer) {
        this.lockServer = lockServer;
    }

    public void setIndexTracker(IndexTransactionTracker indexTracker) {
        this.indexTracker = indexTracker;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void reindexImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing index recovery for type: " + (Object)((Object)this.recoveryMode)));
        }
        if (this.recoveryMode == RecoveryMode.NONE) {
            return;
        }
        boolean allowWrite = !this.transactionService.isReadOnly();
        try {
            if (this.lockServer) {
                this.transactionService.setAllowWrite(false);
            }
            List<Transaction> startTxns = this.nodeDAO.getTxnsByCommitTimeAscending(Long.MIN_VALUE, Long.MAX_VALUE, 1000, null, false);
            AbstractReindexComponent.InIndex startAllPresent = this.areTxnsInStartSample(startTxns);
            List<Transaction> endTxns = this.nodeDAO.getTxnsByCommitTimeDescending(Long.MIN_VALUE, Long.MAX_VALUE, 1000, null, false);
            AbstractReindexComponent.InIndex endAllPresent = this.areAllTxnsInEndSample(endTxns);
            switch (this.recoveryMode) {
                case AUTO: {
                    if (startAllPresent == AbstractReindexComponent.InIndex.NO) {
                        this.performFullRecovery();
                        return;
                    }
                    if (endAllPresent != AbstractReindexComponent.InIndex.NO) return;
                    this.performPartialRecovery();
                    return;
                }
                case VALIDATE: {
                    if (startAllPresent != AbstractReindexComponent.InIndex.NO) {
                        if (endAllPresent != AbstractReindexComponent.InIndex.NO) return;
                    }
                    logger.warn((Object)I18NUtil.getMessage((String)ERR_INDEX_OUT_OF_DATE));
                    return;
                }
                case FULL: {
                    this.performFullRecovery();
                    return;
                }
            }
            return;
        }
        finally {
            this.transactionService.setAllowWrite(allowWrite);
        }
    }

    protected AbstractReindexComponent.InIndex areAllTxnsInEndSample(List<Transaction> txns) {
        int count = 0;
        int yesCount = 0;
        for (Transaction txn : txns) {
            ++count;
            if (this.isTxnPresentInIndex(txn) == AbstractReindexComponent.InIndex.NO) {
                return AbstractReindexComponent.InIndex.NO;
            }
            if (this.isTxnPresentInIndex(txn) != AbstractReindexComponent.InIndex.YES || ++yesCount <= 1 || count < 10) continue;
            return AbstractReindexComponent.InIndex.YES;
        }
        return AbstractReindexComponent.InIndex.INDETERMINATE;
    }

    protected AbstractReindexComponent.InIndex areTxnsInStartSample(List<Transaction> txns) {
        int count = 0;
        AbstractReindexComponent.InIndex current = AbstractReindexComponent.InIndex.INDETERMINATE;
        for (Transaction txn : txns) {
            ++count;
            current = this.isTxnPresentInIndex(txn);
            if (current == AbstractReindexComponent.InIndex.NO) {
                return AbstractReindexComponent.InIndex.NO;
            }
            if (current != AbstractReindexComponent.InIndex.YES || count < 10) continue;
            return AbstractReindexComponent.InIndex.YES;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPartialRecovery() {
        IndexTransactionTracker.IndexTransactionTrackerListener trackerListener = new IndexTransactionTracker.IndexTransactionTrackerListener(){
            long lastLogged = 0L;

            public void indexedTransactions(long fromTimeInclusive, long toTimeExclusive) {
                long now = System.currentTimeMillis();
                if (now - this.lastLogged < 10000L) {
                    return;
                }
                this.lastLogged = now;
                Date toTimeDate = new Date(toTimeExclusive);
                String msgAutoProgress = I18NUtil.getMessage((String)FullIndexRecoveryComponent.MSG_TRACKING_PROGRESS, (Object[])new Object[]{toTimeDate.toString()});
                logger.info((Object)msgAutoProgress);
            }
        };
        try {
            this.indexTracker.setListener(trackerListener);
            logger.info((Object)I18NUtil.getMessage((String)MSG_TRACKING_STARTING));
            this.indexTracker.reindex();
            logger.info((Object)I18NUtil.getMessage((String)MSG_TRACKING_COMPLETE));
        }
        finally {
            this.indexTracker.setListener(null);
        }
    }

    private void performFullRecovery() {
        List<Transaction> nextTxns;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                for (StoreRef storeRef : FullIndexRecoveryComponent.this.nodeService.getStores()) {
                    if (storeRef.getProtocol().equals("avm")) continue;
                    FullIndexRecoveryComponent.this.indexer.deleteIndex(storeRef);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteWork, true, true);
        int txnCount = this.nodeDAO.getTransactionCount();
        String msgStart = I18NUtil.getMessage((String)MSG_RECOVERY_STARTING, (Object[])new Object[]{txnCount});
        logger.info((Object)msgStart);
        int processedCount = 0;
        long fromTimeInclusive = Long.MIN_VALUE;
        long toTimeExclusive = Long.MAX_VALUE;
        List<Long> lastTxnIds = Collections.emptyList();
        do {
            nextTxns = this.nodeDAO.getTxnsByCommitTimeAscending(fromTimeInclusive, toTimeExclusive, 1000, lastTxnIds, false);
            lastTxnIds = new ArrayList<Long>(nextTxns.size());
            ArrayList<Long> txnIdBuffer = new ArrayList<Long>(this.maxTransactionsPerLuceneCommit);
            Iterator<Transaction> txnIterator = nextTxns.iterator();
            while (txnIterator.hasNext()) {
                Transaction txn = txnIterator.next();
                Long txnId = txn.getId();
                lastTxnIds.add(txnId);
                if (this.isShuttingDown()) {
                    String msgTerminated = I18NUtil.getMessage((String)MSG_RECOVERY_TERMINATED);
                    logger.warn((Object)msgTerminated);
                    return;
                }
                if (this.stopOnError) {
                    this.reindexTransaction(txnId);
                } else {
                    txnIdBuffer.add(txnId);
                    if (!txnIterator.hasNext() || txnIdBuffer.size() >= this.maxTransactionsPerLuceneCommit) {
                        try {
                            this.reindexTransactionAsynchronously(txnIdBuffer);
                        }
                        catch (Throwable e) {
                            String msgError = I18NUtil.getMessage((String)MSG_RECOVERY_ERROR, (Object[])new Object[]{txnId, e.getMessage()});
                            logger.info((Object)msgError, e);
                        }
                        txnIdBuffer = new ArrayList(this.maxTransactionsPerLuceneCommit);
                    }
                }
                fromTimeInclusive = txn.getCommitTimeMs();
                double before = (double)processedCount / (double)txnCount * 10.0;
                double after = (double)(++processedCount) / (double)txnCount * 10.0;
                if (!(Math.floor(before) < Math.floor(after))) continue;
                int complete = (int)Math.floor(after) * 10;
                String msgProgress = I18NUtil.getMessage((String)MSG_RECOVERY_PROGRESS, (Object[])new Object[]{complete});
                logger.info((Object)msgProgress);
            }
            this.waitForAsynchronousReindexing();
        } while (nextTxns.size() != 0);
        String msgDone = I18NUtil.getMessage((String)MSG_RECOVERY_COMPLETE);
        logger.info((Object)msgDone);
    }

    public void reindexTransaction(final long txnId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reindexing transaction: " + txnId));
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                List<NodeRef.Status> nodeStatuses = FullIndexRecoveryComponent.this.nodeDAO.getTxnChanges(txnId);
                for (NodeRef.Status nodeStatus : nodeStatuses) {
                    NodeRef nodeRef = nodeStatus.getNodeRef();
                    if (nodeStatus.isDeleted()) {
                        ChildAssociationRef assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                        FullIndexRecoveryComponent.this.indexer.deleteNode(assocRef);
                        continue;
                    }
                    FullIndexRecoveryComponent.this.indexer.updateNode(nodeRef);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecoveryMode {
        NONE,
        VALIDATE,
        AUTO,
        FULL;

    }
}

