/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.util.List;
import org.alfresco.repo.node.integrity.AbstractIntegrityEvent;
import org.alfresco.repo.node.integrity.IntegrityRecord;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssocSourceMultiplicityIntegrityEvent
extends AbstractIntegrityEvent {
    private static Log logger = LogFactory.getLog(AssocSourceMultiplicityIntegrityEvent.class);
    private boolean isDelete;

    public AssocSourceMultiplicityIntegrityEvent(NodeService nodeService, DictionaryService dictionaryService, NodeRef targetNodeRef, QName assocTypeQName, boolean isDelete) {
        super(nodeService, dictionaryService, targetNodeRef, assocTypeQName, null);
        this.isDelete = isDelete;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AssocSourceMultiplicityIntegrityEvent that = (AssocSourceMultiplicityIntegrityEvent)obj;
        return this.isDelete == that.isDelete;
    }

    @Override
    public void checkIntegrity(List<IntegrityRecord> eventResults) {
        QName assocTypeQName = this.getTypeQName();
        NodeRef targetNodeRef = this.getNodeRef();
        QName targetNodeTypeQName = this.getNodeType(targetNodeRef);
        if (targetNodeTypeQName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring integrity check - node gone: \n   event: " + this));
            }
            return;
        }
        AssociationDefinition assocDef = this.getAssocDef(eventResults, assocTypeQName);
        if (assocDef == null) {
            if (!this.isDelete) {
                IntegrityRecord result = new IntegrityRecord("Association type does not exist: \n   Target Node: " + targetNodeRef + "\n" + "   Target Node Type: " + targetNodeTypeQName + "\n" + "   Association Type: " + assocTypeQName);
                eventResults.add(result);
                return;
            }
            return;
        }
        this.checkSourceMultiplicity(eventResults, assocDef, assocTypeQName, targetNodeRef);
    }

    protected void checkSourceMultiplicity(List<IntegrityRecord> eventResults, AssociationDefinition assocDef, QName assocTypeQName, NodeRef targetNodeRef) {
        ClassDefinition classDef;
        boolean mandatory = assocDef.isSourceMandatory();
        boolean allowMany = assocDef.isSourceMany();
        if (!mandatory && allowMany) {
            return;
        }
        if (this.isDelete && (classDef = assocDef.getTargetClass()).isAspect() && !this.nodeService.hasAspect(targetNodeRef, classDef.getName())) {
            return;
        }
        int actualSize = 0;
        if (assocDef.isChild()) {
            List parentAssocRefs = this.nodeService.getParentAssocs(targetNodeRef, (QNamePattern)assocTypeQName, RegexQNamePattern.MATCH_ALL);
            actualSize = parentAssocRefs.size();
        } else {
            List sourceAssocRefs = this.nodeService.getSourceAssocs(targetNodeRef, (QNamePattern)assocTypeQName);
            actualSize = sourceAssocRefs.size();
        }
        if (mandatory && actualSize == 0 || !allowMany && actualSize > 1) {
            String parentOrSourceStr = assocDef.isChild() ? "parent" : "source";
            IntegrityRecord result = new IntegrityRecord("The association " + parentOrSourceStr + " multiplicity has been violated: \n" + "   Target Node: " + targetNodeRef + "\n" + "   Association: " + assocDef + "\n" + "   Required " + parentOrSourceStr + " Multiplicity: " + this.getMultiplicityString(mandatory, allowMany) + "\n" + "   Actual " + parentOrSourceStr + " Multiplicity: " + actualSize);
            eventResults.add(result);
        }
    }
}

