/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.CachedPolicyFactory;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.PolicyList;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPolicyDelegate<P extends ClassPolicy> {
    private DictionaryService dictionary;
    private CachedPolicyFactory<ClassBehaviourBinding, P> factory;

    ClassPolicyDelegate(DictionaryService dictionary, Class<P> policyClass, BehaviourIndex<ClassBehaviourBinding> index) {
        Collection<BehaviourDefinition> definitions = index.getAll();
        for (BehaviourDefinition definition : definitions) {
            definition.getBehaviour().getInterface(policyClass);
        }
        this.factory = new CachedPolicyFactory<ClassBehaviourBinding, P>(policyClass, index);
        this.dictionary = dictionary;
    }

    public P get(QName classQName) {
        return this.get(null, classQName);
    }

    public P get(NodeRef nodeRef, QName classQName) {
        ClassDefinition classDefinition = this.dictionary.getClass(classQName);
        if (classDefinition == null) {
            throw new IllegalArgumentException("Class " + classQName + " has not been defined in the data dictionary");
        }
        return (P)((ClassPolicy)this.factory.create(new ClassBehaviourBinding(this.dictionary, nodeRef, classQName)));
    }

    public Collection<P> getList(QName classQName) {
        return this.getList(null, classQName);
    }

    public Collection<P> getList(NodeRef nodeRef, QName classQName) {
        ClassDefinition classDefinition = this.dictionary.getClass(classQName);
        if (classDefinition == null) {
            throw new IllegalArgumentException("Class " + classQName + " has not been defined in the data dictionary");
        }
        return this.factory.createList(new ClassBehaviourBinding(this.dictionary, nodeRef, classQName));
    }

    public P get(Set<QName> classQNames) {
        return this.get(null, classQNames);
    }

    public P get(NodeRef nodeRef, Set<QName> classQNames) {
        return (P)((ClassPolicy)this.factory.toPolicy(this.getList(nodeRef, classQNames)));
    }

    public Collection<P> getList(Set<QName> classQNames) {
        return this.getList(null, classQNames);
    }

    public Collection<P> getList(NodeRef nodeRef, Set<QName> classQNames) {
        HashSet<Object> policies = new HashSet<Object>();
        for (QName classQName : classQNames) {
            ClassPolicy policy = (ClassPolicy)this.factory.create(new ClassBehaviourBinding(this.dictionary, nodeRef, classQName));
            if (policy instanceof PolicyList) {
                policies.addAll(((PolicyList)((Object)policy)).getPolicies());
                continue;
            }
            policies.add(policy);
        }
        return policies;
    }
}

