/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicy;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyComponentTransactionTest
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/policy/policycomponenttest_model.xml";
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
    private static QName BASE_TYPE = QName.createQName((String)"http://www.alfresco.org/test/policycomponenttest/1.0", (String)"base");
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private static ClassPolicyDelegate<SideEffectTestPolicy> sideEffectDelegate = null;
    private PolicyComponent policyComponent;
    private TransactionService trxService;
    private AuthenticationComponent authenticationComponent;

    protected void setUp() throws Exception {
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO((DictionaryDAO)applicationContext.getBean("dictionaryDAO"));
        bootstrap.setTenantService((TenantService)applicationContext.getBean("tenantService"));
        bootstrap.bootstrap();
        this.policyComponent = (PolicyComponent)applicationContext.getBean("policyComponent");
        this.trxService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        if (sideEffectDelegate == null) {
            sideEffectDelegate = this.policyComponent.registerClassPolicy(SideEffectTestPolicy.class);
            QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"sideEffect");
            JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "sideEffectTest", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
            this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        }
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testStartTransactionPolicy() throws Exception {
        ClassPolicyDelegate<StartTestPolicy> startDelegate = this.policyComponent.registerClassPolicy(StartTestPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"start");
        PolicyDefinition<Policy> definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTransactionTest.assertNotNull(definition);
        Policy.Arg arg0 = definition.getArgument(0);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.KEY), (Object)((Object)arg0));
        Policy.Arg arg1 = definition.getArgument(1);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.KEY), (Object)((Object)arg1));
        Policy.Arg arg2 = definition.getArgument(2);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.START_VALUE), (Object)((Object)arg2));
        Policy.Arg arg3 = definition.getArgument(3);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.END_VALUE), (Object)((Object)arg3));
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "startTransactionTest", Behaviour.NotificationFrequency.FIRST_EVENT);
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        UserTransaction userTransaction1 = this.trxService.getUserTransaction();
        try {
            userTransaction1.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            StartTestPolicy basePolicy = startDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.start("1", "2", "value1a", "value2a", false, results);
            TestResult result1 = new TestResult("startTransactionTest", "1", "2", "value1a", "value2a");
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)1, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            String baseResult2 = basePolicy.start("2", "1", "value1b", "value2b", false, results);
            TestResult result2 = new TestResult("startTransactionTest", "2", "1", "value1b", "value2b");
            PolicyComponentTransactionTest.assertEquals((String)result2.toString(), (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            String baseResult3 = basePolicy.start("1", "2", "value1c", "value2c", false, results);
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            userTransaction1.commit();
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
        }
        catch (Exception e) {
            try {
                userTransaction1.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
        UserTransaction userTransaction2 = this.trxService.getUserTransaction();
        try {
            userTransaction2.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            StartTestPolicy basePolicy = startDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.start("1", "2", "value1a", "value2a", true, results);
            TestResult result1 = new TestResult("startTransactionTest", "1", "2", "value1a", "value2a");
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)1, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            String baseResult2 = basePolicy.start("2", "1", "value1b", "value2b", true, results);
            TestResult result2 = new TestResult("startTransactionTest", "2", "1", "value1b", "value2b");
            PolicyComponentTransactionTest.assertEquals((String)result2.toString(), (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            String baseResult3 = basePolicy.start("1", "2", "value1c", "value2c", true, results);
            PolicyComponentTransactionTest.assertEquals((String)result1.toString(), (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            TestResult result3 = new TestResult("sideEffectTest", "1", "2", "value1a", "value2a");
            TestResult result4 = new TestResult("sideEffectTest", "2", "1", "value1b", "value2b");
            userTransaction2.commit();
            PolicyComponentTransactionTest.assertEquals((int)4, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            PolicyComponentTransactionTest.assertEquals((Object)result3, results.get(2));
            PolicyComponentTransactionTest.assertEquals((Object)result4, results.get(3));
        }
        catch (Exception e) {
            try {
                userTransaction2.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public void testEndTransactionPolicy() throws Exception {
        ClassPolicyDelegate<EndTestPolicy> endDelegate = this.policyComponent.registerClassPolicy(EndTestPolicy.class);
        QName policyName = QName.createQName((String)TEST_NAMESPACE, (String)"end");
        PolicyDefinition<Policy> definition = this.policyComponent.getRegisteredPolicy(PolicyType.Class, policyName);
        PolicyComponentTransactionTest.assertNotNull(definition);
        Policy.Arg arg0 = definition.getArgument(0);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.KEY), (Object)((Object)arg0));
        Policy.Arg arg1 = definition.getArgument(1);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.KEY), (Object)((Object)arg1));
        Policy.Arg arg2 = definition.getArgument(2);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.START_VALUE), (Object)((Object)arg2));
        Policy.Arg arg3 = definition.getArgument(3);
        PolicyComponentTransactionTest.assertEquals((Object)((Object)Policy.Arg.END_VALUE), (Object)((Object)arg3));
        JavaBehaviour baseBehaviour = new JavaBehaviour((Object)this, "endTransactionTest", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.policyComponent.bindClassBehaviour(policyName, BASE_TYPE, (Behaviour)baseBehaviour);
        UserTransaction userTransaction1 = this.trxService.getUserTransaction();
        try {
            userTransaction1.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            EndTestPolicy basePolicy = endDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.end("1", "2", "value1a", "value2a", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult2 = basePolicy.end("2", "1", "value1b", "value2b", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult3 = basePolicy.end("1", "2", "value1a", "value2c", false, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            TestResult result1 = new TestResult("endTransactionTest", "1", "2", "value1a", "value2c");
            TestResult result2 = new TestResult("endTransactionTest", "2", "1", "value1b", "value2b");
            userTransaction1.commit();
            PolicyComponentTransactionTest.assertEquals((int)2, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
        }
        catch (Exception e) {
            try {
                userTransaction1.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
        UserTransaction userTransaction2 = this.trxService.getUserTransaction();
        try {
            userTransaction2.begin();
            ArrayList<TestResult> results = new ArrayList<TestResult>();
            EndTestPolicy basePolicy = endDelegate.get(BASE_TYPE);
            String baseResult1 = basePolicy.end("1", "2", "value1a", "value2a", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult1);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult2 = basePolicy.end("2", "1", "value1b", "value2b", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult2);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            String baseResult3 = basePolicy.end("1", "2", "value1a", "value2c", true, results);
            PolicyComponentTransactionTest.assertEquals(null, (String)baseResult3);
            PolicyComponentTransactionTest.assertEquals((int)0, (int)results.size());
            TestResult result1 = new TestResult("endTransactionTest", "1", "2", "value1a", "value2c");
            TestResult result2 = new TestResult("endTransactionTest", "2", "1", "value1b", "value2b");
            TestResult result3 = new TestResult("sideEffectTest", "1", "2", "value1a", "value2c");
            TestResult result4 = new TestResult("sideEffectTest", "2", "1", "value1b", "value2b");
            userTransaction2.commit();
            PolicyComponentTransactionTest.assertEquals((int)4, (int)results.size());
            PolicyComponentTransactionTest.assertEquals((Object)result1, results.get(0));
            PolicyComponentTransactionTest.assertEquals((Object)result2, results.get(1));
            PolicyComponentTransactionTest.assertEquals((Object)result3, results.get(2));
            PolicyComponentTransactionTest.assertEquals((Object)result4, results.get(3));
        }
        catch (Exception e) {
            try {
                userTransaction2.rollback();
            }
            catch (IllegalStateException ee) {
                // empty catch block
            }
            throw e;
        }
    }

    public String startTransactionTest(String key1, String key2, String arg1, String arg2, boolean sideEffect, List<TestResult> results) {
        TestResult result = new TestResult("startTransactionTest", key1, key2, arg1, arg2);
        results.add(result);
        if (sideEffect) {
            SideEffectTestPolicy policy = sideEffectDelegate.get(BASE_TYPE);
            policy.sideEffect(key1, key2, arg1, arg2, results);
        }
        return result.toString();
    }

    public String endTransactionTest(String key1, String key2, String arg1, String arg2, boolean sideEffect, List<TestResult> results) {
        TestResult result = new TestResult("endTransactionTest", key1, key2, arg1, arg2);
        results.add(result);
        if (sideEffect) {
            SideEffectTestPolicy policy = sideEffectDelegate.get(BASE_TYPE);
            policy.sideEffect(key1, key2, arg1, arg2, results);
        }
        return result.toString();
    }

    public String sideEffectTest(String key1, String key2, String arg1, String arg2, List<TestResult> results) {
        TestResult result = new TestResult("sideEffectTest", key1, key2, arg1, arg2);
        results.add(result);
        return result.toString();
    }

    private class TestResult {
        private String trxId = AlfrescoTransactionSupport.getTransactionId();
        private String behaviour;
        private String key1;
        private String key2;
        private String arg1;
        private String arg2;

        public TestResult(String behaviour, String key1, String key2, String arg1, String arg2) {
            this.behaviour = behaviour;
            this.key1 = key1;
            this.key2 = key2;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TestResult) {
                TestResult that = (TestResult)obj;
                return this.trxId.equals(that.trxId) && this.behaviour.equals(that.behaviour) && this.key1.equals(that.key1) && this.key2.equals(that.key2) && this.arg1.equals(that.arg1) && this.arg2.equals(that.arg2);
            }
            return false;
        }

        public String toString() {
            return "trxId=" + this.trxId + ", behaviour=" + this.behaviour + ", key1=" + this.key1 + ", key2=" + this.key2 + ", arg1=" + this.arg1 + ", arg2=" + this.arg2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SideEffectTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;

        public String sideEffect(String var1, String var2, String var3, String var4, List<TestResult> var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EndTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_2 = Policy.Arg.START_VALUE;
        public static final Policy.Arg ARG_3 = Policy.Arg.END_VALUE;

        public String end(String var1, String var2, String var3, String var4, boolean var5, List<TestResult> var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface StartTestPolicy
    extends ClassPolicy {
        public static final String NAMESPACE = "http://www.alfresco.org/test/policycomponenttest/1.0";
        public static final Policy.Arg ARG_0 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_1 = Policy.Arg.KEY;
        public static final Policy.Arg ARG_2 = Policy.Arg.START_VALUE;
        public static final Policy.Arg ARG_3 = Policy.Arg.END_VALUE;

        public String start(String var1, String var2, String var3, String var4, boolean var5, List<TestResult> var6);
    }
}

